/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncParser {
    private static Logger LOG = LoggerFactory.getLogger(AsyncParser.class);
    private static int chunkSize = 100000;
    private static int queueSize = 10;
    private static List<EltStreamRDF> END = List.of();
    private static Function<EltStreamRDF, Triple> elt2Triple = x -> {
        if (x.exception != null) {
            throw x.exception;
        }
        if (x.quad != null) {
            Node g = x.quad.getGraph();
            if (g == Quad.tripleInQuad || Quad.isDefaultGraph(g)) {
                return x.quad.asTriple();
            }
            return null;
        }
        return x.triple;
    };
    private static Function<EltStreamRDF, Quad> elt2Quad = x -> {
        if (x.exception != null) {
            throw x.exception;
        }
        if (x.triple != null) {
            return Quad.create(Quad.defaultGraphIRI, x.triple);
        }
        return x.quad;
    };

    private AsyncParser() {
    }

    public static void asyncParse(String filesOrURL, StreamRDF output) {
        AsyncParser.asyncParse(List.of(filesOrURL), output);
    }

    public static void asyncParse(List<String> filesOrURLs, StreamRDF output) {
        Objects.requireNonNull(filesOrURLs);
        Objects.requireNonNull(output);
        LOG.debug("Parse: " + filesOrURLs);
        AsyncParser.asyncParseSources(AsyncParser.urlsToSource(filesOrURLs), output);
    }

    public static void asyncParse(InputStream input, Lang lang, String baseURI, StreamRDF output) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(lang);
        Objects.requireNonNull(output);
        AsyncParser.asyncParseSources(AsyncParser.inputStreamToSource(input, lang, baseURI), output);
    }

    public static void asyncParseSources(List<RDFParserBuilder> sources, StreamRDF output) {
        Logger LOG1 = LOG;
        Logger LOG2 = LOG;
        ArrayBlockingQueue<List<EltStreamRDF>> queue = new ArrayBlockingQueue<List<EltStreamRDF>>(queueSize);
        AsyncParser.startParserThread(LOG1, sources, queue);
        AsyncParser.receiver(LOG2, queue, output);
    }

    private static List<RDFParserBuilder> urlsToSource(List<String> filesOrURLs) {
        return filesOrURLs.stream().map(uriOrFile -> RDFParser.source(uriOrFile)).collect(Collectors.toList());
    }

    private static List<RDFParserBuilder> inputStreamToSource(InputStream input, Lang lang, String baseURI) {
        return List.of(RDFParser.source(input).lang(lang));
    }

    public static Iterator<Triple> asyncParseTriples(String fileOrURL) {
        return AsyncParser.asyncParseTriples(List.of(fileOrURL));
    }

    public static Iterator<Triple> asyncParseTriples(List<String> filesOrURLs) {
        Iterator<EltStreamRDF> source = AsyncParser.asyncParseIterator(AsyncParser.urlsToSource(filesOrURLs));
        return Iter.iter(source).map(elt2Triple).removeNulls();
    }

    public static Iterator<Triple> asyncParseTriples(InputStream input, Lang lang, String baseURI) {
        Iterator<EltStreamRDF> source = AsyncParser.asyncParseIterator(AsyncParser.inputStreamToSource(input, lang, baseURI));
        return Iter.iter(source).map(elt2Triple).removeNulls();
    }

    public static Iterator<Quad> asyncParseQuads(String fileOrURL) {
        return AsyncParser.asyncParseQuads(List.of(fileOrURL));
    }

    public static Iterator<Quad> asyncParseQuads(List<String> filesOrURLs) {
        Iterator<EltStreamRDF> source = AsyncParser.asyncParseIterator(AsyncParser.urlsToSource(filesOrURLs));
        return Iter.iter(source).map(elt2Quad).removeNulls();
    }

    public static Iterator<Quad> asyncParseQuads(InputStream input, Lang lang, String baseURI) {
        Iterator<EltStreamRDF> source = AsyncParser.asyncParseIterator(AsyncParser.inputStreamToSource(input, lang, baseURI));
        return Iter.iter(source).map(elt2Quad).removeNulls();
    }

    private static Iterator<EltStreamRDF> asyncParseIterator(List<RDFParserBuilder> sources) {
        ArrayBlockingQueue<List<EltStreamRDF>> queue = new ArrayBlockingQueue<List<EltStreamRDF>>(queueSize);
        AsyncParser.startParserThread(LOG, sources, queue);
        Iterator<List> blocks = AsyncParser.blockingIterator(queue, x -> x == END);
        Iterator elements = Iter.flatMap(blocks, x -> x.iterator());
        return elements;
    }

    private static <X> Iterator<X> blockingIterator(final BlockingQueue<X> queue, final Predicate<X> endTest) {
        return new IteratorSlotted<X>(){
            boolean ended = false;

            protected X moveToNext() {
                try {
                    Object x = queue.take();
                    if (endTest.test(x)) {
                        this.ended = true;
                        return null;
                    }
                    return x;
                }
                catch (InterruptedException e2) {
                    this.ended = true;
                    return null;
                }
            }

            protected boolean hasMore() {
                return !this.ended;
            }
        };
    }

    private static void startParserThread(final Logger LOG1, List<RDFParserBuilder> parserBuilders, BlockingQueue<List<EltStreamRDF>> queue) {
        Consumer<List<EltStreamRDF>> destination = batch -> {
            try {
                queue.put((List<EltStreamRDF>)batch);
            }
            catch (InterruptedException ex) {
                FmtLog.error((Logger)LOG, (String)"Error: %s", (Object[])new Object[]{ex.getMessage(), ex});
            }
        };
        EltStreamBatcher batcher = new EltStreamBatcher(destination, chunkSize);
        StreamToElements generatorStream = new StreamToElements(batcher);
        ErrorHandler errhandler = new ErrorHandler(){

            @Override
            public void warning(String message, long line, long col) {
                LOG1.warn(SysRIOT.fmtMessage(message, line, col));
            }

            @Override
            public void error(String message, long line, long col) {
                throw new RiotException(SysRIOT.fmtMessage(message, line, col));
            }

            @Override
            public void fatal(String message, long line, long col) {
                throw new RiotException(SysRIOT.fmtMessage(message, line, col));
            }
        };
        Runnable task = () -> {
            batcher.startBatching();
            if (LOG1.isDebugEnabled()) {
                LOG1.debug("Start parsing");
            }
            try {
                for (RDFParserBuilder parser : parserBuilders) {
                    parser.errorHandler(errhandler).parse(generatorStream);
                }
            }
            catch (RuntimeException ex) {
                EltStreamRDF elt = new EltStreamRDF();
                elt.exception = ex;
                batcher.accept(elt);
            }
            catch (Throwable cause) {
                EltStreamRDF elt = new EltStreamRDF();
                elt.exception = new RuntimeException(cause);
                batcher.accept(elt);
            }
            batcher.finishBatching();
            if (LOG1.isDebugEnabled()) {
                LOG1.debug("Finish parsing");
            }
        };
        Thread th = new Thread(task, "AsyncParser");
        th.setDaemon(true);
        th.start();
    }

    private static void dispatch(EltStreamRDF elt, StreamRDF stream) {
        if (elt.triple != null) {
            stream.triple(elt.triple);
        } else if (elt.quad != null) {
            stream.quad(elt.quad);
        } else if (elt.prefix != null) {
            stream.prefix(elt.prefix, elt.iri);
        } else if (elt.iri != null) {
            stream.base(elt.iri);
        } else {
            if (elt.exception != null) {
                throw elt.exception;
            }
            throw new InternalErrorException("Bad EltStreamRDF");
        }
    }

    private static void receiver(Logger LOG2, BlockingQueue<List<EltStreamRDF>> queue, StreamRDF output) {
        int count = 0;
        block2: while (true) {
            try {
                while (true) {
                    List<EltStreamRDF> batch;
                    if ((batch = queue.take()) == END) {
                        FmtLog.debug((Logger)LOG2, (String)"Receive: END (%,d)", (Object[])new Object[]{count});
                        break block2;
                    }
                    count += batch.size();
                    if (LOG.isDebugEnabled()) {
                        FmtLog.debug((Logger)LOG2, (String)"Receive: Batch : %,d (%,d)", (Object[])new Object[]{batch.size(), count});
                    }
                    AsyncParser.dispatch(batch, output);
                }
            }
            catch (InterruptedException e2) {
                FmtLog.error((Logger)LOG2, (String)"Interrupted", (Object[])new Object[]{e2});
                continue;
            }
            break;
        }
    }

    private static void dispatch(List<EltStreamRDF> batch, StreamRDF stream) {
        for (EltStreamRDF elt : batch) {
            AsyncParser.dispatch(elt, stream);
        }
    }

    private static class EltStreamBatcher
    implements Consumer<EltStreamRDF> {
        private final int batchSize;
        private List<EltStreamRDF> elements = null;
        private final Consumer<List<EltStreamRDF>> batchDestination;
        private int count = 0;

        public EltStreamBatcher(Consumer<List<EltStreamRDF>> batchDestination, int batchSize) {
            this.batchDestination = batchDestination;
            this.batchSize = batchSize;
        }

        public void startBatching() {
        }

        public void finishBatching() {
            if (this.elements != null) {
                this.dispatch(this.elements);
                this.elements = null;
            }
            this.dispatch(END);
        }

        private <X> boolean isEmpty(List<X> list) {
            return list == null || list.isEmpty();
        }

        @Override
        public void accept(EltStreamRDF elt) {
            if (this.elements == null) {
                this.elements = this.allocChunk();
            }
            this.elements.add(elt);
            this.maybeDispatch();
        }

        private void maybeDispatch() {
            long x = this.elements.size();
            if (x < (long)this.batchSize) {
                return;
            }
            this.dispatch(this.elements);
            this.elements = null;
        }

        private void dispatch(List<EltStreamRDF> batch) {
            this.count += batch.size();
            this.batchDestination.accept(batch);
        }

        private List<EltStreamRDF> allocChunk() {
            return new ArrayList<EltStreamRDF>(this.batchSize);
        }
    }

    private static class StreamToElements
    implements StreamRDF {
        private final Consumer<EltStreamRDF> destination;

        public StreamToElements(Consumer<EltStreamRDF> destination) {
            this.destination = destination;
        }

        @Override
        public void start() {
        }

        @Override
        public void finish() {
        }

        @Override
        public void triple(Triple triple) {
            EltStreamRDF elt = new EltStreamRDF();
            elt.triple = triple;
            this.deliver(elt);
        }

        @Override
        public void quad(Quad quad) {
            EltStreamRDF elt = new EltStreamRDF();
            elt.quad = quad;
            this.deliver(elt);
        }

        @Override
        public void base(String base) {
            EltStreamRDF elt = new EltStreamRDF();
            elt.iri = base;
            this.deliver(elt);
        }

        @Override
        public void prefix(String prefix, String iri) {
            EltStreamRDF elt = new EltStreamRDF();
            elt.prefix = prefix;
            elt.iri = iri;
            this.deliver(elt);
        }

        private void deliver(EltStreamRDF elt) {
            this.destination.accept(elt);
        }
    }

    private static class EltStreamRDF {
        Triple triple = null;
        Quad quad = null;
        String prefix = null;
        String iri = null;
        RuntimeException exception = null;

        private EltStreamRDF() {
        }
    }
}

