/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.xloader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockMgrFactory;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.apache.jena.dboe.trans.bplustree.rewriter.BPlusTreeRewriter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.system.progress.ProgressIterator;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import org.apache.jena.tdb2.xloader.RecordsFromInput;
import org.apache.jena.tdb2.xloader.XLoaderFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcBuildIndexX {
    private static Logger LOG = LoggerFactory.getLogger((String)"Index");

    public static void exec(String location, String indexName, int sortThreads, String sortIndexArgs, XLoaderFiles loaderFiles) {
        Timer timer = new Timer();
        timer.startTimer();
        FmtLog.info((Logger)LOG, (String)"Build index %s", (Object[])new Object[]{indexName});
        long timeMillis = timer.endTimer();
        long items = ProcBuildIndexX.exec2(location, indexName, sortThreads, sortIndexArgs, loaderFiles);
        double xSec = (double)timeMillis / 1000.0;
        double rate = (double)items / xSec;
        String elapsedStr = BulkLoaderX.milliToHMS(timeMillis);
        String rateStr = BulkLoaderX.rateStr(items, timeMillis);
        FmtLog.info((Logger)LOG, (String)"%s Index %s : %s seconds - %s at %s TPS", (Object[])new Object[]{"==-==-==", indexName, Timer.timeStr((long)timeMillis), elapsedStr, rateStr});
    }

    private static long exec2(String location, String indexName, int sortThreads, String sortIndexArgs, XLoaderFiles loaderFiles) {
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(location);
        long x = ProcBuildIndexX.buildIndex(dsg, indexName, sortThreads, sortIndexArgs, loaderFiles);
        TDBInternal.expel(dsg);
        return x;
    }

    private static long buildIndex(DatasetGraph dsg, String indexName, int sortThreads, String sortIndexArgs, XLoaderFiles loaderFiles) {
        long tickPoint = BulkLoaderX.DataTick;
        int superTick = BulkLoaderX.DataSuperTick;
        String K1 = "--key=1,1";
        String K2 = "--key=2,2";
        String K3 = "--key=3,3";
        String K4 = "--key=4,4";
        switch (indexName) {
            case "SPO": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.triplesFile, dsg, "SPO", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K1, K2, K3));
            }
            case "POS": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.triplesFile, dsg, "POS", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K2, K3, K1));
            }
            case "OSP": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.triplesFile, dsg, "OSP", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K3, K1, K2));
            }
            case "GSPO": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.quadsFile, dsg, "GSPO", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K1, K2, K3, K4));
            }
            case "GPOS": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.quadsFile, dsg, "GPOS", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K1, K3, K4, K2));
            }
            case "GOSP": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.quadsFile, dsg, "GOSP", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K1, K4, K2, K3));
            }
            case "SPOG": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.quadsFile, dsg, "SPOG", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K2, K3, K4, K1));
            }
            case "POSG": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.quadsFile, dsg, "POSG", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K3, K4, K2, K1));
            }
            case "OSPG": {
                return ProcBuildIndexX.sort_build_index(LOG, loaderFiles.quadsFile, dsg, "OSPG", sortThreads, sortIndexArgs, tickPoint, superTick, loaderFiles.TMPDIR, List.of(K4, K2, K3, K1));
            }
        }
        throw new TDBException("Index name '" + indexName + "' not recognized");
    }

    private static boolean isEmpty(String datafile) {
        Path pathData = Paths.get(datafile, new String[0]);
        try {
            long x;
            if (Files.isDirectory(pathData, new LinkOption[0])) {
                // empty if block
            }
            return (x = Files.size(pathData)) == 0L;
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return true;
        }
    }

    private static long sort_build_index(Logger LOG, String datafile, DatasetGraph dsg, String indexName, int sortThreads, String sortIndexArgs, long tickPoint, int superTick, String TMPDIR, List<String> sortKeyArgs) {
        InputStream fromSortInputStream;
        OutputStream toSortOutputStream;
        Process proc2;
        if (ProcBuildIndexX.isEmpty(datafile)) {
            return 0L;
        }
        if (sortThreads <= 0) {
            sortThreads = 2;
        }
        try {
            ArrayList<String> sortCmd = new ArrayList<String>(Arrays.asList("sort", "--temporary-directory=" + TMPDIR, "--buffer-size=50%", "--parallel=" + sortThreads, "--unique"));
            if (BulkLoaderX.CompressSortIndexFiles) {
                sortCmd.add("--compress-program=" + BulkLoaderX.gzipProgram());
            }
            sortCmd.addAll(sortKeyArgs);
            if (!BulkLoaderX.CompressDataFiles) {
                sortCmd.add(datafile);
            }
            ProcessBuilder pb2 = new ProcessBuilder(sortCmd);
            pb2.environment().put("LC_ALL", "C");
            proc2 = pb2.start();
            toSortOutputStream = proc2.getOutputStream();
            fromSortInputStream = proc2.getInputStream();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (BulkLoaderX.CompressDataFiles) {
            InputStream inData = IO.openFile((String)datafile);
            try {
                inData.transferTo(toSortOutputStream);
                toSortOutputStream.close();
            }
            catch (IOException ex) {
                IO.exception((IOException)ex);
            }
        }
        InputStream input = IO.ensureBuffered((InputStream)fromSortInputStream);
        long count = ProcBuildIndexX.indexBuilder(dsg, input, indexName);
        try {
            int exitCode = proc2.waitFor();
            if (exitCode != 0) {
                String msg = IO.readWholeFileAsUTF8((InputStream)proc2.getErrorStream());
                String logMsg = String.format("Sort RC = %d : Error: %s", exitCode, msg);
                Log.error((Object)LOG, (String)logMsg);
                System.exit(exitCode);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failed to cleanly wait-for the subprocess");
            throw new RuntimeException(e);
        }
        finally {
            IO.close((Closeable)toSortOutputStream);
            IO.close((Closeable)fromSortInputStream);
        }
        return count;
    }

    private static long indexBuilder(DatasetGraph dsg, InputStream input, String indexName) {
        int dftValueLength;
        int dftKeyLength;
        String primaryOrder;
        long tickPoint = BulkLoaderX.DataTick;
        int superTick = BulkLoaderX.DataSuperTick;
        DatasetGraphTDB dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        Location location = dsgtdb.getLocation();
        int keyLength = 8 * indexName.length();
        boolean valueLength = false;
        String primary = indexName;
        int tupleLength = indexName.length();
        if (tupleLength == 3) {
            primaryOrder = "SPO";
            dftKeyLength = 24;
            dftValueLength = 0;
            TupleIndex index = ProcBuildIndexX.findIndex(dsgtdb.getTripleTable().getNodeTupleTable().getTupleTable().getIndexes(), indexName);
        } else if (tupleLength == 4) {
            primaryOrder = "GSPO";
            dftKeyLength = 32;
            dftValueLength = 0;
            TupleIndex index = ProcBuildIndexX.findIndex(dsgtdb.getQuadTable().getNodeTupleTable().getTupleTable().getIndexes(), indexName);
        } else {
            throw new TDBException("Index name: " + indexName);
        }
        TupleMap colMap = TupleMap.create((String)primaryOrder, (String)indexName);
        int readCacheSize = 10;
        int writeCacheSize = 100;
        int blockSize = 8192;
        RecordFactory recordFactory = new RecordFactory(dftKeyLength, dftValueLength);
        int order = BPlusTreeParams.calcOrder((int)blockSize, (RecordFactory)recordFactory);
        BPlusTreeParams bptParams = new BPlusTreeParams(order, recordFactory);
        int blockSizeNodes = blockSize;
        int blockSizeRecords = blockSize;
        FileSet destination = new FileSet(location, indexName);
        BufferChannel blkState = FileFactory.createBufferChannel((FileSet)destination, (String)"bpt");
        BlockMgr blkMgrNodes = BlockMgrFactory.create((FileSet)destination, (String)"idn", (int)blockSizeNodes, (int)readCacheSize, (int)writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create((FileSet)destination, (String)"dat", (int)blockSizeRecords, (int)readCacheSize, (int)writeCacheSize);
        int rowBlock = 1000;
        RecordsFromInput iter = new RecordsFromInput(input, tupleLength, colMap, rowBlock);
        ProgressMonitorOutput monitor = ProgressMonitorOutput.create((Logger)LOG, (String)indexName, (long)tickPoint, (int)superTick);
        ProgressIterator iter2 = new ProgressIterator((Iterator)iter, (ProgressMonitor)monitor);
        monitor.start();
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree((Iterator)iter2, (BPlusTreeParams)bptParams, (RecordFactory)recordFactory, (BufferChannel)blkState, (BlockMgr)blkMgrNodes, (BlockMgr)blkMgrRecords);
        bpt2.close();
        monitor.finish();
        long count = monitor.getTicks();
        return count;
    }

    private static TupleIndex findIndex(TupleIndex[] indexes, String indexName) {
        for (TupleIndex idx : indexes) {
            if (!indexName.equals(idx.getName())) continue;
            return idx;
        }
        throw new TDBException("Failed to find index: " + indexName + " in " + Arrays.asList(indexes));
    }
}

