/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.base;

import java.util.List;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.graph.Node;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.system.progress.MonitorOutput;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.tdb2.loader.DataLoader;
import org.apache.jena.tdb2.loader.base.LoaderOps;

public abstract class LoaderBase
implements DataLoader {
    protected final DatasetGraph dsg;
    protected final Node graphName;
    private Timer timer;
    protected final MonitorOutput output;

    protected LoaderBase(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        this.dsg = dsg;
        this.graphName = graphName;
        this.output = output;
    }

    @Override
    public void startBulk() {
        this.timer = new Timer();
        this.timer.startTimer();
        if (this.bulkUseTransaction()) {
            this.dsg.begin(TxnType.WRITE);
        }
    }

    @Override
    public void finishBulk() {
        if (this.bulkUseTransaction()) {
            this.dsg.commit();
            this.dsg.end();
        }
        long totalElapsed = this.timer.endTimer();
        this.outputSummary(totalElapsed);
    }

    @Override
    public void finishException(Exception ex) {
        if (this.bulkUseTransaction()) {
            this.dsg.abort();
            this.dsg.end();
        }
    }

    @Override
    public void load(List<String> filenames) {
        if (filenames.isEmpty()) {
            this.output.print("No files to load", new Object[0]);
            return;
        }
        ProgressMonitor monitor = this.createProgressMonitor(this.output);
        boolean multipleFiles = filenames.size() > 1;
        String file1 = null;
        if (!multipleFiles && (file1 = filenames.get(0)).equals("-")) {
            file1 = "stdin";
        }
        try {
            if (multipleFiles) {
                monitor.startMessage("Start: " + filenames.size() + " files");
            } else {
                monitor.startMessage("Start: " + file1);
            }
            monitor.start();
            filenames.forEach(fn -> {
                if (multipleFiles) {
                    monitor.startSection();
                }
                this.loadOne((String)fn, monitor);
                if (multipleFiles) {
                    monitor.finishSection();
                }
            });
            monitor.finish();
            if (multipleFiles) {
                monitor.finishMessage("Finished: " + filenames.size() + " files");
            } else {
                monitor.finishMessage("Finished: " + file1);
            }
        }
        catch (Exception ex) {
            this.finishException(ex);
            throw ex;
        }
    }

    protected abstract ProgressMonitor createProgressMonitor(MonitorOutput var1);

    protected abstract boolean bulkUseTransaction();

    protected void loadOne(String filename, ProgressMonitor monitor) {
        String label = LoaderOps.label(filename);
        monitor.setLabel(label);
        LoaderOps.inputFile(this.stream(), filename, monitor);
    }

    protected void outputSummary(long totalElapsed) {
        if (this.output != null) {
            double seconds;
            long count = this.countTriples() + this.countQuads();
            String label = "Triples/Quads";
            if (this.countTriples() == 0L && this.countQuads() > 0L) {
                label = "Quads";
            }
            if (this.countTriples() > 0L && this.countQuads() == 0L) {
                label = "Triples";
            }
            if ((seconds = (double)totalElapsed / 1000.0) > 1.0) {
                this.output.print("Time = %,.3f seconds : %s = %,d : Rate = %,.0f /s", new Object[]{seconds, label, count, (double)count / seconds});
            }
        }
    }
}

