/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexRecord;

public class ShexMapBuilder {
    private List<ShexRecord> records = new ArrayList<ShexRecord>();

    public static ShexMap record(Node focus, Node shapeRef) {
        return new ShexMapBuilder().add(focus, shapeRef).build();
    }

    public static ShexMap record(Triple pattern, Node shapeRef) {
        return new ShexMapBuilder().add(pattern, shapeRef).build();
    }

    public ShexMapBuilder() {
    }

    public ShexMapBuilder(ShexMap base) {
        base.entries().forEach(this.records::add);
    }

    public ShexMapBuilder add(Node focus, Node shapeRef) {
        this.records.add(new ShexRecord(focus, shapeRef));
        return this;
    }

    public ShexMapBuilder add(Triple pattern, Node shapeRef) {
        this.records.add(new ShexRecord(pattern, shapeRef));
        return this;
    }

    public ShexMap build() {
        ShexMap map = ShexMap.create(this.records);
        this.records.clear();
        return map;
    }
}

