/* TurtleJavacc.java */
/* Generated By:JavaCC: Do not edit this line. TurtleJavacc.java */
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.riot.lang.extra.javacc;

import org.apache.jena.graph.*;
import org.apache.jena.riot.lang.extra.* ;
import static org.apache.jena.riot.lang.extra.LangParserLib.*;

public class TurtleJavacc extends LangParserBase implements TurtleJavaccConstants {

// Entry point
  final public void parse() throws ParseException {
    ByteOrderMark();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PREFIX_OLD:
      case BASE_OLD:
      case BASE:
      case PREFIX:
      case IRIref:
      case LPAREN:
      case LBRACKET:
      case ANON:
      case LT2:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:{

        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      Statement();
    }
    jj_consume_token(0);
  }

  final public void ByteOrderMark() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOM:{
      jj_consume_token(BOM);
      break;
      }
    default:
      jj_la1[1] = jj_gen;

    }
  }

// Turtle [2] statement
  final public void Statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BASE:
    case PREFIX:{
      Directive();
      break;
      }
    case PREFIX_OLD:
    case BASE_OLD:{
      DirectiveOld();
      break;
      }
    case IRIref:
    case LPAREN:
    case LBRACKET:
    case ANON:
    case LT2:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      TriplesSameSubject();
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// Turtle [3] directive
  final public void Directive() throws ParseException {Token t ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:{
      jj_consume_token(PREFIX);
      t = jj_consume_token(PNAME_NS);
      iri = IRIREF();
String s = fixupPrefix(t.image, t.beginLine, t.beginColumn) ;
      setPrefix(s, iri, t.beginLine, t.beginColumn) ;
      break;
      }
    case BASE:{
      t = jj_consume_token(BASE);
      iri = IRIREF();
setBase(iri, t.beginLine, t.beginColumn) ;
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DirectiveOld() throws ParseException {Token t ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX_OLD:{
      jj_consume_token(PREFIX_OLD);
      t = jj_consume_token(PNAME_NS);
      iri = IRIREF();
      jj_consume_token(DOT);
String s = fixupPrefix(t.image, t.beginLine, t.beginColumn) ;
      setPrefix(s, iri, t.beginLine, t.beginColumn) ;
      break;
      }
    case BASE_OLD:{
      t = jj_consume_token(BASE_OLD);
      iri = IRIREF();
      jj_consume_token(DOT);
setBase(iri, t.beginLine, t.beginColumn) ;
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// Turtle [6] triples
  final public void TriplesSameSubject() throws ParseException {Node s ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case LPAREN:
    case ANON:
    case LT2:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      s = Subject();
      PredicateObjectList(s);
      break;
      }
    case LBRACKET:{
      s = BlankNodePropertyList();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KW_A:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:{
        PredicateObjectList(s);
        break;
        }
      default:
        jj_la1[5] = jj_gen;

      }
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// Turtle [7] predicateObjectList
  final public void PredicateObjectList(Node s) throws ParseException {Node p = null ;
    p = Verb();
    ObjectList(s, p);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{

        break;
        }
      default:
        jj_la1[7] = jj_gen;
        break label_2;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KW_A:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:{
        p = Verb();
        ObjectList(s, p);
        break;
        }
      default:
        jj_la1[8] = jj_gen;

      }
    }
  }

// Turtle [8] objectList
  final public void ObjectList(Node s, Node p) throws ParseException {Node o ;
    o = Object();
emitTriple(token.beginLine, token.beginColumn, s, p, o) ;
    Annotation(s, p, o);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{

        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      o = Object();
emitTriple(token.beginLine, token.beginColumn, s, p, o) ;
      Annotation(s, p, o);
    }
  }

// RDF-star Annotation Syntax
  final public void Annotation(Node s, Node p, Node o) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case L_ANN:{
      jj_consume_token(L_ANN);
Node x = createTripleTerm(s, p, o, token.beginLine, token.beginColumn);
      PredicateObjectList(x);
      jj_consume_token(R_ANN);
      break;
      }
    default:
      jj_la1[10] = jj_gen;

    }
  }

// Turtle [9] verb
  final public Node Verb() throws ParseException {Node p ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      p = Predicate();
      break;
      }
    case KW_A:{
      jj_consume_token(KW_A);
p = nRDFtype ;
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Node Subject() throws ParseException {Node s; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
s = createURI(iri, token.beginLine, token.beginColumn) ;
      break;
      }
    case ANON:
    case BLANK_NODE_LABEL:{
      s = BlankNode();
      break;
      }
    case LPAREN:{
      s = Collection();
      break;
      }
    case LT2:{
      s = EmbTriple();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s ;}
    throw new Error("Missing return statement in function");
  }

// Turtle [11] predicate
  final public Node Predicate() throws ParseException {String iri;
    iri = iri();
{if ("" != null) return createURI(iri, token.beginLine, token.beginColumn);}
    throw new Error("Missing return statement in function");
  }

// Turtle [12] object
  final public Node Object() throws ParseException {Node o ; String iri;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
o = createURI(iri, token.beginLine, token.beginColumn) ;
      break;
      }
    case ANON:
    case BLANK_NODE_LABEL:{
      o = BlankNode();
      break;
      }
    case LPAREN:{
      o = Collection();
      break;
      }
    case LBRACKET:{
      o = BlankNodePropertyList();
      break;
      }
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      o = Literal();
      break;
      }
    case LT2:{
      o = EmbTriple();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return o;}
    throw new Error("Missing return statement in function");
  }

  final public Node EmbSubject() throws ParseException {Node o ; String iri;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
o = createURI(iri, token.beginLine, token.beginColumn) ;
      break;
      }
    case ANON:
    case BLANK_NODE_LABEL:{
      o = BlankNode();
      break;
      }
    case LT2:{
      o = EmbTriple();
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return o;}
    throw new Error("Missing return statement in function");
  }

  final public Node EmbObject() throws ParseException {Node o ; String iri;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
o = createURI(iri, token.beginLine, token.beginColumn) ;
      break;
      }
    case ANON:
    case BLANK_NODE_LABEL:{
      o = BlankNode();
      break;
      }
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      o = Literal();
      break;
      }
    case LT2:{
      o = EmbTriple();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return o ;}
    throw new Error("Missing return statement in function");
  }

// The syntax for RDF-star <<>>
  final public Node EmbTriple() throws ParseException {Node s , p , o ; Token t ;
    t = jj_consume_token(LT2);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
    s = EmbSubject();
    p = Verb();
    o = EmbObject();
    jj_consume_token(GT2);
Node n = createTripleTerm(s, p, o, beginLine, beginColumn);
    {if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

// Turtle [13] literal
  final public Node Literal() throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      n = RDFLiteral();
{if ("" != null) return n ;}
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      n = NumericLiteral();
{if ("" != null) return n ;}
      break;
      }
    case TRUE:
    case FALSE:{
      n = BooleanLiteral();
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Turtle [14] blankNodePropertyList
  final public Node BlankNodePropertyList() throws ParseException {Token t ;
    t = jj_consume_token(LBRACKET);
Node n = createBNode(t.beginLine, t.beginColumn) ;
    PredicateObjectList(n);
    jj_consume_token(RBRACKET);
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

// Turtle [15] collection
  final public Node Collection() throws ParseException {Node listHead = nRDFnil ; Node lastCell = null ; int mark ; Node n ; Token t ;
    t = jj_consume_token(LPAREN);
int line = t.beginLine; int column = t.beginColumn;
    listStart(line, column);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TRUE:
      case FALSE:
      case IRIref:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case LBRACKET:
      case ANON:
      case LT2:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:{

        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_4;
      }
Node cell = createListNode(line, column) ;
      if ( listHead == nRDFnil )
         listHead = cell ;
      if ( lastCell != null )
        listTriple(line, column, lastCell, nRDFrest,  cell) ;
      n = CollectionElt();
listTriple(line, column, cell, nRDFfirst, n) ;
      lastCell = cell ;
    }
    jj_consume_token(RPAREN);
if ( lastCell != null )
       listTriple(line, column, lastCell, nRDFrest,  nRDFnil) ;
     listFinish(line, column);
     {if ("" != null) return listHead ;}
    throw new Error("Missing return statement in function");
  }

// Turtle: Gramnmar has "object" directly in the collection rule.
  final public Node CollectionElt() throws ParseException {Node o;
    o = Object();
{if ("" != null) return o;}
    throw new Error("Missing return statement in function");
  }

// Turtle [16] NumericLiteral
  final public Node NumericLiteral() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:{
      t = jj_consume_token(INTEGER);
{if ("" != null) return createLiteralInteger(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case DECIMAL:{
      t = jj_consume_token(DECIMAL);
{if ("" != null) return createLiteralDecimal(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case DOUBLE:{
      t = jj_consume_token(DOUBLE);
{if ("" != null) return createLiteralDouble(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Turtle [128s] RDFLiteral
  final public Node RDFLiteral() throws ParseException {Token t ; String lex = null ;
    lex = String();
String lang = null ; String uri = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BASE:
    case PREFIX:
    case DATATYPE:
    case LANGTAG:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BASE:
      case PREFIX:
      case LANGTAG:{
        lang = LangTag();
        break;
        }
      case DATATYPE:{
        jj_consume_token(DATATYPE);
        uri = iri();
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[20] = jj_gen;

    }
{if ("" != null) return createLiteral(lex, lang, uri, token.beginLine, token.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  final public String LangTag() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGTAG:{
      t = jj_consume_token(LANGTAG);
      break;
      }
    case BASE:
    case PREFIX:{
      t = AnyDirective();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
String lang = stripChars(t.image, 1) ; {if ("" != null) return lang ;}
    throw new Error("Missing return statement in function");
  }

  final public Token AnyDirective() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:{
      t = jj_consume_token(PREFIX);
      break;
      }
    case BASE:{
      t = jj_consume_token(BASE);
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t ;}
    throw new Error("Missing return statement in function");
  }

// Turtle [133s BooleanLiteral
  final public Node BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
{if ("" != null) return XSD_TRUE ;}
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
{if ("" != null) return XSD_FALSE ;}
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Turtle [17] String
  final public String String() throws ParseException {Token t ; String lex ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL1:{
      t = jj_consume_token(STRING_LITERAL1);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL2:{
      t = jj_consume_token(STRING_LITERAL2);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG1:{
      t = jj_consume_token(STRING_LITERAL_LONG1);
lex = stripQuotes3(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG2:{
      t = jj_consume_token(STRING_LITERAL_LONG2);
lex = stripQuotes3(t.image) ;
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
checkString(lex, t.beginLine, t.beginColumn) ;
      lex = unescapeStr(lex,  t.beginLine, t.beginColumn) ;
      {if ("" != null) return lex ;}
    throw new Error("Missing return statement in function");
  }

// Turtle [135s] iri
  final public String iri() throws ParseException {String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:{
      iri = IRIREF();
{if ("" != null) return iri ;}
      break;
      }
    case PNAME_NS:
    case PNAME_LN:{
      iri = PrefixedName();
{if ("" != null) return iri ;}
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Turtle [136s] PrefixedName
  final public String PrefixedName() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PNAME_LN:{
      t = jj_consume_token(PNAME_LN);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case PNAME_NS:{
      t = jj_consume_token(PNAME_NS);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Turtle [137s] BlankNode
  final public Node BlankNode() throws ParseException {Token t = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BLANK_NODE_LABEL:{
      t = jj_consume_token(BLANK_NODE_LABEL);
{if ("" != null) return createBNode(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case ANON:{
      t = jj_consume_token(ANON);
{if ("" != null) return createBNode(t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String IRIREF() throws ParseException {Token t ;
    t = jj_consume_token(IRIref);
{if ("" != null) return resolveQuotedIRI(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public TurtleJavaccTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[28];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x21e00,0x10000,0x21e00,0x1800,0x600,0x20100,0x20000,0x0,0x20100,0x0,0x0,0x20100,0x20000,0x80e26000,0x20000,0x80e26000,0x80e06000,0x80e26000,0xe00000,0x1800,0x1800,0x1800,0x1800,0x6000,0x80000000,0x20000,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x382288,0x0,0x382288,0x0,0x0,0x180000,0x382288,0x400,0x180000,0x800,0x8000,0x180000,0x382208,0x38228f,0x382200,0x382207,0x7,0x38228f,0x0,0x420000,0x420000,0x400000,0x0,0x0,0x7,0x180000,0x180000,0x200200,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }

  /** Constructor with InputStream. */
  public TurtleJavacc(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TurtleJavacc(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new TurtleJavaccTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public TurtleJavacc(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new TurtleJavaccTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public TurtleJavacc(TurtleJavaccTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(TurtleJavaccTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 28; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[69];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 28; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 69; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

 }
