/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.params;

import org.apache.jena.dboe.base.block.FileMode;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.params.StoreParamsConst;
import org.apache.jena.tdb2.params.StoreParamsDynamic;

public class StoreParamsBuilder {
    private Item<FileMode> fileMode = new Item<FileMode>(StoreParamsConst.fileMode, false);
    private Item<Integer> blockReadCacheSize = new Item<Integer>(StoreParamsConst.blockReadCacheSize, false);
    private Item<Integer> blockWriteCacheSize = new Item<Integer>(StoreParamsConst.blockWriteCacheSize, false);
    private Item<Integer> Node2NodeIdCacheSize = new Item<Integer>(StoreParamsConst.Node2NodeIdCacheSize, false);
    private Item<Integer> NodeId2NodeCacheSize = new Item<Integer>(StoreParamsConst.NodeId2NodeCacheSize, false);
    private Item<Integer> NodeMissCacheSize = new Item<Integer>(1000, false);
    private Item<Integer> prefixNode2NodeIdCacheSize = new Item<Integer>(StoreParamsConst.Node2NodeIdCacheSize, false);
    private Item<Integer> prefixNodeId2NodeCacheSize = new Item<Integer>(StoreParamsConst.NodeId2NodeCacheSize, false);
    private Item<Integer> prefixNodeMissCacheSize = new Item<Integer>(1000, false);
    private Item<Integer> blockSize = new Item<Integer>(8192, false);
    private Item<String> nodeTableBaseName = new Item<String>("nodes", false);
    private Item<String> primaryIndexTriples = new Item<String>("SPO", false);
    private Item<String[]> tripleIndexes = new Item<String[]>(StoreParamsConst.tripleIndexes, false);
    private Item<String> primaryIndexQuads = new Item<String>("GSPO", false);
    private Item<String[]> quadIndexes = new Item<String[]>(StoreParamsConst.quadIndexes, false);
    private Item<String> prefixTableBaseName = new Item<String>("prefixes", false);
    private Item<String> primaryIndexPrefix = new Item<String>("GPU", false);
    private Item<String[]> prefixIndexes = new Item<String[]>(StoreParamsConst.prefixIndexes, false);

    public static StoreParamsBuilder create() {
        return new StoreParamsBuilder();
    }

    public static StoreParamsBuilder create(StoreParams params) {
        return new StoreParamsBuilder(params);
    }

    public static StoreParams modify(StoreParams baseParams, StoreParamsDynamic additionalParams) {
        StoreParamsBuilder b = new StoreParamsBuilder(baseParams);
        if (additionalParams.isSetFileMode()) {
            b.fileMode(additionalParams.getFileMode());
        }
        if (additionalParams.isSetBlockReadCacheSize()) {
            b.blockReadCacheSize(additionalParams.getBlockReadCacheSize());
        }
        if (additionalParams.isSetBlockWriteCacheSize()) {
            b.blockWriteCacheSize(additionalParams.getBlockWriteCacheSize());
        }
        if (additionalParams.isSetNode2NodeIdCacheSize()) {
            b.node2NodeIdCacheSize(additionalParams.getNode2NodeIdCacheSize());
        }
        if (additionalParams.isSetNodeId2NodeCacheSize()) {
            b.nodeId2NodeCacheSize(additionalParams.getNodeId2NodeCacheSize());
        }
        if (additionalParams.isSetNodeMissCacheSize()) {
            b.nodeMissCacheSize(additionalParams.getNodeMissCacheSize());
        }
        return b.build();
    }

    private StoreParamsBuilder() {
    }

    private StoreParamsBuilder(StoreParams other) {
        this.fileMode = other.fileMode;
        this.blockSize = other.blockSize;
        this.blockReadCacheSize = other.blockReadCacheSize;
        this.blockWriteCacheSize = other.blockWriteCacheSize;
        this.Node2NodeIdCacheSize = other.Node2NodeIdCacheSize;
        this.NodeId2NodeCacheSize = other.NodeId2NodeCacheSize;
        this.NodeMissCacheSize = other.NodeMissCacheSize;
        this.prefixNode2NodeIdCacheSize = other.prefixNode2NodeIdCacheSize;
        this.prefixNodeId2NodeCacheSize = other.prefixNodeId2NodeCacheSize;
        this.prefixNodeMissCacheSize = other.prefixNodeMissCacheSize;
        this.nodeTableBaseName = other.nodeTableBaseName;
        this.primaryIndexTriples = other.primaryIndexTriples;
        this.tripleIndexes = other.tripleIndexes;
        this.primaryIndexQuads = other.primaryIndexQuads;
        this.quadIndexes = other.quadIndexes;
        this.prefixTableBaseName = other.prefixTableBaseName;
        this.primaryIndexPrefix = other.primaryIndexPrefix;
        this.prefixIndexes = other.prefixIndexes;
    }

    public StoreParams build() {
        return new StoreParams(this.fileMode, this.blockSize, this.blockReadCacheSize, this.blockWriteCacheSize, this.Node2NodeIdCacheSize, this.NodeId2NodeCacheSize, this.NodeMissCacheSize, this.prefixNode2NodeIdCacheSize, this.prefixNodeId2NodeCacheSize, this.prefixNodeMissCacheSize, this.nodeTableBaseName, this.primaryIndexTriples, this.tripleIndexes, this.primaryIndexQuads, this.quadIndexes, this.prefixTableBaseName, this.primaryIndexPrefix, this.prefixIndexes);
    }

    public FileMode getFileMode() {
        return (FileMode)this.fileMode.value;
    }

    public StoreParamsBuilder fileMode(FileMode fileMode) {
        this.fileMode = new Item<FileMode>(fileMode, true);
        return this;
    }

    public int getBlockSize() {
        return (Integer)this.blockSize.value;
    }

    public StoreParamsBuilder blockSize(int blockSize) {
        this.blockSize = new Item<Integer>(blockSize, true);
        return this;
    }

    public int getBlockReadCacheSize() {
        return (Integer)this.blockReadCacheSize.value;
    }

    public StoreParamsBuilder blockReadCacheSize(int blockReadCacheSize) {
        this.blockReadCacheSize = new Item<Integer>(blockReadCacheSize, true);
        return this;
    }

    public int getBlockWriteCacheSize() {
        return (Integer)this.blockWriteCacheSize.value;
    }

    public StoreParamsBuilder blockWriteCacheSize(int blockWriteCacheSize) {
        this.blockWriteCacheSize = new Item<Integer>(blockWriteCacheSize, true);
        return this;
    }

    public int getNode2NodeIdCacheSize() {
        return (Integer)this.Node2NodeIdCacheSize.value;
    }

    public StoreParamsBuilder node2NodeIdCacheSize(int node2NodeIdCacheSize) {
        this.Node2NodeIdCacheSize = new Item<Integer>(node2NodeIdCacheSize, true);
        return this;
    }

    public int getNodeId2NodeCacheSize() {
        return (Integer)this.NodeId2NodeCacheSize.value;
    }

    public StoreParamsBuilder nodeId2NodeCacheSize(int nodeId2NodeCacheSize) {
        this.NodeId2NodeCacheSize = new Item<Integer>(nodeId2NodeCacheSize, true);
        return this;
    }

    public int getNodeMissCacheSize() {
        return (Integer)this.NodeMissCacheSize.value;
    }

    public StoreParamsBuilder nodeMissCacheSize(int nodeMissCacheSize) {
        this.NodeMissCacheSize = new Item<Integer>(nodeMissCacheSize, true);
        return this;
    }

    public int getPrefixNode2NodeIdCacheSize() {
        return (Integer)this.prefixNode2NodeIdCacheSize.value;
    }

    public StoreParamsBuilder prefixnode2NodeIdCacheSize(int prefixNode2NodeIdCacheSize) {
        this.prefixNode2NodeIdCacheSize = new Item<Integer>(prefixNode2NodeIdCacheSize, true);
        return this;
    }

    public int getPrefixNodeId2NodeCacheSize() {
        return (Integer)this.prefixNodeId2NodeCacheSize.value;
    }

    public StoreParamsBuilder prefixnodeId2NodeCacheSize(int prefixNodeId2NodeCacheSize) {
        this.prefixNodeId2NodeCacheSize = new Item<Integer>(prefixNodeId2NodeCacheSize, true);
        return this;
    }

    public int getPrefixNodeMissCacheSize() {
        return (Integer)this.prefixNodeMissCacheSize.value;
    }

    public StoreParamsBuilder prefixNodeMissCacheSize(int prefixNodeMissCacheSize) {
        this.prefixNodeMissCacheSize = new Item<Integer>(prefixNodeMissCacheSize, true);
        return this;
    }

    public String getNodeTableBaseName() {
        return (String)this.nodeTableBaseName.value;
    }

    public StoreParamsBuilder nodeTableBaseName(String nodeTableBaseName) {
        this.nodeTableBaseName = new Item<String>(nodeTableBaseName, true);
        return this;
    }

    public String getPrimaryIndexTriples() {
        return (String)this.primaryIndexTriples.value;
    }

    public StoreParamsBuilder primaryIndexTriples(String primaryIndexTriples) {
        this.primaryIndexTriples = new Item<String>(primaryIndexTriples, true);
        return this;
    }

    public String[] getTripleIndexes() {
        return (String[])this.tripleIndexes.value;
    }

    public StoreParamsBuilder tripleIndexes(String[] tripleIndexes) {
        this.tripleIndexes = new Item<String[]>(tripleIndexes, true);
        return this;
    }

    public String getPrimaryIndexQuads() {
        return (String)this.primaryIndexQuads.value;
    }

    public StoreParamsBuilder primaryIndexQuads(String primaryIndexQuads) {
        this.primaryIndexQuads = new Item<String>(primaryIndexQuads, true);
        return this;
    }

    public String[] getQuadIndexes() {
        return (String[])this.quadIndexes.value;
    }

    public StoreParamsBuilder quadIndexes(String[] quadIndexes) {
        this.quadIndexes = new Item<String[]>(quadIndexes, true);
        return this;
    }

    public String getPreifixTableBaseName() {
        return (String)this.prefixTableBaseName.value;
    }

    public StoreParamsBuilder prefixTableBaseName(String prefixTableBaseName) {
        this.prefixTableBaseName = new Item<String>(prefixTableBaseName, true);
        return this;
    }

    public String getPrimaryIndexPrefix() {
        return (String)this.primaryIndexPrefix.value;
    }

    public StoreParamsBuilder primaryIndexPrefix(String primaryIndexPrefix) {
        this.primaryIndexPrefix = new Item<String>(primaryIndexPrefix, true);
        return this;
    }

    public String[] getPrefixIndexes() {
        return (String[])this.prefixIndexes.value;
    }

    public StoreParamsBuilder prefixIndexes(String[] prefixIndexes) {
        this.prefixIndexes = new Item<String[]>(prefixIndexes, true);
        return this;
    }

    static class Item<X> {
        final X value;
        final boolean isSet;

        Item(X value, boolean isSet) {
            this.value = value;
            this.isSet = isSet;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isSet ? 1231 : 1237);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.isSet != other.isSet) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

