/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.index;

import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.Index;
import org.apache.jena.tdb.index.IndexBuilder;
import org.apache.jena.tdb.index.IndexParams;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.index.RangeIndexBuilder;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb.setup.BlockMgrBuilder;

public class BuilderStdIndex {

    public static class BlockMgrBuilderStd
    implements BlockMgrBuilder {
        @Override
        public BlockMgr buildBlockMgr(FileSet fileset, String ext, IndexParams indexParams) {
            return BlockMgrFactory.create(fileset, ext, indexParams);
        }
    }

    public static class RangeIndexBuilderStd
    implements RangeIndexBuilder {
        private BlockMgrBuilder bMgrNodes;
        private BlockMgrBuilder bMgrRecords;

        public RangeIndexBuilderStd(BlockMgrBuilder blockMgrBuilderNodes, BlockMgrBuilder blockMgrBuilderRecords) {
            this.bMgrNodes = blockMgrBuilderNodes;
            this.bMgrRecords = blockMgrBuilderRecords;
        }

        @Override
        public RangeIndex buildRangeIndex(FileSet fileSet, RecordFactory recordFactory, IndexParams indexParams) {
            int blkSize = indexParams.getBlockSize();
            int order = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
            RangeIndex rIndex = this.createBPTree(fileSet, order, this.bMgrNodes, this.bMgrRecords, recordFactory, indexParams);
            return rIndex;
        }

        private RangeIndex createBPTree(FileSet fileset, int order, BlockMgrBuilder blockMgrBuilderNodes, BlockMgrBuilder blockMgrBuilderRecords, RecordFactory factory, IndexParams indexParams) {
            int order2;
            int blockSize = indexParams.getBlockSize();
            if (blockSize < 0) {
                throw new IllegalArgumentException("Negative blocksize: " + blockSize);
            }
            if (blockSize < 0 && order < 0) {
                throw new IllegalArgumentException("Neither blocksize nor order specified");
            }
            if (blockSize >= 0 && order < 0) {
                order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
            }
            if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
                throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
            }
            BPlusTreeParams params = new BPlusTreeParams(order, factory);
            BlockMgr blkMgrNodes = blockMgrBuilderNodes.buildBlockMgr(fileset, "idn", indexParams);
            BlockMgr blkMgrRecords = blockMgrBuilderRecords.buildBlockMgr(fileset, "dat", indexParams);
            return BPlusTree.create(params, blkMgrNodes, blkMgrRecords);
        }
    }

    public static class IndexBuilderStd
    implements IndexBuilder {
        protected BlockMgrBuilder bMgrNodes;
        protected BlockMgrBuilder bMgrRecords;
        protected RangeIndexBuilderStd other;

        public IndexBuilderStd(BlockMgrBuilder bMgrNodes, BlockMgrBuilder bMgrRecords) {
            this.bMgrNodes = bMgrNodes;
            this.bMgrRecords = bMgrRecords;
            this.other = new RangeIndexBuilderStd(bMgrNodes, bMgrRecords);
        }

        @Override
        public Index buildIndex(FileSet fileSet, RecordFactory recordFactory, IndexParams indexParams) {
            return this.other.buildRangeIndex(fileSet, recordFactory, indexParams);
        }
    }
}

