/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.sparql.function.FunctionCastXSD;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.function.library.FN_Abs;
import org.apache.jena.sparql.function.library.FN_AdjustDateToTimezone;
import org.apache.jena.sparql.function.library.FN_AdjustDatetimeToTimezone;
import org.apache.jena.sparql.function.library.FN_AdjustTimeToTimezone;
import org.apache.jena.sparql.function.library.FN_Apply;
import org.apache.jena.sparql.function.library.FN_BEV;
import org.apache.jena.sparql.function.library.FN_Ceiling;
import org.apache.jena.sparql.function.library.FN_CollationKey;
import org.apache.jena.sparql.function.library.FN_DateTime;
import org.apache.jena.sparql.function.library.FN_DayFromDate;
import org.apache.jena.sparql.function.library.FN_DayFromDateTime;
import org.apache.jena.sparql.function.library.FN_DaysFromDuration;
import org.apache.jena.sparql.function.library.FN_Error;
import org.apache.jena.sparql.function.library.FN_Floor;
import org.apache.jena.sparql.function.library.FN_FormatNumber;
import org.apache.jena.sparql.function.library.FN_HoursFromDateTime;
import org.apache.jena.sparql.function.library.FN_HoursFromDuration;
import org.apache.jena.sparql.function.library.FN_HoursFromTime;
import org.apache.jena.sparql.function.library.FN_Matches;
import org.apache.jena.sparql.function.library.FN_MinutesFromDateTime;
import org.apache.jena.sparql.function.library.FN_MinutesFromDuration;
import org.apache.jena.sparql.function.library.FN_MinutesFromTime;
import org.apache.jena.sparql.function.library.FN_MonthFromDate;
import org.apache.jena.sparql.function.library.FN_MonthFromDateTime;
import org.apache.jena.sparql.function.library.FN_MonthsFromDuration;
import org.apache.jena.sparql.function.library.FN_Not;
import org.apache.jena.sparql.function.library.FN_Round;
import org.apache.jena.sparql.function.library.FN_Round_Half_Even;
import org.apache.jena.sparql.function.library.FN_SecondsFromDateTime;
import org.apache.jena.sparql.function.library.FN_SecondsFromDuration;
import org.apache.jena.sparql.function.library.FN_SecondsFromTime;
import org.apache.jena.sparql.function.library.FN_StrAfter;
import org.apache.jena.sparql.function.library.FN_StrBefore;
import org.apache.jena.sparql.function.library.FN_StrConcat;
import org.apache.jena.sparql.function.library.FN_StrContains;
import org.apache.jena.sparql.function.library.FN_StrEncodeForURI;
import org.apache.jena.sparql.function.library.FN_StrEndsWith;
import org.apache.jena.sparql.function.library.FN_StrLength;
import org.apache.jena.sparql.function.library.FN_StrLowerCase;
import org.apache.jena.sparql.function.library.FN_StrNormalizeSpace;
import org.apache.jena.sparql.function.library.FN_StrNormalizeUnicode;
import org.apache.jena.sparql.function.library.FN_StrReplace;
import org.apache.jena.sparql.function.library.FN_StrStartsWith;
import org.apache.jena.sparql.function.library.FN_StrSubstring;
import org.apache.jena.sparql.function.library.FN_StrUpperCase;
import org.apache.jena.sparql.function.library.FN_Timezone;
import org.apache.jena.sparql.function.library.FN_TimezoneFromDate;
import org.apache.jena.sparql.function.library.FN_TimezoneFromDateTime;
import org.apache.jena.sparql.function.library.FN_TimezoneFromTime;
import org.apache.jena.sparql.function.library.FN_YearFromDate;
import org.apache.jena.sparql.function.library.FN_YearFromDateTime;
import org.apache.jena.sparql.function.library.FN_YearsFromDuration;
import org.apache.jena.sparql.function.library.Math_atan2;
import org.apache.jena.sparql.function.library.Math_exp;
import org.apache.jena.sparql.function.library.Math_exp10;
import org.apache.jena.sparql.function.library.Math_log;
import org.apache.jena.sparql.function.library.Math_log10;
import org.apache.jena.sparql.function.library.Math_pow;
import org.apache.jena.sparql.function.library.Op_NumericIntegerDivide;
import org.apache.jena.sparql.function.library.Op_NumericMod;
import org.apache.jena.sparql.function.library.collation;
import org.apache.jena.sparql.function.library.leviathan.cos;
import org.apache.jena.sparql.function.library.leviathan.cos1;
import org.apache.jena.sparql.function.library.leviathan.sin;
import org.apache.jena.sparql.function.library.leviathan.sin1;
import org.apache.jena.sparql.function.library.leviathan.tan;
import org.apache.jena.sparql.function.library.leviathan.tan1;
import org.apache.jena.sparql.function.library.pi;
import org.apache.jena.sparql.function.library.sqrt;

public class StandardFunctions {
    public static void loadStdDefs(FunctionRegistry registry) {
        String xfn = "http://www.w3.org/2005/xpath-functions#";
        String math = "http://www.w3.org/2005/xpath-functions/math#";
        String sparqlfn = "http://www.w3.org/ns/sparql#";
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDdecimal);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDinteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDlong);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDint);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDshort);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDbyte);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnonPositiveInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnegativeInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDnonNegativeInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDpositiveInteger);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedLong);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedInt);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDunsignedShort);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDdouble);
        StandardFunctions.addCastNumeric(registry, XSDDatatype.XSDfloat);
        StandardFunctions.addCastXSD(registry, XSDDatatype.XSDboolean);
        StandardFunctions.addCastXSD(registry, XSDDatatype.XSDduration);
        StandardFunctions.addCastXSD(registry, XSDDatatype.XSDdayTimeDuration);
        StandardFunctions.addCastXSD(registry, XSDDatatype.XSDyearMonthDuration);
        StandardFunctions.addCastXSD(registry, XSDDatatype.XSDstring);
        StandardFunctions.addCastXSD(registry, XSDDatatype.XSDanyURI);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDdateTime);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDdate);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDtime);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDgYear);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDgYearMonth);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDgMonth);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDgMonthDay);
        StandardFunctions.addCastTemporal(registry, XSDDatatype.XSDgDay);
        StandardFunctions.add(registry, "http://jena.apache.org/ARQ/function#collation", collation.class);
        StandardFunctions.add(registry, xfn + "error", FN_Error.class);
        StandardFunctions.add(registry, xfn + "concat", FN_StrConcat.class);
        StandardFunctions.add(registry, xfn + "substring", FN_StrSubstring.class);
        StandardFunctions.add(registry, xfn + "string-length", FN_StrLength.class);
        StandardFunctions.add(registry, xfn + "normalize-space", FN_StrNormalizeSpace.class);
        StandardFunctions.add(registry, xfn + "normalize-unicode", FN_StrNormalizeUnicode.class);
        StandardFunctions.add(registry, xfn + "upper-case", FN_StrUpperCase.class);
        StandardFunctions.add(registry, xfn + "lower-case", FN_StrLowerCase.class);
        StandardFunctions.add(registry, xfn + "contains", FN_StrContains.class);
        StandardFunctions.add(registry, xfn + "starts-with", FN_StrStartsWith.class);
        StandardFunctions.add(registry, xfn + "ends-with", FN_StrEndsWith.class);
        StandardFunctions.add(registry, xfn + "substring-before", FN_StrBefore.class);
        StandardFunctions.add(registry, xfn + "substring-after", FN_StrAfter.class);
        StandardFunctions.add(registry, xfn + "matches", FN_Matches.class);
        StandardFunctions.add(registry, xfn + "replace", FN_StrReplace.class);
        StandardFunctions.add(registry, xfn + "format-number", FN_FormatNumber.class);
        StandardFunctions.add(registry, xfn + "abs", FN_Abs.class);
        StandardFunctions.add(registry, xfn + "ceiling", FN_Ceiling.class);
        StandardFunctions.add(registry, xfn + "floor", FN_Floor.class);
        StandardFunctions.add(registry, xfn + "round", FN_Round.class);
        StandardFunctions.add(registry, xfn + "round-half-to-even", FN_Round_Half_Even.class);
        StandardFunctions.add(registry, xfn + "encode-for-uri", FN_StrEncodeForURI.class);
        StandardFunctions.add(registry, xfn + "year-from-date", FN_YearFromDate.class);
        StandardFunctions.add(registry, xfn + "month-from-date", FN_MonthFromDate.class);
        StandardFunctions.add(registry, xfn + "day-from-date", FN_DayFromDate.class);
        StandardFunctions.add(registry, xfn + "timezone-from-date", FN_TimezoneFromDate.class);
        StandardFunctions.add(registry, xfn + "hours-from-time", FN_HoursFromTime.class);
        StandardFunctions.add(registry, xfn + "minutes-from-time", FN_MinutesFromTime.class);
        StandardFunctions.add(registry, xfn + "seconds-from-time", FN_SecondsFromTime.class);
        StandardFunctions.add(registry, xfn + "timezone-from-time", FN_TimezoneFromTime.class);
        StandardFunctions.add(registry, xfn + "dateTime", FN_DateTime.class);
        StandardFunctions.add(registry, xfn + "year-from-dateTime", FN_YearFromDateTime.class);
        StandardFunctions.add(registry, xfn + "month-from-dateTime", FN_MonthFromDateTime.class);
        StandardFunctions.add(registry, xfn + "day-from-dateTime", FN_DayFromDateTime.class);
        StandardFunctions.add(registry, xfn + "hours-from-dateTime", FN_HoursFromDateTime.class);
        StandardFunctions.add(registry, xfn + "minutes-from-dateTime", FN_MinutesFromDateTime.class);
        StandardFunctions.add(registry, xfn + "seconds-from-dateTime", FN_SecondsFromDateTime.class);
        StandardFunctions.add(registry, xfn + "timezone-from-dateTime", FN_TimezoneFromDateTime.class);
        StandardFunctions.add(registry, xfn + "years-from-duration", FN_YearsFromDuration.class);
        StandardFunctions.add(registry, xfn + "months-from-duration", FN_MonthsFromDuration.class);
        StandardFunctions.add(registry, xfn + "days-from-duration", FN_DaysFromDuration.class);
        StandardFunctions.add(registry, xfn + "hours-from-duration", FN_HoursFromDuration.class);
        StandardFunctions.add(registry, xfn + "minutes-from-duration", FN_MinutesFromDuration.class);
        StandardFunctions.add(registry, xfn + "seconds-from-duration", FN_SecondsFromDuration.class);
        StandardFunctions.add(registry, xfn + "years-from-date", FN_YearFromDate.class);
        StandardFunctions.add(registry, xfn + "months-from-date", FN_MonthFromDate.class);
        StandardFunctions.add(registry, xfn + "days-from-date", FN_DayFromDate.class);
        StandardFunctions.add(registry, xfn + "years-from-dateTime", FN_YearFromDateTime.class);
        StandardFunctions.add(registry, xfn + "months-from-dateTime", FN_MonthFromDateTime.class);
        StandardFunctions.add(registry, xfn + "days-from-dateTime", FN_DayFromDateTime.class);
        StandardFunctions.add(registry, xfn + "boolean", FN_BEV.class);
        StandardFunctions.add(registry, xfn + "not", FN_Not.class);
        StandardFunctions.add(registry, xfn + "adjust-dateTime-to-timezone", FN_AdjustDatetimeToTimezone.class);
        StandardFunctions.add(registry, xfn + "adjust-date-to-timezone", FN_AdjustDateToTimezone.class);
        StandardFunctions.add(registry, xfn + "adjust-time-to-timezone", FN_AdjustTimeToTimezone.class);
        StandardFunctions.add(registry, xfn + "implicit-timezone", FN_Timezone.class);
        StandardFunctions.add(registry, math + "pi", pi.class);
        StandardFunctions.add(registry, math + "exp", Math_exp.class);
        StandardFunctions.add(registry, math + "exp10", Math_exp10.class);
        StandardFunctions.add(registry, math + "log", Math_log.class);
        StandardFunctions.add(registry, math + "log10", Math_log10.class);
        StandardFunctions.add(registry, math + "pow", Math_pow.class);
        StandardFunctions.add(registry, math + "sqrt", sqrt.class);
        StandardFunctions.add(registry, math + "sin", sin.class);
        StandardFunctions.add(registry, math + "cos", cos.class);
        StandardFunctions.add(registry, math + "tan", tan.class);
        StandardFunctions.add(registry, math + "asin", sin1.class);
        StandardFunctions.add(registry, math + "acos", cos1.class);
        StandardFunctions.add(registry, math + "atan", tan1.class);
        StandardFunctions.add(registry, math + "atan2", Math_atan2.class);
        StandardFunctions.add(registry, xfn + "apply", FN_Apply.class);
        StandardFunctions.add(registry, xfn + "collation-key", FN_CollationKey.class);
        StandardFunctions.add(registry, xfn + "numeric-mod", Op_NumericMod.class);
        StandardFunctions.add(registry, xfn + "numeric-integer-divide", Op_NumericIntegerDivide.class);
    }

    private static void addCastXSD(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new FunctionCastXSD(dt));
    }

    private static void addCastNumeric(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new FunctionCastXSD(dt));
    }

    private static void addCastTemporal(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new FunctionCastXSD(dt));
    }

    private static void add(FunctionRegistry registry, String uri, Class<?> funcClass) {
        registry.put(uri, funcClass);
    }
}

