/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Objects;

public class PrefixEntry {
    private final String prefix;
    private final String uri;

    public static PrefixEntry create(String prefix, String uri) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(uri);
        return new PrefixEntry(prefix, uri);
    }

    private PrefixEntry(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return "PrefixEntry[" + this.prefix + ": <" + this.uri + ">]";
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixEntry other = (PrefixEntry)obj;
        return Objects.equals(this.prefix, other.prefix) && Objects.equals(this.uri, other.uri);
    }
}

