/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.http.auth.AuthChallenge;
import org.apache.jena.http.auth.AuthRequestModifier;
import org.apache.jena.http.auth.RFC2617;

public class DigestLib {
    private static Random nonceGenerator = new SecureRandom();

    public static String calcDigestChallengeResponse(AuthChallenge auth, String username, String password, String method, String requestTarget, String cnonce, String nc, String authType) {
        String a1 = RFC2617.A1_MD5(username, auth.realm, password);
        if (auth.qop == null) {
            return RFC2617.KD(RFC2617.H(a1), auth.nonce + ":" + RFC2617.H(RFC2617.A2_auth(method, requestTarget)));
        }
        Objects.nonNull(cnonce);
        Objects.nonNull(nc);
        return RFC2617.KD(RFC2617.H(a1), auth.nonce + ":" + nc + ":" + cnonce + ":" + authType + ":" + RFC2617.H(RFC2617.A2_auth(method, requestTarget)));
    }

    public static String generateNonce() {
        return String.format("%08X", nonceGenerator.nextLong());
    }

    private static Pair<String, String> getUserNameAndPassword(HttpClient httpClient) {
        Optional<Authenticator> optAuth = httpClient.authenticator();
        if (optAuth.isEmpty()) {
            throw new HttpException("Username/password required but not present in HttpClient");
        }
        PasswordAuthentication x = optAuth.get().requestPasswordAuthenticationInstance(null, null, -1, null, null, null, null, Authenticator.RequestorType.SERVER);
        String user = x.getUserName();
        String password = new String(x.getPassword());
        return Pair.create((Object)user, (Object)password);
    }

    public static AuthRequestModifier buildDigest(AuthChallenge aHeader, String user, String password, String method, String requestTarget) {
        String clientNonce = DigestLib.generateNonce();
        AtomicLong ncCounter = new AtomicLong(0L);
        return req -> {
            String nc = String.format("%08X", ncCounter.getAndIncrement());
            String responseField = DigestLib.calcDigestChallengeResponse(aHeader, user, password, method, requestTarget, clientNonce, nc, "auth");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Digest ");
            DigestLib.field(stringBuilder, true, "username", user, true);
            DigestLib.field(stringBuilder, false, "realm", aHeader.realm, true);
            DigestLib.field(stringBuilder, false, "nonce", aHeader.nonce, true);
            DigestLib.field(stringBuilder, false, "uri", requestTarget, true);
            DigestLib.field(stringBuilder, false, "qop", "auth", false);
            DigestLib.field(stringBuilder, false, "cnonce", clientNonce, true);
            DigestLib.field(stringBuilder, false, "nc", nc, false);
            DigestLib.field(stringBuilder, false, "response", responseField, true);
            DigestLib.field(stringBuilder, false, "opaque", aHeader.opaque, true);
            String x = stringBuilder.toString();
            req.setHeader("Authorization", x);
            return req;
        };
    }

    private static void field(StringBuilder stringBuilder, boolean first, String name, String value, boolean quotes) {
        if (value == null) {
            return;
        }
        if (!first) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(name);
        stringBuilder.append("=");
        if (quotes) {
            stringBuilder.append('\"');
        }
        stringBuilder.append(value);
        if (quotes) {
            stringBuilder.append('\"');
        }
    }
}

