/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.Binding2Thrift;
import org.apache.jena.riot.thrift.StreamRDF2Thrift;
import org.apache.jena.riot.thrift.StreamRowTRDFPrinter;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.Thift2Binding;
import org.apache.jena.riot.thrift.Thrift2StreamRDF;
import org.apache.jena.riot.thrift.wire.RDF_StreamRow;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransportException;

public class ThriftRDF {
    private static int BUFSIZE_IN = 131072;
    private static int BUFSIZE_OUT = 131072;

    public static StreamRDF streamToFile(String filename) {
        return ThriftRDF.streamToFile(filename, false);
    }

    public static StreamRDF streamToFile(String filename, boolean withValues) {
        OutputStream out = IO.openOutputFile((String)filename);
        BufferedOutputStream bout = new BufferedOutputStream(out, BUFSIZE_OUT);
        TProtocol protocol = TRDF.protocol(bout);
        return new StreamRDF2Thrift(protocol, withValues);
    }

    public static StreamRDF streamToOutputStream(OutputStream out) {
        return ThriftRDF.streamToOutputStream(out, false);
    }

    public static StreamRDF streamToOutputStream(OutputStream out, boolean withValues) {
        return new StreamRDF2Thrift(out, withValues);
    }

    public static StreamRDF streamToTProtocol(TProtocol protocol) {
        return ThriftRDF.streamToTProtocol(protocol, false);
    }

    public static StreamRDF streamToTProtocol(TProtocol protocol, boolean withValues) {
        return new StreamRDF2Thrift(protocol, withValues);
    }

    public static void fileToStream(String filename, StreamRDF dest) {
        InputStream in = IO.openFile((String)filename);
        TProtocol protocol = TRDF.protocol(in);
        ThriftRDF.protocolToStream(protocol, dest);
    }

    public static void inputStreamToStream(InputStream in, StreamRDF dest) {
        TProtocol protocol = TRDF.protocol(in);
        ThriftRDF.protocolToStream(protocol, dest);
    }

    public static void protocolToStream(TProtocol protocol, StreamRDF dest) {
        PrefixMap pmap = PrefixMapFactory.create();
        Thrift2StreamRDF s = new Thrift2StreamRDF(pmap, dest);
        dest.start();
        ThriftRDF.apply(protocol, z -> TRDF.visit(z, s));
        dest.finish();
    }

    public static void apply(TProtocol protocol, Consumer<RDF_StreamRow> action) {
        RDF_StreamRow row = new RDF_StreamRow();
        while (true) {
            try {
                row.read(protocol);
            }
            catch (TTransportException e2) {
                if (e2.getType() == 4) {
                    return;
                }
            }
            catch (TException ex) {
                TRDF.exception(ex);
            }
            action.accept(row);
            row.clear();
        }
    }

    public static void dump(OutputStream out, InputStream in) {
        IndentedWriter iOut = new IndentedWriter(out);
        StreamRowTRDFPrinter printer = new StreamRowTRDFPrinter(iOut);
        TProtocol protocol = TRDF.protocol(in);
        ThriftRDF.apply(protocol, z -> TRDF.visit(z, printer));
        iOut.flush();
    }

    public static ResultSet readResultSet(InputStream in) {
        return ThriftRDF.readResultSet(TRDF.protocol(in));
    }

    public static ResultSet readResultSet(TProtocol protocol) {
        Thift2Binding t2b = new Thift2Binding(protocol);
        List<String> varsNames = Var.varNames(t2b.getVars());
        return ResultSetStream.create(varsNames, null, t2b);
    }

    public static void writeResultSet(OutputStream out, ResultSet resultSet) {
        ThriftRDF.writeResultSet(out, resultSet, false);
    }

    public static void writeResultSet(OutputStream out, ResultSet resultSet, boolean withValues) {
        out = TRDF.ensureBuffered(out);
        ThriftRDF.writeResultSet(TRDF.protocol(out), resultSet, withValues);
        IO.flush((OutputStream)out);
    }

    public static void writeResultSet(TProtocol protocol, ResultSet resultSet) {
        ThriftRDF.writeResultSet(protocol, resultSet, false);
    }

    public static void writeResultSet(TProtocol protocol, ResultSet resultSet, boolean encodeValues) {
        List<Var> vars = Var.varList(resultSet.getResultVars());
        try (Binding2Thrift b2t = new Binding2Thrift(protocol, vars, encodeValues);){
            while (resultSet.hasNext()) {
                Binding b = resultSet.nextBinding();
                b2t.output(b);
            }
        }
    }
}

