/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSetStream;

public class ResultSetStream
implements ResultSet {
    private Iterator<Binding> queryExecutionIter;
    private List<String> resultVars;
    private QuerySolution currentQuerySolution;
    private int rowNumber;
    private Model model;

    public static ResultSet create(List<String> resultVars, Model m, Iterator<Binding> iter) {
        return new ResultSetStream(0, resultVars, m, iter);
    }

    public static ResultSet create(List<Var> resultVars, Iterator<Binding> iter) {
        return ResultSet.adapt(new RowSetStream(resultVars, iter));
    }

    @Deprecated
    public ResultSetStream(List<String> resultVars, Model m, Iterator<Binding> iter) {
        this(57, resultVars, m, iter);
    }

    protected ResultSetStream(int dummy, List<String> resultVars, Model m, Iterator<Binding> iter) {
        this.queryExecutionIter = iter;
        this.resultVars = resultVars;
        this.currentQuerySolution = null;
        this.rowNumber = 0;
        this.model = m;
    }

    @Override
    public boolean hasNext() {
        if (this.queryExecutionIter == null) {
            return false;
        }
        boolean r = this.queryExecutionIter.hasNext();
        if (!r) {
            this.close();
        }
        return r;
    }

    @Override
    public Binding nextBinding() {
        if (this.queryExecutionIter == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        try {
            Binding binding = this.queryExecutionIter.next();
            if (binding != null) {
                ++this.rowNumber;
            }
            return binding;
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        Iter.close(this.queryExecutionIter);
        this.queryExecutionIter = null;
    }

    @Override
    public QuerySolution nextSolution() {
        if (this.queryExecutionIter == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        Binding binding = this.nextBinding();
        this.currentQuerySolution = new ResultBinding(this.model, binding);
        return this.currentQuerySolution;
    }

    @Override
    public QuerySolution next() {
        return this.nextSolution();
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public List<String> getResultVars() {
        return this.resultVars;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }
}

