/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.irix.IRIs;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysRIOT {
    public static final String riotLoggerName = "org.apache.jena.riot";
    private static Logger riotLogger = LoggerFactory.getLogger((String)"org.apache.jena.riot");
    private static String riotBase = "http://jena.apache.org/riot/";
    private static boolean strictMode = false;
    public static final Symbol sysRdfWriterProperties = Symbol.create(riotBase + "rdfWriter_properties");
    public static final Symbol sysRdfReaderProperties = Symbol.create(riotBase + "rdfReader_properties");
    public static Symbol sysStreamManager = Symbol.create(riotBase + "streamManager");

    public static void setStrictMode(boolean state) {
        strictMode = state;
    }

    public static boolean isStrictMode() {
        return strictMode;
    }

    public static String fmtMessage(String message, long line, long col) {
        if (col == -1L && line == -1L) {
            return message;
        }
        if (col == -1L && line != -1L) {
            return String.format("[line: %d] %s", line, message);
        }
        if (col != -1L && line == -1L) {
            return String.format("[col: %d] %s", col, message);
        }
        return String.format("[line: %d, col: %-2d] %s", line, col, message);
    }

    public static Logger getLogger() {
        return riotLogger;
    }

    @Deprecated
    public static String chooseBaseIRI() {
        return IRIs.getBaseStr();
    }

    @Deprecated
    public static String chooseBaseIRI(String baseURI) {
        return IRIs.toBase((String)baseURI);
    }

    public static String chooseBaseIRI(String baseIRI, String fileOrIri) {
        if (baseIRI != null) {
            return baseIRI;
        }
        if (fileOrIri == null || fileOrIri.equals("-")) {
            return "http://localhost/stdin/";
        }
        return IRIs.toBase((String)fileOrIri);
    }

    public static String filename2baseIRI(String filename) {
        if (filename == null || filename.equals("-")) {
            return "http://localhost/stdin/";
        }
        String x = IRILib.filenameToIRI((String)filename);
        return x;
    }
}

