/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.transaction.txn.StateMgrData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPTStateMgr
extends StateMgrData {
    private static Logger log = LoggerFactory.getLogger(BPTStateMgr.class);
    private static int idxRoot = 0;
    private static int idxNodeBlocksLimit = 1;
    private static int idxRecordsBlocksLimit = 2;
    private boolean LOGGING = BPT.Logging;

    private int currentRoot() {
        return (int)super.get(idxRoot);
    }

    private long nodeBlocksLimit() {
        return super.get(idxNodeBlocksLimit);
    }

    private long recordsBlocksLimit() {
        return super.get(idxRecordsBlocksLimit);
    }

    private void currentRoot(int x) {
        super.set(idxRoot, (long)x);
    }

    private void nodeBlocksLimit(long x) {
        super.set(idxNodeBlocksLimit, x);
    }

    private void recordsBlocksLimit(long x) {
        super.set(idxRecordsBlocksLimit, x);
    }

    public BPTStateMgr(BufferChannel storage) {
        super(storage, new long[]{0L, 0L, 0L});
    }

    void setState(int rootIdx, long nodeBlkLimit, long recordsBlkLimit) {
        this.currentRoot(rootIdx);
        this.nodeBlocksLimit(nodeBlkLimit);
        this.recordsBlocksLimit(recordsBlkLimit);
        this.log("Set");
        this.setDirtyFlag();
    }

    protected void writeStateEvent() {
        this.log("Write");
    }

    protected void readStateEvent() {
        this.log("Read");
    }

    private void log(String operation) {
        if (this.LOGGING) {
            FmtLog.info((Logger)log, (String)"%s state:  root=%d // node block limit = %d // records block limit %d", (Object[])new Object[]{operation, this.currentRoot(), this.nodeBlocksLimit(), this.recordsBlocksLimit()});
        }
    }

    public int getRoot() {
        return this.currentRoot();
    }

    public long getNodeBlocksLimit() {
        return this.nodeBlocksLimit();
    }

    public long getRecordsBlocksLimit() {
        return this.recordsBlocksLimit();
    }
}

