/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.update.UpdateRequest;

public class RDFLinkAdapter
implements RDFLink {
    private final RDFConnection conn;

    public static RDFLink adapt(RDFConnection conn) {
        if (conn instanceof RDFConnectionAdapter) {
            return ((RDFConnectionAdapter)conn).getLink();
        }
        return new RDFLinkAdapter(conn);
    }

    protected RDFConnection getConnection() {
        return this.conn;
    }

    public RDFLinkAdapter(RDFConnection conn) {
        this.conn = conn;
    }

    public void begin(TxnType type) {
        this.conn.begin(type);
    }

    public void begin(ReadWrite readWrite) {
        this.conn.begin(readWrite);
    }

    public boolean promote(Transactional.Promote mode) {
        return this.conn.promote(mode);
    }

    public void commit() {
        this.conn.commit();
    }

    public void abort() {
        this.conn.abort();
    }

    public void end() {
        this.conn.end();
    }

    public ReadWrite transactionMode() {
        return this.conn.transactionMode();
    }

    public TxnType transactionType() {
        return this.conn.transactionType();
    }

    public boolean isInTransaction() {
        return this.conn.isInTransaction();
    }

    @Override
    public DatasetGraph getDataset() {
        return this.conn.fetchDataset().asDatasetGraph();
    }

    @Override
    public QueryExec query(Query query) {
        return QueryExec.adapt((QueryExecution)this.conn.query(query));
    }

    @Override
    public QueryExec query(String queryString) {
        return QueryExec.adapt((QueryExecution)this.conn.query(queryString));
    }

    @Override
    public QueryExecBuilder newQuery() {
        throw new UnsupportedOperationException("RDFLinkAdapter.newQuery");
    }

    @Override
    public void update(UpdateRequest update) {
        throw new NotImplemented("Impleemntation needed");
    }

    @Override
    public void update(String update) {
        throw new NotImplemented("Impleemntation needed");
    }

    @Override
    public Graph get() {
        Model m = this.conn.fetch();
        if (m == null) {
            return null;
        }
        return m.getGraph();
    }

    private static String uri(Node node) {
        return node == null ? null : node.getURI();
    }

    @Override
    public Graph get(Node graphName) {
        Model m = this.conn.fetch(RDFLinkAdapter.uri(graphName));
        if (m == null) {
            return null;
        }
        return m.getGraph();
    }

    @Override
    public void load(String file) {
        this.conn.load(file);
    }

    @Override
    public void load(Node graphName, String file) {
        this.conn.load(RDFLinkAdapter.uri(graphName), file);
    }

    @Override
    public void load(Graph graph) {
        this.conn.load(ModelFactory.createModelForGraph((Graph)graph));
    }

    @Override
    public void load(Node graphName, Graph graph) {
        this.conn.load(RDFLinkAdapter.uri(graphName), ModelFactory.createModelForGraph((Graph)graph));
    }

    @Override
    public void put(String file) {
        this.conn.put(file);
    }

    @Override
    public void put(Node graphName, String file) {
        this.conn.put(RDFLinkAdapter.uri(graphName), file);
    }

    @Override
    public void put(Graph graph) {
        this.conn.put(ModelFactory.createModelForGraph((Graph)graph));
    }

    @Override
    public void put(Node graphName, Graph graph) {
        this.conn.put(RDFLinkAdapter.uri(graphName), ModelFactory.createModelForGraph((Graph)graph));
    }

    @Override
    public void delete(Node graphName) {
        this.conn.delete(RDFLinkAdapter.uri(graphName));
    }

    @Override
    public void delete() {
        this.conn.delete();
    }

    @Override
    public void loadDataset(String file) {
        this.conn.loadDataset(file);
    }

    @Override
    public void loadDataset(DatasetGraph dataset) {
        this.conn.loadDataset(DatasetFactory.wrap((DatasetGraph)dataset));
    }

    @Override
    public void putDataset(String file) {
        this.conn.putDataset(file);
    }

    @Override
    public void putDataset(DatasetGraph dataset) {
        this.conn.putDataset(DatasetFactory.wrap((DatasetGraph)dataset));
    }

    @Override
    public void clearDataset() {
        DatasetFactory.wrap((DatasetGraph)DatasetGraphZero.create());
    }

    @Override
    public boolean isClosed() {
        return this.conn.isClosed();
    }

    @Override
    public void close() {
        this.conn.close();
    }
}

