/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import java.util.List;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import org.apache.jena.tdb2.xloader.ProcNodeTableBuilderX;
import org.apache.jena.tdb2.xloader.XLoaderFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdb2.xloader.AbstractCmdxLoad;

public class CmdxBuildNodeTable
extends AbstractCmdxLoad {
    public static void main(String ... args) {
        new CmdxBuildNodeTable(args).mainRun();
    }

    protected CmdxBuildNodeTable(String[] argv) {
        super("Nodes", argv);
    }

    @Override
    protected void setCmdArgs() {
        super.add(argLocation, "--loc=", "Database location");
        super.add(argTmpdir, "--tmpdir=", "Temporary directory (defaults to --loc)");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + this.getArgsSummary();
    }

    @Override
    protected void subCheckArgs() {
        if (this.location == null) {
            throw new CmdException("Required : --loc");
        }
        if (this.filenames.isEmpty()) {
            throw new CmdException("No files to load");
        }
    }

    @Override
    protected String getCommandName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected void exec() {
        FileOps.ensureDir((String)this.location);
        FileOps.clearAll((String)this.location);
        Timer timer = new Timer();
        timer.startTimer();
        FmtLog.info((Logger)LOG, (String)"Build node table", (Object[])new Object[0]);
        FmtLog.info((Logger)LOG, (String)"  Database   = %s", (Object[])new Object[]{this.location});
        FmtLog.info((Logger)LOG, (String)"  TMPDIR     = %s", (Object[])new Object[]{this.tmpdir == null ? "unset" : this.tmpdir});
        FmtLog.info((Logger)LOG, (String)"  Data files = %s", (Object[])new Object[]{StrUtils.strjoin((List)this.filenames, (String)" ")});
        if (this.tmpdir == null) {
            this.tmpdir = this.location;
        }
        Logger LOG1 = LOG;
        Logger LOG2 = LoggerFactory.getLogger((String)"Terms");
        Pair buildCounts = ProcNodeTableBuilderX.exec((Logger)LOG1, (Logger)LOG2, (String)this.location, (XLoaderFiles)this.loaderFiles, (List)this.filenames, (String)this.sortNodeTableArgs);
        long timeMillis = timer.endTimer();
        long items = (Long)buildCounts.getLeft();
        double xSec = (double)timeMillis / 1000.0;
        double rate = (double)items / xSec;
        String elapsedStr = BulkLoaderX.milliToHMS((long)timeMillis);
        String rateStr = BulkLoaderX.rateStr((long)items, (long)timeMillis);
        FmtLog.info((Logger)LOG, (String)"NodeTable - %s seconds - %s at %s terms per second", (Object[])new Object[]{Timer.timeStr((long)timeMillis), elapsedStr, rateStr});
    }
}

