/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.rdf.lang.RdfAlphabet;

public final class LanguageTag {
    private LanguageTag() {
    }

    public static boolean isWellFormed(String languageTag) {
        int index;
        if (languageTag == null) {
            throw new IllegalArgumentException();
        }
        int[] chars = languageTag.trim().codePoints().toArray();
        if (chars.length == 0 || RdfAlphabet.ASCII_ALPHA.negate().test(chars[0])) {
            return false;
        }
        if (chars.length == 1) {
            return true;
        }
        for (index = 1; index < chars.length && chars[index] != 45; ++index) {
            if (RdfAlphabet.ASCII_ALPHA.test(chars[index])) continue;
            return false;
        }
        if (index == chars.length - 1) {
            return chars[index] != 45;
        }
        ++index;
        while (index < chars.length) {
            if (!RdfAlphabet.ASCII_ALPHA_NUM.test(chars[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

