/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.nodetable;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.tdb.TDBException;

class DecoderSSE {
    private static final Token tokenEOF = new Token(TokenType.EOF);

    DecoderSSE() {
    }

    protected static Node parseNode(String str) {
        Tokenizer tokens = TokenizerText.fromString((String)str);
        return DecoderSSE.parseNode(tokens);
    }

    protected static Node parseNode(Tokenizer tokens) {
        Token token = DecoderSSE.nextToken(tokens);
        if (token.hasType(TokenType.LT2)) {
            return DecoderSSE.parseTripleTerm(tokens);
        }
        return DecoderSSE.tokenAsNode(token);
    }

    protected static Node parseTripleTerm(Tokenizer tokens) {
        Triple t = DecoderSSE.parseTriple(tokens);
        Token x = DecoderSSE.nextToken(tokens);
        if (x.getType() != TokenType.GT2) {
            DecoderSSE.exception(x, "Triple term not terminated by >>: %s");
        }
        return NodeFactory.createTripleNode((Triple)t);
    }

    protected static Triple parseTriple(Tokenizer tokens) {
        Token sToken = DecoderSSE.nextToken(tokens);
        if (sToken.isEOF()) {
            DecoderSSE.exception(sToken, "Premature end of file: %s");
        }
        Node s = sToken.hasType(TokenType.LT2) ? DecoderSSE.parseTripleTerm(tokens) : DecoderSSE.tokenAsNode(sToken);
        Token pToken = DecoderSSE.nextToken(tokens);
        if (pToken.isEOF()) {
            DecoderSSE.exception(pToken, "Premature end of file: %s");
        }
        Node p = DecoderSSE.tokenAsNode(pToken);
        Token oToken = DecoderSSE.nextToken(tokens);
        if (oToken.isEOF()) {
            DecoderSSE.exception(oToken, "Premature end of file: %s");
        }
        Node o = oToken.hasType(TokenType.LT2) ? DecoderSSE.parseTripleTerm(tokens) : DecoderSSE.tokenAsNode(oToken);
        return Triple.create((Node)s, (Node)p, (Node)o);
    }

    private static void exception(Token token, String string) {
        String msg = string;
        if (token != null) {
            msg = String.format(string, token);
        }
        throw new TDBException(msg);
    }

    private static Node tokenAsNode(Token token) {
        if (token.isBNode()) {
            String id = token.getImage();
            id = NodeFmtLib.decodeBNodeLabel((String)id);
            return NodeFactory.createBlankNode((String)id);
        }
        return token.asNode();
    }

    private static final Token nextToken(Tokenizer tokens) {
        if (tokens.eof()) {
            return tokenEOF;
        }
        try {
            Token t = tokens.next();
            return t;
        }
        catch (RiotParseException ex) {
            DecoderSSE.exception(null, ex.getMessage());
            throw ex;
        }
        catch (AtlasException ex) {
            DecoderSSE.exception(null, ex.getMessage());
            throw ex;
        }
    }
}

