/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.io.error.RdfWriterException;
import com.apicatalog.rdf.io.nquad.NQuadsWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.JenaTitanium;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.IsoMatcher;
import org.junit.Assert;
import org.junit.Test;

public class TestJenaTitanium {
    @Test
    public final void readContextVersion() {
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        RDFParser.source((String)"testing/RIOT/jsonld11/doc-1.jsonld11").parse(dsg);
        Assert.assertFalse((boolean)dsg.isEmpty());
    }

    @Test
    public void convertDataset() throws IOException, RdfWriterException {
        String dsStr = StrUtils.strjoinNL((String[])new String[]{"(dataset", "(_ :s :p :o)", "(_ :s :p 123)", "(_ :s :p 123.5)", "(_ :s :p 1e10)", "(_ :s :p '2021-08-10'^^xsd:date)", "(_ :s :p 'foo')", "(:g1 :s :p :o)", "(:g1 _:x :p :o)", "(:g2 _:x :p 123)", "(:g2 _:x :p 'abc'@en)", "(_:x _:x :p _:x)", ")"});
        DatasetGraph dsg1 = SSE.parseDatasetGraph((String)dsStr);
        RdfDataset rdfDataset = JenaTitanium.convert((DatasetGraph)dsg1);
        try (StringWriter writer = new StringWriter();){
            NQuadsWriter w = new NQuadsWriter((Writer)writer);
            w.write(rdfDataset);
            String s = writer.toString();
            Assert.assertTrue((boolean)s.contains("_:b0"));
            Assert.assertTrue((boolean)s.contains("http://example/p"));
            Assert.assertTrue((boolean)s.contains("@en"));
        }
        DatasetGraph dsg2 = JenaTitanium.convert((RdfDataset)rdfDataset);
        Assert.assertTrue((boolean)IsoMatcher.isomorphic((DatasetGraph)dsg1, (DatasetGraph)dsg2));
    }
}

