/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.system.TxnCounter;
import org.junit.Assert;
import org.junit.Test;

public class TestCounter {
    private TxnCounter counter = new TxnCounter(0L);

    @Test
    public void counter_lifecycle_1() {
        this.counter.begin(ReadWrite.WRITE);
        this.counter.inc();
        this.counter.commit();
        this.counter.end();
    }

    @Test
    public void counter_lifecycle_2() {
        this.counter.begin(ReadWrite.WRITE);
        this.counter.abort();
        this.counter.end();
    }

    @Test
    public void counter_lifecycle_3() {
        this.counter.begin(ReadWrite.READ);
        this.counter.end();
    }

    @Test
    public void counter_lifecycle_4() {
        this.counter.begin(ReadWrite.READ);
        this.counter.commit();
        this.counter.end();
    }

    @Test
    public void counter_lifecycle_5() {
        this.counter.begin(ReadWrite.READ);
        this.counter.abort();
        this.counter.end();
    }

    @Test
    public void counter_lifecycle_6() {
        this.counter.end();
    }

    @Test
    public void counter_01() {
        Assert.assertEquals((long)0L, (long)this.counter.get());
        Assert.assertEquals((long)0L, (long)this.counter.value());
        this.counter.begin(ReadWrite.WRITE);
        Assert.assertEquals((long)0L, (long)this.counter.get());
        Assert.assertEquals((long)0L, (long)this.counter.value());
        this.counter.inc();
        long x = this.counter.get();
        Assert.assertEquals((long)1L, (long)this.counter.get());
        Assert.assertEquals((long)0L, (long)this.counter.value());
        this.counter.commit();
        Assert.assertEquals((long)1L, (long)this.counter.value());
        this.counter.end();
        Assert.assertEquals((long)1L, (long)this.counter.value());
    }

    @Test
    public void counter_02() {
        Assert.assertEquals((long)0L, (long)this.counter.get());
        Assert.assertEquals((long)0L, (long)this.counter.value());
        this.counter.begin(ReadWrite.WRITE);
        Assert.assertEquals((long)0L, (long)this.counter.get());
        Assert.assertEquals((long)0L, (long)this.counter.value());
        this.counter.inc();
        long x = this.counter.get();
        Assert.assertEquals((long)1L, (long)this.counter.get());
        Assert.assertEquals((long)0L, (long)this.counter.value());
        this.counter.abort();
        Assert.assertEquals((long)0L, (long)this.counter.value());
        this.counter.end();
        Assert.assertEquals((long)0L, (long)this.counter.value());
    }

    @Test(expected=JenaTransactionException.class)
    public void counter_bad_01() {
        this.counter.inc();
    }

    @Test(expected=JenaTransactionException.class)
    public void counter_bad_02() {
        this.counter.begin(ReadWrite.WRITE);
        this.counter.end();
    }

    @Test(expected=JenaTransactionException.class)
    public void counter_bad_03() {
        this.counter.begin(ReadWrite.READ);
        this.counter.inc();
    }

    @Test(expected=JenaTransactionException.class)
    public void counter_bad_04() {
        this.counter.begin(ReadWrite.READ);
        this.counter.end();
        this.counter.commit();
    }

    @Test(expected=JenaTransactionException.class)
    public void counter_bad_05() {
        this.counter.begin(ReadWrite.WRITE);
        this.counter.end();
        this.counter.commit();
    }
}

