/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.AssertExtra;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestList {
    private GNode emptyList = TestList.parse(listStr_1);
    private GNode list4 = TestList.parse(listStr_2);
    private GNode list22 = TestList.parse(listStr_3);
    private Node NIL = RDF.nil.asNode();
    private static Node node1 = NodeFactory.createLiteral((String)"1", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node2 = NodeFactory.createLiteral((String)"2", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node3 = NodeFactory.createLiteral((String)"3", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node4 = NodeFactory.createLiteral((String)"4", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node0 = NodeFactory.createLiteral((String)"0", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node r = NodeFactory.createURI((String)"http://example/r");
    private static Node p = NodeFactory.createURI((String)"http://example/p");
    private static String preamble = "@prefix : <http://example/> . :r :p ";
    private static String listStr_1 = preamble + "() .";
    private static String listStr_2 = preamble + "(1 2 3 4) .";
    private static String listStr_3 = preamble + "(1 2 1 2) .";
    private static String data = "prefix : <http://example/>\n:s1 :p (1 2 3) .\n:s2 :p () .\n:s3 :p (8) .\n";
    private static Node s1 = NodeFactory.createURI((String)"http://example/s1");
    private static Node s2 = NodeFactory.createURI((String)"http://example/s2");
    private static Node s3 = NodeFactory.createURI((String)"http://example/s3");
    private static Graph graph = Factory.createDefaultGraph();

    @Test
    public void testListLength_1() {
        Assert.assertEquals((long)0L, (long)GraphList.length((GNode)this.emptyList));
    }

    @Test
    public void testListLength_2() {
        Assert.assertEquals((long)4L, (long)GraphList.length((GNode)this.list4));
    }

    @Test
    public void testListLength_3() {
        Assert.assertEquals((long)4L, (long)GraphList.length((GNode)this.list22));
    }

    @Test
    public void testListIndex_1() {
        Assert.assertEquals((long)0L, (long)GraphList.index((GNode)this.list4, (Node)node1));
    }

    @Test
    public void testListIndex_2() {
        Assert.assertEquals((long)1L, (long)GraphList.index((GNode)this.list4, (Node)node2));
    }

    @Test
    public void testListIndex_3() {
        Assert.assertEquals((long)2L, (long)GraphList.index((GNode)this.list4, (Node)node3));
    }

    @Test
    public void testListIndex_4() {
        Assert.assertEquals((long)3L, (long)GraphList.index((GNode)this.list4, (Node)node4));
    }

    @Test
    public void testListIndex_5() {
        Assert.assertEquals((long)-1L, (long)GraphList.index((GNode)this.list4, (Node)node0));
    }

    @Test
    public void testListIndex_6() {
        Assert.assertEquals((long)-1L, (long)GraphList.index((GNode)this.emptyList, (Node)node1));
    }

    @Test
    public void testListIndex_7() {
        Assert.assertEquals((long)0L, (long)GraphList.index((GNode)this.list22, (Node)node1));
    }

    @Test
    public void testListIndex_8() {
        Assert.assertEquals((long)1L, (long)GraphList.index((GNode)this.list22, (Node)node2));
    }

    @Test
    public void testListIndexes_1() {
        List x = GraphList.indexes((GNode)this.emptyList, (Node)node0);
        Assert.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void testListIndexes_2() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node0);
        Assert.assertEquals((long)0L, (long)x.size());
    }

    @Test
    public void testListIndexes_3() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node1);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((long)0L, (long)((Integer)x.get(0)).intValue());
    }

    @Test
    public void testListIndexes_4() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node2);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((long)1L, (long)((Integer)x.get(0)).intValue());
    }

    @Test
    public void testListIndexes_5() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node4);
        Assert.assertEquals((long)1L, (long)x.size());
        Assert.assertEquals((long)3L, (long)((Integer)x.get(0)).intValue());
    }

    @Test
    public void testListIndexes_6() {
        List x = GraphList.indexes((GNode)this.list22, (Node)node1);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertEquals((long)0L, (long)((Integer)x.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)x.get(1)).intValue());
    }

    @Test
    public void testListTriples_1() {
        Assert.assertEquals((long)0L, (long)GraphList.allTriples((GNode)this.emptyList).size());
    }

    @Test
    public void testListTriples_2() {
        Assert.assertEquals((long)8L, (long)GraphList.allTriples((GNode)this.list4).size());
    }

    @Test
    public void testListContains_1() {
        Assert.assertFalse((boolean)GraphList.contains((GNode)this.emptyList, (Node)node0));
    }

    @Test
    public void testListContains_2() {
        Assert.assertFalse((boolean)GraphList.contains((GNode)this.emptyList, (Node)node1));
    }

    @Test
    public void testListContains_3() {
        Assert.assertTrue((boolean)GraphList.contains((GNode)this.list4, (Node)node1));
    }

    @Test
    public void testListContains_4() {
        Assert.assertTrue((boolean)GraphList.contains((GNode)this.list4, (Node)node2));
    }

    @Test
    public void testListContains_5() {
        Assert.assertTrue((boolean)GraphList.contains((GNode)this.list4, (Node)node4));
    }

    @Test
    public void testListOccurs_1() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs((GNode)this.emptyList, (Node)node0));
    }

    @Test
    public void testListOccurs_2() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs((GNode)this.emptyList, (Node)node1));
    }

    @Test
    public void testListOccurs_3() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs((GNode)this.list4, (Node)node0));
    }

    @Test
    public void testListOccurs_4() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs((GNode)this.emptyList, (Node)node1));
    }

    @Test
    public void testListOccurs_5() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs((GNode)this.emptyList, (Node)this.NIL));
    }

    @Test
    public void testListOccurs_6() {
        Assert.assertEquals((long)0L, (long)GraphList.occurs((GNode)this.list4, (Node)this.NIL));
    }

    @Test
    public void testListOccurs_7() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs((GNode)this.list4, (Node)node1));
    }

    @Test
    public void testListOccurs_8() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs((GNode)this.list4, (Node)node2));
    }

    @Test
    public void testListOccurs_9() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs((GNode)this.list4, (Node)node3));
    }

    @Test
    public void testListOccurs_10() {
        Assert.assertEquals((long)1L, (long)GraphList.occurs((GNode)this.list4, (Node)node4));
    }

    @Test
    public void testListOccurs_11() {
        Assert.assertEquals((long)2L, (long)GraphList.occurs((GNode)this.list22, (Node)node1));
    }

    @Test
    public void testListOccurs_12() {
        Assert.assertEquals((long)2L, (long)GraphList.occurs((GNode)this.list22, (Node)node2));
    }

    @Test
    public void testListGet_1() {
        Assert.assertNull((Object)GraphList.get((GNode)this.emptyList, (int)0));
    }

    @Test
    public void testListGet_2() {
        Assert.assertNull((Object)GraphList.get((GNode)this.emptyList, (int)-1));
    }

    @Test
    public void testListGet_3() {
        Assert.assertNull((Object)GraphList.get((GNode)this.list4, (int)-1));
    }

    @Test
    public void testListGet_4() {
        Assert.assertNull((Object)GraphList.get((GNode)this.list4, (int)9));
    }

    @Test
    public void testListGet_5() {
        Assert.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list4, (int)0));
    }

    @Test
    public void testListGet_6() {
        Assert.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list4, (int)0));
        Assert.assertEquals((Object)node2, (Object)GraphList.get((GNode)this.list4, (int)1));
        Assert.assertEquals((Object)node3, (Object)GraphList.get((GNode)this.list4, (int)2));
        Assert.assertEquals((Object)node4, (Object)GraphList.get((GNode)this.list4, (int)3));
    }

    @Test
    public void testListGet_7() {
        Assert.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list22, (int)0));
        Assert.assertEquals((Object)node2, (Object)GraphList.get((GNode)this.list22, (int)1));
        Assert.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list22, (int)2));
        Assert.assertEquals((Object)node2, (Object)GraphList.get((GNode)this.list22, (int)3));
    }

    private static GNode gnode(Node n) {
        return new GNode(Factory.createDefaultGraph(), n);
    }

    private static GNode parse(String str) {
        Model m = ModelFactory.createDefaultModel();
        m.read((Reader)new StringReader(str), null, "TTL");
        Graph graph = m.getGraph();
        Triple t = (Triple)graph.find(r, p, Node.ANY).next();
        return new GNode(graph, t.getObject());
    }

    @Test
    public void testGraphListMember_01() {
        TestList.testGraphListMember(s1, node1, node2, node3);
    }

    @Test
    public void testGraphListMember_02() {
        TestList.testGraphListMember(s2, new Node[0]);
    }

    @Test
    public void testGraphListMember_03() {
        TestList.testGraphListMember(s3, SSE.parseNode((String)"8"));
    }

    private static void testGraphListMember(Node s, Node ... expected) {
        Node list = TestList.listOf(graph, s);
        Iterator iter = GraphList.listMember((Graph)graph, (Node)list, (Node)Node.ANY);
        Iterator x = G.triple2object((Iterator)iter);
        List z = Iter.toList((Iterator)x);
        TestList.check(z, expected);
    }

    private static Node listOf(Graph graph, Node node) {
        return ((Triple)graph.find(node, p, Node.ANY).next()).getObject();
    }

    private static void check(List<Node> z, Node ... expected) {
        List<Node> x = Arrays.asList(expected);
        AssertExtra.assertEqualsUnordered(x, z);
    }

    static {
        RDFDataMgr.read((Graph)graph, (StringReader)new StringReader(data), null, (Lang)Lang.TTL);
    }
}

