/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.scripting;

import java.util.Arrays;
import java.util.Collection;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.scripting.LanguageSymbols;
import org.apache.jena.sparql.function.scripting.ScriptFunction;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.Context;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestScriptFunction {
    private static Context ctx = ARQ.getContext();
    private String language;
    private String library;
    private String functions;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"js", "testing/ARQ/Scripting/test-library.js", "function toCamelCase(str) { return str.split(' ').map(cc).join('');}\nfunction ucFirst(word)    { return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();}\nfunction lcFirst(word)    { return word.toLowerCase(); }\nfunction cc(word,index)   { return (index == 0) ? lcFirst(word) : ucFirst(word); }\n"}, {"python", "testing/ARQ/Scripting/test-library.py", "def toCamelCase(str):\n  return ''.join([cc(word, index) for index, word in enumerate(str.split(' '))])\ndef ucFirst(word):\n  return word[0].upper() + word[1:].lower()\ndef lcFirst(word):\n  return word.lower()\ndef cc(word,index):\n  if index == 0:\n    return lcFirst(word)\n  return ucFirst(word)\n"});
    }

    public TestScriptFunction(String language, String library, String functions) {
        this.language = language;
        this.library = library;
        this.functions = functions;
    }

    @Before
    public void setup() {
        ctx.set(LanguageSymbols.scriptLibrary((String)this.language), (Object)this.library);
        ctx.set(LanguageSymbols.scriptFunctions((String)this.language), (Object)this.functions);
    }

    @After
    public void teardown() {
        ctx.unset(LanguageSymbols.scriptFunctions((String)this.language));
        ctx.unset(LanguageSymbols.scriptLibrary((String)this.language));
        ScriptFunction.clearEngineCache();
    }

    @Test
    public void script_dt_boolean() {
        NodeValue nv = this.eval("rtnBoolean", new String[0]);
        Assert.assertTrue((boolean)nv.isBoolean());
    }

    @Test
    public void script_dt_string() {
        NodeValue nv = this.eval("rtnString", new String[0]);
        Assert.assertTrue((boolean)nv.isString());
    }

    @Test
    public void script_dt_integer() {
        NodeValue nv = this.eval("rtnInteger", new String[0]);
        this.assertDatatype(nv, XSDDatatype.XSDinteger);
    }

    @Test
    public void script_dt_double() {
        NodeValue nv = this.eval("rtnDouble", new String[0]);
        this.assertDatatype(nv, XSDDatatype.XSDdouble);
    }

    @Test(expected=ExprEvalException.class)
    public void script_dt_undef() {
        NodeValue nv = this.eval("rtnUndef", new String[0]);
    }

    @Test(expected=ExprEvalException.class)
    public void script_dt_null() {
        NodeValue nv = this.eval("rtnNull", new String[0]);
    }

    @Test
    public void script_dt_1() {
        NodeValue nv = this.eval("identity", "'2018-01-06T17:56:41.293+00:00'^^xsd:dateTime");
    }

    @Test
    public void script_1() {
        NodeValue nv = this.eval("identity", "1");
        Assert.assertNotNull((Object)nv);
    }

    @Test
    public void script_2() {
        NodeValue nv = this.eval("value", "<http://example/xyz>");
        Assert.assertNotNull((Object)nv);
        Assert.assertTrue((boolean)nv.isString());
    }

    @Test
    public void script_3() {
        NodeValue nv = this.eval("combine", "1", "2");
        NodeValue nvx = TestScriptFunction.nv("3");
        Assert.assertTrue((boolean)nv.isNumber());
        this.assertDatatype(nv, XSDDatatype.XSDinteger);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void script_4() {
        NodeValue nv = this.eval("combine", "'a'", "2");
        NodeValue nvx = TestScriptFunction.nv("'a2'");
        Assert.assertTrue((boolean)nv.isString());
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void script_5() {
        NodeValue nv = this.eval("combine", "2", "'a'");
        NodeValue nvx = TestScriptFunction.nv("'2a'");
        Assert.assertTrue((boolean)nv.isString());
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void script_6() {
        NodeValue nv = this.eval("combine", "2", "2.5");
        NodeValue nvx = TestScriptFunction.nv("4.5e0");
        this.assertDatatype(nv, XSDDatatype.XSDdouble);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void script_7() {
        NodeValue nv = this.eval("combine", "2.5", "3.5");
        NodeValue nvx = TestScriptFunction.nv("6");
        this.assertDatatype(nv, XSDDatatype.XSDinteger);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    @Test
    public void script_8() {
        NodeValue nv = this.eval("toCamelCase", "'abc def ghi'");
        NodeValue nvx = TestScriptFunction.nv("'abcDefGhi'");
        this.assertDatatype(nv, XSDDatatype.XSDstring);
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    private void assertDatatype(NodeValue nv, XSDDatatype xsdDatatype) {
        Assert.assertEquals((Object)nv.asNode().getLiteralDatatype(), (Object)xsdDatatype);
    }

    @Test(expected=ExprEvalException.class)
    public void script_err_1() {
        NodeValue nv = this.eval("no_such_function()", new String[0]);
    }

    @Test(expected=ExprEvalException.class)
    public void script_err_2() {
        NodeValue nv = this.eval("identity", new String[0]);
    }

    @Test
    public void script_err_3() {
        if (!this.language.equals("JS")) {
            return;
        }
        NodeValue nv = this.eval("combine", "'a'");
        Assert.assertNotNull((Object)nv);
    }

    @Test
    public void script_err_4() {
        if (!this.language.equals("JS")) {
            return;
        }
        NodeValue nv = this.eval("identity", "3", "2");
        NodeValue nvx = TestScriptFunction.nv("3");
        Assert.assertEquals((Object)nvx, (Object)nv);
    }

    private NodeValue eval(String fn, String ... args) {
        NodeValue[] nvs = new NodeValue[args.length];
        for (int i = 0; i < args.length; ++i) {
            nvs[i] = TestScriptFunction.nv(args[i]);
        }
        ScriptFunction f = new ScriptFunction();
        f.build("http://jena.apache.org/ARQ/" + this.language + "Function#" + fn, null);
        return f.exec(Arrays.asList(nvs));
    }

    private static NodeValue nv(String str) {
        return NodeValue.makeNode((Node)SSE.parseNode((String)str));
    }
}

