/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.expr.LibTestExpr;
import org.junit.Test;

public class TestExpressionsMath {
    @Test
    public void pi_01() {
        LibTestExpr.testDouble("math:pi()", "3.1415926", 1.0E-5);
    }

    @Test(expected=ARQException.class)
    public void pi_02() {
        LibTestExpr.testDouble("math:pi(1)", "3.1415926", 1.0E-5);
    }

    @Test
    public void exp_01() {
        LibTestExpr.testDouble("math:exp(2)", Math.exp(2.0), 1.0E-5);
    }

    @Test
    public void exp_02() {
        LibTestExpr.testDouble("math:exp(2.0)", Math.exp(2.0), 1.0E-5);
    }

    @Test
    public void exp_03() {
        LibTestExpr.testDouble("math:exp(-2e1)", Math.exp(-20.0), 1.0E-5);
    }

    @Test
    public void exp_04() {
        LibTestExpr.test("math:exp(1e0/0)", "'INF'^^xsd:double");
    }

    @Test
    public void exp_05() {
        LibTestExpr.test("math:exp('INF'^^xsd:double)", "'INF'^^xsd:double");
    }

    @Test
    public void exp_06() {
        LibTestExpr.test("math:exp('-INF'^^xsd:double)", "'0.0e0'^^xsd:double");
    }

    @Test
    public void exp_07() {
        LibTestExpr.test("math:exp('NaN'^^xsd:double)", "'NaN'^^xsd:double");
    }

    @Test
    public void exp10_01() {
        LibTestExpr.test("math:exp10(2)", "100");
    }

    @Test
    public void exp10_02() {
        LibTestExpr.testDouble("math:exp10(-1)", 0.1, 1.0E-5);
    }

    @Test
    public void exp10_03() {
        LibTestExpr.testDouble("math:exp10(2.0)", 100.0, 1.0E-5);
    }

    @Test
    public void exp10_04() {
        LibTestExpr.test("math:exp10(0)", "1");
    }

    @Test
    public void exp10_05() {
        LibTestExpr.testDouble("math:exp10('NaN'^^xsd:double)", Double.NaN, 1.0E-7);
    }

    @Test
    public void log_01() {
        LibTestExpr.testDouble("math:log(1)", Math.log(1.0), 1.0E-7);
    }

    @Test
    public void log_02() {
        LibTestExpr.testDouble("math:log('NaN'^^xsd:double)", Double.NaN, 1.0E-7);
    }

    @Test
    public void log_03() {
        LibTestExpr.test("math:log('INF'^^xsd:double)", "'INF'^^xsd:double");
    }

    @Test
    public void log_04() {
        LibTestExpr.test("math:log(0)", "'-INF'^^xsd:double");
    }

    @Test
    public void log_05() {
        LibTestExpr.test("math:exp('INF'^^xsd:double)", "'INF'^^xsd:double");
    }

    @Test
    public void log_06() {
        LibTestExpr.test("math:exp('-INF'^^xsd:double)", "'0.0e0'^^xsd:double");
    }

    @Test
    public void log_07() {
        LibTestExpr.test("math:exp('NaN'^^xsd:double)", "'NaN'^^xsd:double");
    }

    @Test
    public void pow_01() {
        LibTestExpr.test("math:pow(2,2)", "4");
    }

    @Test
    public void pow_02() {
        LibTestExpr.testDouble("math:pow(2,-2)", 0.25, 1.0E-5);
    }

    @Test
    public void pow_03() {
        LibTestExpr.test("math:pow(2,0)", "1");
    }

    @Test
    public void pow_10() {
        LibTestExpr.test("math:pow('INF'^^xsd:double, 1)", "'INF'^^xsd:double");
    }

    @Test
    public void pow_11() {
        LibTestExpr.test("math:pow(1, 'INF'^^xsd:double)", "1");
    }

    @Test
    public void pow_12() {
        LibTestExpr.test("math:pow(1e0, 'INF'^^xsd:double)", "'1.0e0'^^xsd:double");
    }

    @Test
    public void pow_13() {
        LibTestExpr.test("math:pow('INF'^^xsd:double,0)", "'1.0e0'^^xsd:double");
    }

    @Test
    public void pow_14() {
        LibTestExpr.test("math:pow('-INF'^^xsd:double, 0)", "'1.0e0'^^xsd:double");
    }

    @Test
    public void pow_15() {
        LibTestExpr.test("math:pow('NaN'^^xsd:double, 1)", "'NaN'^^xsd:double");
    }

    @Test
    public void pow_16() {
        LibTestExpr.test("math:pow(1, 'NaN'^^xsd:double)", "'NaN'^^xsd:double");
    }

    @Test
    public void sqrt_01() {
        LibTestExpr.test("math:sqrt(1)", "'1.0e0'^^xsd:double");
    }

    @Test
    public void sqrt_02() {
        LibTestExpr.testDouble("math:sqrt(2)", Math.sqrt(2.0), 1.0E-6);
    }

    @Test
    public void sqrt_03() {
        LibTestExpr.test("math:sqrt(-2)", "'NaN'^^xsd:double");
    }

    @Test(expected=ARQException.class)
    public void sqrt_04() {
        LibTestExpr.test("math:sqrt('TWO')", "'dummy'");
    }

    @Test
    public void sqrt_10() {
        LibTestExpr.test("math:sqrt('INF'^^xsd:double)", "'INF'^^xsd:double");
    }

    @Test
    public void sqrt_11() {
        LibTestExpr.test("math:sqrt('-INF'^^xsd:double)", "'NaN'^^xsd:double");
    }

    @Test
    public void sqrt_12() {
        LibTestExpr.test("math:sqrt('NaN'^^xsd:double)", "'NaN'^^xsd:double");
    }

    @Test
    public void atan2_01() {
        LibTestExpr.testDouble("math:atan2(0,1)", "0.0e0", 1.0E-5);
    }

    @Test
    public void atan2_02() {
        LibTestExpr.testDouble("math:atan2(1,0)", 1.5707963267948966, 1.0E-5);
    }

    @Test
    public void atan2_03() {
        LibTestExpr.testDouble("math:atan2(2.0,0.0)", 1.5707963267948966, 1.0E-5);
    }

    @Test
    public void atan2_04() {
        LibTestExpr.testDouble("math:atan2(-2.0e1, 0.0)", -1.5707963267948966, 1.0E-5);
    }
}

