/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.AssertExtra;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDatasetGraphFindPatterns {
    static Quad q = SSE.parseQuad((String)"(:g :s :p :o)");
    static Quad q_g = SSE.parseQuad((String)"(:gx :s :p :o)");
    static Quad q_s = SSE.parseQuad((String)"(:g :sx :p :o)");
    static Quad q_p = SSE.parseQuad((String)"(:g :s :px :o)");
    static Quad q_o = SSE.parseQuad((String)"(:g :s :p :ox)");
    static Quad q_gs = SSE.parseQuad((String)"(:gx :sx :p :o)");
    static Quad q_gp = SSE.parseQuad((String)"(:gx :s :px :o)");
    static Quad q_go = SSE.parseQuad((String)"(:gx :s :p :ox)");
    static Quad q_sp = SSE.parseQuad((String)"(:g :sx :px :o)");
    static Quad q_so = SSE.parseQuad((String)"(:g :sx :p :ox)");
    static Quad q_po = SSE.parseQuad((String)"(:g :s :px :ox)");
    static Quad q_gsp = SSE.parseQuad((String)"(:gx :sx :px :o)");
    static Quad q_gpo = SSE.parseQuad((String)"(:gx :s :px :ox)");
    static Quad q_gso = SSE.parseQuad((String)"(:gx :sx :p :ox)");
    static Quad q_spo = SSE.parseQuad((String)"(:g :sx :px :ox)");
    static Quad q_gspo = SSE.parseQuad((String)"(:gx :sx :px :ox)");
    static List<Quad> dataPattern = Arrays.asList(q, q_g, q_s, q_p, q_o, q_gs, q_gp, q_go, q_sp, q_so, q_po, q_gsp, q_gpo, q_gso, q_spo, q_gspo);

    static void add(DatasetGraph data, Collection<Quad> quads) {
        for (Quad q : quads) {
            data.add(q);
        }
    }

    protected DatasetGraph create(Collection<Quad> data) {
        DatasetGraph dsg = this.create();
        AbstractDatasetGraphFindPatterns.add(dsg, data);
        return dsg;
    }

    protected abstract DatasetGraph create();

    private Node node(String str) {
        return SSE.parseNode((String)str);
    }

    @Test
    public void find_quad_00() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find());
        Assert.assertNotNull((String)"find()", (Object)quads1);
        List quads2 = Iter.toList((Iterator)dsg.find(null, null, null, null));
        Assert.assertNotNull((String)"find(null,null,null,null)", (Object)quads2);
        AssertExtra.assertEqualsUnordered((String)"find()", (List)quads1, (List)quads2);
    }

    @Test
    public void find_pattern_gspo() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":g"), this.node(":s"), this.node(":p"), this.node(":o")));
        Assert.assertNotNull((String)"find(g,s,p,o)", (Object)quads1);
        List<Quad> quads2 = Arrays.asList(q);
        AssertExtra.assertEqualsUnordered((String)"find(gspo)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_g() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":gx"), null, null, null));
        List<Quad> quads2 = Arrays.asList(q_g, q_gs, q_gp, q_go, q_gsp, q_gso, q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(g)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_s() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(null, this.node(":sx"), null, null));
        List<Quad> quads2 = Arrays.asList(q_s, q_gs, q_sp, q_so, q_gsp, q_gso, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(s)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_p() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(null, null, this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_p, q_gp, q_sp, q_po, q_gsp, q_gpo, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(p)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_o() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(null, null, null, this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_o, q_go, q_so, q_po, q_gpo, q_gso, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(o)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_gs() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":gx"), this.node(":sx"), null, null));
        List<Quad> quads2 = Arrays.asList(q_gs, q_gsp, q_gso, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gs)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_gp() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":gx"), null, this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_gp, q_gsp, q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gp)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_go() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":gx"), null, null, this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_go, q_gpo, q_gso, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(go)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_sp() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(null, this.node(":sx"), this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_sp, q_gsp, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(sp)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_so() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(null, this.node(":sx"), null, this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_so, q_gso, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(so)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_po() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(null, null, this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_po, q_gpo, q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(po)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_gsp() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":gx"), this.node(":sx"), this.node(":px"), null));
        List<Quad> quads2 = Arrays.asList(q_gsp, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gsp)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_gpo() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":gx"), null, this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gpo)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_gso() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(this.node(":gx"), null, this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_gpo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(gso)", (List)quads1, quads2);
    }

    @Test
    public void find_pattern_spo() {
        DatasetGraph dsg = this.create(dataPattern);
        List quads1 = Iter.toList((Iterator)dsg.find(null, this.node(":sx"), this.node(":px"), this.node(":ox")));
        List<Quad> quads2 = Arrays.asList(q_spo, q_gspo);
        AssertExtra.assertEqualsUnordered((String)"find(spo)", (List)quads1, quads2);
    }
}

