/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.optimize.TransformPathFlattern;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathCompiler;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTransformPathFlatten {
    private static String pre = "(prefix ((: <http://example/>))";
    private static String post = ")";
    private static Prologue prologue;

    @BeforeClass
    public static void beforeClass() {
        prologue = new Prologue();
        prologue.getPrefixMapping().setNsPrefix("", "http://example/");
    }

    @Before
    public void before() {
        PathCompiler.resetForTest();
    }

    @Test
    public void pathFlatten_00() {
        Op op1 = TestTransformPathFlatten.path(":x0", ":p0", ":T0");
        Op op2 = TestTransformPathFlatten.op("(bgp (triple :x0 :p0 :T0))");
        TestTransformPathFlatten.test(op1, op2);
    }

    @Test
    public void pathFlatten_01() {
        Op op1 = TestTransformPathFlatten.path(":x1", ":q1/:p1*", ":T1");
        Op op2 = TestTransformPathFlatten.op("(sequence", "  (bgp (triple :x1 :q1 ??P0))", "  (path ??P0 (path* :p1) :T1))");
        TestTransformPathFlatten.test(op1, op2);
    }

    @Test
    public void pathFlatten_02() {
        Op op1 = TestTransformPathFlatten.path("?x", ":q1/:p1*", ":T1");
        Op op2 = TestTransformPathFlatten.op("(sequence", "  (path ??P0 (path* :p1) :T1)", "  (bgp (triple ?x :q1 ??P0)) )");
        TestTransformPathFlatten.test(op1, op2);
    }

    @Test
    public void pathFlatten_10() {
        Op op1 = TestTransformPathFlatten.path("?x", ":p1{2}", ":T1");
        Op op2 = TestTransformPathFlatten.op("(bgp", "  (triple ?x :p1 ??P0)", "  (triple ??P0 :p1 :T1)", ")");
        TestTransformPathFlatten.test(op1, op2);
    }

    @Test
    public void pathFlatten_11() {
        Op op1 = TestTransformPathFlatten.path("?x", ":p1{2,}", ":T1");
        Op op2 = TestTransformPathFlatten.op("(sequence", "    (path ??P0 (pathN* :p1) :T1)", "    (bgp", "      (triple ?x :p1 ??P1)", "      (triple ??P1 :p1 ??P0)", "   ))");
        TestTransformPathFlatten.test(op1, op2);
    }

    private static Op path(String s, String pathStr, String o) {
        Path path = PathParser.parse((String)pathStr, (Prologue)prologue);
        TriplePath tp = new TriplePath(SSE.parseNode((String)s), path, SSE.parseNode((String)o));
        return new OpPath(tp);
    }

    private static Op op(String ... opStr) {
        String s = StrUtils.strjoinNL((String[])opStr);
        String input = pre + s + post;
        return SSE.parseOp((String)input);
    }

    private static void test(Op opInput, Op opExpected) {
        Op op = Transformer.transform((Transform)new TransformPathFlattern(), (Op)opInput);
        if (opExpected == null) {
            System.out.print(opInput);
            System.out.println("  ==>");
            System.out.print(op);
            System.out.println();
            return;
        }
        Assert.assertEquals((Object)opExpected, (Object)op);
    }
}

