/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import java.io.Closeable;
import java.io.File;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.stream.Locator;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.sparql.util.Context;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStreamManager {
    private static final String directory = "testing/RIOT/StreamManager";
    private static final String absDirectory = new File("testing/RIOT/StreamManager").getAbsolutePath();
    private static StreamManager streamMgrDir;
    private static StreamManager streamMgrHere;
    private static StreamManager streamMgrNull;
    private static StreamManager streamMgrStd;

    @BeforeClass
    public static void beforeClass() {
        streamMgrStd = StreamManager.get();
        streamMgrDir = new StreamManager();
        streamMgrDir.addLocator((Locator)new LocatorFile(directory));
        streamMgrDir.addLocator((Locator)new LocatorHTTP());
        streamMgrHere = new StreamManager();
        streamMgrHere.addLocator((Locator)new LocatorFile());
        streamMgrHere.addLocator((Locator)new LocatorHTTP());
        streamMgrNull = new StreamManager();
    }

    @AfterClass
    public static void afterClass() {
        StreamManager.setGlobal((StreamManager)streamMgrStd);
    }

    private static Context context(StreamManager streamMgr) {
        Context context = new Context();
        context.put(SysRIOT.sysStreamManager, (Object)streamMgr);
        return context;
    }

    @Test
    public void fm_open_01() {
        TestStreamManager.open(streamMgrNull, "testing/RIOT/StreamManager/D.ttl", TestStreamManager.context(streamMgrHere));
    }

    @Test
    public void fm_open_02() {
        TestStreamManager.open(streamMgrHere, "testing/RIOT/StreamManager/D.ttl", null);
    }

    @Test
    public void fm_open_03() {
        TestStreamManager.open(streamMgrNull, "D.ttl", TestStreamManager.context(streamMgrDir));
    }

    @Test
    public void fm_open_04() {
        TestStreamManager.open(streamMgrDir, "D.ttl", null);
    }

    @Test
    public void fm_open_05() {
        TestStreamManager.open(streamMgrHere, "file:testing/RIOT/StreamManager/D.ttl", TestStreamManager.context(streamMgrHere));
    }

    @Test
    public void fm_open_06() {
        TestStreamManager.open(streamMgrHere, "file:testing/RIOT/StreamManager/D.ttl", null);
    }

    @Test
    public void fm_open_07() {
        TestStreamManager.open(streamMgrHere, "file:D.ttl", TestStreamManager.context(streamMgrDir));
    }

    @Test
    public void fm_open_08() {
        TestStreamManager.open(streamMgrDir, "file:D.ttl", null);
    }

    @Test
    public void fm_open_09() {
        TestStreamManager.open(streamMgrHere, absDirectory + "/D.ttl", null);
    }

    @Test
    public void fm_open_10() {
        TestStreamManager.open(streamMgrDir, absDirectory + "/D.ttl", null);
    }

    @Test
    public void fm_open_11() {
        TestStreamManager.open(streamMgrDir, "file://" + absDirectory + "/D.ttl", null);
    }

    @Test
    public void fm_open_12() {
        TestStreamManager.open(streamMgrHere, "file://" + absDirectory + "/D.ttl", null);
    }

    @Test(expected=RiotNotFoundException.class)
    public void fm_open_20() {
        TestStreamManager.open(null, "nosuchfile", TestStreamManager.context(streamMgrDir));
    }

    @Test(expected=RiotNotFoundException.class)
    public void fm_open_21() {
        TestStreamManager.open(streamMgrHere, "nosuchfile", null);
    }

    @Test
    public void fm_read_01() {
        TestStreamManager.read("D.nt");
    }

    @Test
    public void fm_read_02() {
        TestStreamManager.read("D.ttl");
    }

    @Test
    public void fm_read_03() {
        TestStreamManager.read("D.rdf");
    }

    @Test
    public void fm_read_04() {
        TestStreamManager.read("D.rj");
    }

    @Test
    public void fm_read_05() {
        TestStreamManager.read("D.jsonld");
    }

    @Test
    public void fm_read_11() {
        TestStreamManager.read("file:D.nt");
    }

    @Test
    public void fm_read_12() {
        TestStreamManager.read("file:D.ttl");
    }

    @Test
    public void fm_read_13() {
        TestStreamManager.read("file:D.rdf");
    }

    @Test
    public void fm_read_14() {
        TestStreamManager.read("file:D.rj");
    }

    @Test
    public void fm_read_15() {
        TestStreamManager.read("file:D.jsonld");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void open(StreamManager streamMgr, String dataName, Context context) {
        StreamManager.setGlobal((StreamManager)streamMgr);
        try {
            TypedInputStream in = RDFDataMgr.open((String)dataName, (StreamManager)StreamManager.get((Context)context));
            Assert.assertNotNull((Object)in);
            IO.close((Closeable)in);
        }
        finally {
            StreamManager.setGlobal((StreamManager)streamMgrStd);
        }
    }

    private static void read(String dataName) {
        try {
            StreamManager.setGlobal((StreamManager)streamMgrDir);
            Model m = ModelFactory.createDefaultModel();
            RDFDataMgr.read((Model)m, (String)dataName);
            Assert.assertNotEquals((String)("Read " + dataName), (long)0L, (long)m.size());
        }
        finally {
            StreamManager.setGlobal((StreamManager)streamMgrStd);
        }
    }
}

