/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.CollectorStreamQuads;
import org.apache.jena.riot.lang.CollectorStreamTriples;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.junit.Assert;
import org.junit.Test;

public class TestCollectorStream {
    private List<Triple> writeTriples(StreamRDF out, int size) {
        ArrayList<Triple> results = new ArrayList<Triple>();
        out.start();
        for (int i = 1; i <= size; ++i) {
            Triple t = new Triple(NodeFactory.createBlankNode(), NodeFactory.createURI((String)"http://predicate"), NodeFactoryExtra.intToNode((int)i));
            out.triple(t);
            results.add(t);
        }
        out.finish();
        return results;
    }

    @Test
    public void test_streamed_triples() {
        CollectorStreamTriples out = new CollectorStreamTriples();
        List<Triple> expected = this.writeTriples((StreamRDF)out, 10);
        Assert.assertEquals(expected, (Object)out.getCollected());
    }

    private List<Quad> writeQuads(StreamRDF out, int size) {
        ArrayList<Quad> results = new ArrayList<Quad>();
        out.start();
        for (int i = 1; i <= size; ++i) {
            Quad q = new Quad(NodeFactory.createURI((String)"http://graph"), NodeFactory.createBlankNode(), NodeFactory.createURI((String)"http://predicate"), NodeFactoryExtra.intToNode((int)i));
            out.quad(q);
            results.add(q);
        }
        out.finish();
        return results;
    }

    @Test
    public void test_streamed_quads() {
        CollectorStreamQuads out = new CollectorStreamQuads();
        List<Quad> expected = this.writeQuads((StreamRDF)out, 10);
        Assert.assertEquals(expected, (Object)out.getCollected());
    }
}

