/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.FactoryRDFStd;
import org.apache.jena.riot.system.stream.Locator;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestRDFParser {
    private static String DIR = "testing/RIOT/Parser/";
    private static String testdata = "@prefix : <http://example/ns#> . :x :x _:b .";
    private static String PREFIX = "PREFIX : <http://example/>\n ";
    private static Node s = SSE.parseNode((String)":s");
    private static Node p = SSE.parseNode((String)":p");

    @Test
    public void source_not_uri_01() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParserBuilder.create().lang(Lang.TTL).fromString(testdata).parse(graph);
        Assert.assertEquals((long)1L, (long)graph.size());
    }

    @Test
    public void source_not_uri_02() {
        Graph graph = GraphFactory.createGraphMem();
        ByteArrayInputStream input = new ByteArrayInputStream(testdata.getBytes(StandardCharsets.UTF_8));
        RDFParser.create().lang(Lang.TTL).source((InputStream)input).parse(graph);
        Assert.assertEquals((long)1L, (long)graph.size());
    }

    @Test
    public void source_uri_01() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source("file:" + DIR + "data.ttl").parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test(expected=RiotException.class)
    public void source_uri_02() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source("file:" + DIR + "data.unknown").parse(graph);
    }

    @Test
    public void source_uri_03() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source("file:" + DIR + "data.unknown").lang(Lang.TTL).parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test
    public void source_uri_04() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source(Paths.get(DIR + "data.ttl", new String[0])).parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test
    public void source_uri_05() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source("http://example/").source(DIR + "data.ttl").parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test
    public void source_shortcut_01() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.fromString((String)testdata).lang(Lang.TTL).parse(graph);
        Assert.assertEquals((long)1L, (long)graph.size());
    }

    @Test(expected=RiotNotFoundException.class)
    public void source_notfound_1() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source(Paths.get(DIR + "data.nosuchfile.ttl", new String[0])).parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test(expected=RiotNotFoundException.class)
    public void source_notfound_2() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source(DIR + "data.nosuchfile.ttl").parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test(expected=RiotException.class)
    public void source_uri_hint_lang() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source("file:data.rdf").lang(Lang.RDFXML).errorHandler(ErrorHandlerFactory.errorHandlerNoLogging).parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test
    public void source_string() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().fromString("<x> <p> <z> .").lang(Lang.NT).parse(graph);
        Assert.assertEquals((long)1L, (long)graph.size());
    }

    @Test(expected=RiotException.class)
    public void errorHandler() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source(DIR + "data.rdf").errorHandler(ErrorHandlerFactory.errorHandlerNoLogging).parse(graph);
    }

    @Test
    public void source_uri_force_lang() {
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().source("file:" + DIR + "data.rdf").forceLang(Lang.TTL).parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    @Test
    public void source_streamManager() {
        StreamManager sMgr = new StreamManager();
        sMgr.addLocator((Locator)new LocatorFile(DIR));
        Graph graph = GraphFactory.createGraphMem();
        RDFParser.create().streamManager(sMgr).source("file:data.rdf").forceLang(Lang.TTL).parse(graph);
        Assert.assertEquals((long)3L, (long)graph.size());
    }

    private RDFParserBuilder builder() {
        ByteArrayInputStream input = new ByteArrayInputStream(testdata.getBytes(StandardCharsets.UTF_8));
        return RDFParserBuilder.create().lang(Lang.TTL).source((InputStream)input);
    }

    @Test
    public void labels_01() {
        Graph graph = GraphFactory.createGraphMem();
        this.builder().labelToNode(LabelToNode.createUseLabelAsGiven()).parse(graph);
        Assert.assertEquals((long)1L, (long)graph.size());
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Graph)graph, (Lang)Lang.NT);
        String s = sw.toString();
        Assert.assertTrue((boolean)s.contains("_:Bb"));
    }

    @Test
    public void factory_01() {
        TestingFactoryRDF f = new TestingFactoryRDF();
        Graph graph = GraphFactory.createGraphMem();
        this.builder().factory((FactoryRDF)f).parse(graph);
        Assert.assertEquals((long)1L, (long)graph.size());
        Assert.assertNotEquals((long)0L, (long)f.counter);
    }

    @Test
    public void canonical_value_1() {
        this.testNormalization("0123", "0123", this.builder().canonicalValues(false));
    }

    @Test
    public void canonical_value_2() {
        this.testNormalization("+123", "123", this.builder().canonicalValues(true));
    }

    @Test
    public void canonical_value_3() {
        this.testNormalization("+123.00", "123.0", this.builder().canonicalValues(true));
    }

    @Test
    public void canonical_value_4() {
        this.testNormalization("+123.00e0", "1.23E2", this.builder().canonicalValues(true));
    }

    @Test
    public void canonical_langTag_1() {
        this.testNormalization("'abc'@En-gB", "'abc'@En-gB", this.builder().langTagAsGiven());
    }

    @Test
    public void canonical_langTag_2() {
        this.testNormalization("'abc'@En-gB", "'abc'@en-gb", this.builder().langTagLowerCase());
    }

    @Test
    public void canonical_langTag_3() {
        this.testNormalization("'abc'@En-gB", "'abc'@en-GB", this.builder().langTagCanonical());
    }

    private void testNormalization(String input, String output, RDFParserBuilder builder) {
        Graph graph = GraphFactory.createGraphMem();
        String x = PREFIX + ":s :p " + input;
        builder.source(new StringReader(x)).parse(graph);
        Assert.assertEquals((long)1L, (long)graph.size());
        Node objExpected = SSE.parseNode((String)output);
        Node objObtained = ((Triple)graph.find(s, p, null).next()).getObject();
        Assert.assertEquals((Object)objExpected, (Object)objObtained);
    }

    private static class TestingFactoryRDF
    extends FactoryRDFStd {
        int counter = 0;

        private TestingFactoryRDF() {
        }

        public Node createURI(String uriStr) {
            ++this.counter;
            return super.createURI(uriStr);
        }
    }
}

