/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Assert;
import org.junit.Test;

public class TestParseURISchemeBases {
    private static boolean DEBUG = Boolean.getBoolean("debug");
    private static Path DIR = Paths.get("testing/RIOT/URISchemes/", new String[0]);
    private static final String APP_BASE = "app://2dee5b0a-6100-470a-a67f-1399518cb470/";
    private static final String EXAMPLE_BASE = "example://2dee5b0a-6100-470a-a67f-1399518cb470/";
    private static final String FILE_BASE = "file:///";
    private static final String HTTP_BASE = "http://2dee5b0a-6100-470a-a67f-1399518cb470/";
    private static final String JENA_BASE = "org.apache.jena.test://foo/";
    private static final String SSH_BASE = "ssh://example.com/";
    private static final String X_MADEUP_BASE = "x-madeup://2dee5b0a-6100-470a-a67f-1399518cb470/";
    Model m = ModelFactory.createDefaultModel();
    ResourceFactory.Interface resourceFactory = ResourceFactory.getInstance();

    private void dump(String f) throws IOException {
        String filename = DIR.resolve(f).toString();
        String content = IO.readWholeFileAsUTF8((String)filename);
        System.out.println("File = " + f);
        System.out.println(content);
    }

    private InputStream load(String f) throws IOException {
        Path file = DIR.resolve(f);
        Assert.assertTrue((String)("Can't find " + file), (boolean)Files.isRegularFile(file, new LinkOption[0]));
        byte[] content = Files.readAllBytes(file);
        return new ByteArrayInputStream(content);
    }

    private Statement expectedStatement(String base) {
        Resource s = this.resourceFactory.createResource(base + "nested/foo.txt");
        Property p = RDFS.seeAlso;
        String baseSchemeHost = base.replaceAll("(.*://[^/]*)/", "$1");
        Resource o = this.resourceFactory.createResource(baseSchemeHost + "/bar.txt");
        return this.resourceFactory.createStatement(s, p, (RDFNode)o);
    }

    @Test
    public void appBaseRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("app-base.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(APP_BASE)));
    }

    @Test
    public void appBaseTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("app-base.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(APP_BASE)));
    }

    @Test
    public void appRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("app.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(APP_BASE)));
    }

    @Test
    public void appRelRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.rdf"), (String)"app://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(APP_BASE)));
    }

    @Test
    public void appRelTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.ttl"), (String)"app://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(APP_BASE)));
    }

    @Test
    public void appTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("app.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(APP_BASE)));
    }

    @Test
    public void exampleRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("example.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(EXAMPLE_BASE)));
    }

    @Test
    public void exampleRelRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.rdf"), (String)"example://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(EXAMPLE_BASE)));
    }

    @Test
    public void exampleRelTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.ttl"), (String)"example://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(EXAMPLE_BASE)));
    }

    @Test
    public void exampleTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("example.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(EXAMPLE_BASE)));
    }

    @Test
    public void fileRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("file.rdf"), (String)FILE_BASE, (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(FILE_BASE)));
    }

    @Test
    public void fileRelRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.rdf"), (String)"file:///nested/", (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(FILE_BASE)));
    }

    @Test
    public void fileRelTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.ttl"), (String)"file:///nested/", (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(FILE_BASE)));
    }

    @Test
    public void fileTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("file.ttl"), (String)FILE_BASE, (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(FILE_BASE)));
    }

    @Test
    public void fileBaseRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("file-base.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(FILE_BASE)));
    }

    @Test
    public void fileBaseTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("file-base.ttl"), (String)FILE_BASE, (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(FILE_BASE)));
    }

    @Test
    public void httpRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("http.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(HTTP_BASE)));
    }

    @Test
    public void httpBaseRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("http-base.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(HTTP_BASE)));
    }

    @Test
    public void httpBaseTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("http-base.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(HTTP_BASE)));
    }

    @Test
    public void httpRelRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.rdf"), (String)"http://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(HTTP_BASE)));
    }

    @Test
    public void httpRelTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.ttl"), (String)"http://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(HTTP_BASE)));
    }

    @Test
    public void httpTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("http.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(HTTP_BASE)));
    }

    @Test
    public void jenaRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("jena.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(JENA_BASE)));
    }

    @Test
    public void jenaRelRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.rdf"), (String)"org.apache.jena.test://foo/nested/", (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(JENA_BASE)));
    }

    @Test
    public void jenaRelTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.ttl"), (String)"org.apache.jena.test://foo/nested/", (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(JENA_BASE)));
    }

    @Test
    public void jenaTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("jena.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(JENA_BASE)));
    }

    @Test
    public void sshBaseRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("ssh-base.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(SSH_BASE)));
    }

    @Test
    public void sshBaseTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("ssh-base.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(SSH_BASE)));
    }

    @Test
    public void sshRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("ssh.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(SSH_BASE)));
    }

    @Test
    public void sshRelRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.rdf"), (String)"ssh://example.com/nested/", (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(SSH_BASE)));
    }

    @Test
    public void sshRelTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.ttl"), (String)"ssh://example.com/nested/", (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(SSH_BASE)));
    }

    @Test
    public void sshTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("ssh.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(SSH_BASE)));
    }

    @Test
    public void xMadeupRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("x-madeup.rdf"), (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(X_MADEUP_BASE)));
    }

    @Test
    public void xMadeupRelRDF() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.rdf"), (String)"x-madeup://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.RDFXML);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(X_MADEUP_BASE)));
    }

    @Test
    public void xMadeupRelTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("rel.ttl"), (String)"x-madeup://2dee5b0a-6100-470a-a67f-1399518cb470/nested/", (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(X_MADEUP_BASE)));
    }

    @Test
    public void xMadeupTTL() throws Exception {
        RDFDataMgr.read((Model)this.m, (InputStream)this.load("x-madeup.ttl"), (Lang)Lang.TURTLE);
        Assert.assertTrue((String)"Can't find statement", (boolean)this.m.contains(this.expectedStatement(X_MADEUP_BASE)));
    }
}

