/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf_star;

import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.junit.Test;

public class TestTrigStarParse {
    private ErrorHandler silent = ErrorHandlerFactory.errorHandlerStrictNoLogging;
    private static StreamRDF sink = StreamRDFLib.sinkNull();

    @Test
    public void parse_trig_good_1() {
        this.parse("<<:s :p :o>> :q 1 . ");
    }

    @Test
    public void parse_trig_good_2() {
        this.parse(":x :p <<:s :p :o>> . ");
    }

    @Test
    public void parse_trig_good_3() {
        this.parse(":x :p [ :q <<:s :p :o>> ]. ");
    }

    @Test
    public void parse_trig_good_4() {
        this.parse("( <<:s :p :o>> ) :p :z . ");
    }

    @Test
    public void parse_trig_good_10() {
        this.parse("<<:s :p <<:x :r :z >>>> :q 1 . ");
    }

    @Test
    public void parse_trig_good_20() {
        this.parse(":a :p <<:s :p <<:x :r :z >>>> . ");
    }

    @Test(expected=RiotException.class)
    public void parse_trig_bad_1() {
        this.parse("<<:s :p :o>> . ");
    }

    @Test(expected=RiotException.class)
    public void parse_trig_bad_2() {
        this.parse("GRAPH <<:s :p :o>> {} ");
    }

    @Test(expected=RiotException.class)
    public void parse_trig_bad_3() {
        this.parse("<<:s :p :o>> { :s :p :o } ");
    }

    private void parse(String string) {
        string = "PREFIX : <http://example/>\n" + (String)string;
        RDFParser.fromString((String)string).lang(Lang.TRIG).errorHandler(this.silent).parse(sink);
    }
}

