/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf_star;

import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.junit.Test;

public class TestNTriplesStarParse {
    private ErrorHandler silent = ErrorHandlerFactory.errorHandlerStrictNoLogging;
    private static StreamRDF sink = StreamRDFLib.sinkNull();

    @Test
    public void parse_nt_good_1() {
        this.parse("<<<x:s> <x:p> <x:o>>> <x:q> '1' . ");
    }

    @Test
    public void parse_nt_good_2() {
        this.parse("<http://ex/x> <http://ex/p> <<<x:s> <x:p> <x:o>>> .");
    }

    @Test
    public void parse_nt_good_3() {
        this.parse("_:b <x:p> <<_:b <x:p> _:o>>. ");
    }

    @Test
    public void parse_nt_good_4() {
        this.parse("<< << <x:s> <x:p> <x:o> >> <x:q> '1' >> <x:q> '2' .");
    }

    @Test(expected=RiotException.class)
    public void parse_nt_bad_1() {
        this.parse("<<<x:s> <x:p> <x:o>>> . ");
    }

    @Test(expected=RiotException.class)
    public void parse_nt_bad_2() {
        this.parse("<<<x:s> 'str' <x:o>>> <x:p> <x:o>. ");
    }

    private void parse(String string) {
        RDFParser.fromString((String)string).lang(Lang.NTRIPLES).errorHandler(this.silent).parse(sink);
    }
}

