/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.arq.junit.manifest.ExTestSetup;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class LibTestSetup {
    public static Resource getResource(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Resource) {
            return (Resource)n;
        }
        throw new ExTestSetup("Manifest problem (not a Resource): " + n + " => " + p);
    }

    public static Collection<Resource> listResources(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        ArrayList<Resource> x = new ArrayList<Resource>();
        StmtIterator sIter = r.listProperties(p);
        while (sIter.hasNext()) {
            RDFNode n = ((Statement)sIter.next()).getObject();
            if (!(n instanceof Resource)) {
                throw new ExTestSetup("Manifest problem (not a Resource): " + n + " => " + p);
            }
            x.add((Resource)n);
        }
        return x;
    }

    public static String getLiteral(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        throw new ExTestSetup("Manifest problem (not a Literal): " + n + " => " + p);
    }

    public static String getLiteralOrURI(Resource r, Property p) {
        Resource r2;
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        if (n instanceof Resource && !(r2 = (Resource)n).isAnon()) {
            return r2.getURI();
        }
        throw new ExTestSetup("Manifest problem: " + n + " => " + p);
    }

    public static String safeName(String s) {
        s = s.replace('(', '[');
        s = s.replace(')', ']');
        return s;
    }
}

