/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.modify.UpdateEngine;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public abstract class UpdateEngineBase
implements UpdateEngine {
    protected final DatasetGraph datasetGraph;
    protected final Binding inputBinding;
    protected final Context context;

    public UpdateEngineBase(DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        this.datasetGraph = datasetGraph;
        this.inputBinding = inputBinding;
        this.context = UpdateEngineBase.setupContext(context2, datasetGraph);
    }

    private static Context setupContext(Context context2, DatasetGraph dataset) {
        if (context2 == null) {
            context2 = ARQ.getContext();
        }
        context2 = context2.copy();
        if (dataset.getContext() != null) {
            context2.putAll(dataset.getContext());
        }
        context2.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        return context2;
    }
}

