/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.sequential;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.loader.BulkLoaderException;
import org.apache.jena.tdb2.loader.base.LoaderBase;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.base.ProgressMonitor;
import org.apache.jena.tdb2.loader.base.ProgressMonitorOutput;
import org.apache.jena.tdb2.loader.sequential.LoaderNodeTupleTable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.sys.TDBInternal;

public class LoaderSequential
extends LoaderBase {
    public static final int DataTickPoint = 100000;
    public static final int DataSuperTick = 10;
    public static final int IndexTickPoint = 1000000;
    public static final int IndexSuperTick = 10;
    private final LoaderNodeTupleTable triplesLoader;
    private final LoaderNodeTupleTable quadsLoader;
    private final DatasetGraphTDB dsgtdb;
    private long countQuads;
    private long countTriples;
    private StreamRDF stream;

    public LoaderSequential(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        super(dsg, graphName, output);
        if (!TDBInternal.isBackedByTDB(dsg)) {
            throw new BulkLoaderException("Not a TDB2 database");
        }
        this.dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        this.triplesLoader = new LoaderNodeTupleTable(this.dsgtdb.getTripleTable().getNodeTupleTable(), output, "Triples");
        this.quadsLoader = new LoaderNodeTupleTable(this.dsgtdb.getQuadTable().getNodeTupleTable(), output, "Quads");
        Object s = StreamRDFLib.dataset((DatasetGraph)dsg);
        s = new StreamRDFWrapper((StreamRDF)s){

            public void triple(Triple triple) {
                LoaderSequential.this.triplesLoader.load(triple.getSubject(), triple.getPredicate(), triple.getObject());
                ++LoaderSequential.this.countTriples;
            }

            public void quad(Quad quad) {
                LoaderSequential.this.quadsLoader.load(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
                ++LoaderSequential.this.countQuads;
            }
        };
        this.stream = LoaderOps.toNamedGraph(s, graphName);
    }

    @Override
    public void startBulk() {
        super.startBulk();
        this.triplesLoader.loadDataStart();
        this.quadsLoader.loadDataStart();
    }

    @Override
    public void finishBulk() {
        this.triplesLoader.loadDataFinish();
        this.quadsLoader.loadDataFinish();
        super.finishBulk();
    }

    @Override
    public void finishException(Exception ex) {
        super.finishException(ex);
    }

    @Override
    public StreamRDF stream() {
        return this.stream;
    }

    @Override
    protected ProgressMonitor createProgressMonitor(MonitorOutput output) {
        return ProgressMonitorOutput.create(output, "<unset>", 100000L, 10);
    }

    @Override
    public boolean bulkUseTransaction() {
        return true;
    }

    @Override
    public long countTriples() {
        return this.countTriples;
    }

    @Override
    public long countQuads() {
        return this.countQuads;
    }
}

