/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ModDataset;
import java.util.List;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.LabelExistsException;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.DatasetUtils;
import org.apache.jena.system.Txn;

public class ModDatasetGeneral
extends ModDataset {
    protected final ArgDecl graphDecl = new ArgDecl(true, "graph");
    protected final ArgDecl dataDecl = new ArgDecl(true, "data");
    protected final ArgDecl namedGraphDecl = new ArgDecl(true, "named", "namedgraph", "namedGraph", "namedData", "nameddata");
    private List<String> dataURLs = null;
    private List<String> graphURLs = null;
    private List<String> namedGraphURLs = null;

    protected ModDatasetGeneral() {
    }

    @Override
    public void registerWith(CmdGeneral cl) {
        cl.getUsage().startCategory("Dataset");
        cl.add(this.dataDecl, "--data=FILE", "Data for the dataset - triple or quad formats");
        cl.add(this.graphDecl, "--graph=FILE", "Graph for default graph of the datset");
        cl.add(this.namedGraphDecl, "--namedGraph=FILE", "Add a graph into the dataset as a named graph");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.dataURLs = cmdLine.getValues(this.dataDecl);
        this.graphURLs = cmdLine.getValues(this.graphDecl);
        this.namedGraphURLs = cmdLine.getValues(this.namedGraphDecl);
    }

    @Override
    public Dataset createDataset() {
        if (!(this.dataURLs != null && this.dataURLs.size() != 0 || this.graphURLs != null && this.graphURLs.size() != 0 || this.namedGraphURLs != null && this.namedGraphURLs.size() != 0)) {
            return null;
        }
        Dataset ds = DatasetFactory.createTxnMem();
        this.addGraphs(ds);
        this.dataset = ds;
        return this.dataset;
    }

    static <X> boolean hasEntries(List<X> list) {
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    protected void addGraphs(Dataset ds) {
        try {
            if (ModDatasetGeneral.hasEntries(this.dataURLs)) {
                if (ds.supportsTransactions()) {
                    Txn.executeWrite((Transactional)ds, () -> {
                        for (String url : this.dataURLs) {
                            RDFDataMgr.read((Dataset)ds, (String)url);
                        }
                    });
                } else {
                    for (String url : this.dataURLs) {
                        RDFDataMgr.read((Dataset)ds, (String)url);
                    }
                }
            }
            if (ModDatasetGeneral.hasEntries(this.graphURLs) || ModDatasetGeneral.hasEntries(this.namedGraphURLs)) {
                List x = ListUtils.toList(this.namedGraphURLs.stream().map(IRILib::filenameToIRI));
                DatasetUtils.addInGraphs((Dataset)ds, this.graphURLs, (List)x, null);
            }
        }
        catch (LabelExistsException ex) {
            throw new CmdException(ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating dataset", ex);
        }
    }

    public List<String> getGraphURLs() {
        return this.graphURLs;
    }

    public List<String> getNamedGraphURLs() {
        return this.namedGraphURLs;
    }
}

