/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.vocabulary;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

public class SchemaDO {

/**
 *  Schema.org is a collaborative, community activity with a mission to create, maintain, and promote schemas for structured data on the Internet, on web pages, in email messages, and beyond.
 *  <p>
 *	See <a href="https://schema.org/">Schema.org</a>.
 *  <p>
 *  <a href="https://schema.org/">Base URI and namepace</a>.
 */
    private static final Model m = ModelFactory.createDefaultModel();
    public static final String NS = "https://schema.org/";

    public static final Resource Atlas = m.createResource(NS+"Atlas");
    public static final Resource BrokerageAccount = m.createResource(NS+"BrokerageAccount");
    public static final Resource Product = m.createResource(NS+"Product");
    public static final Resource EmploymentAgency = m.createResource(NS+"EmploymentAgency");
    public static final Resource TelevisionChannel = m.createResource(NS+"TelevisionChannel");
    public static final Resource Volcano = m.createResource(NS+"Volcano");
    public static final Resource Locksmith = m.createResource(NS+"Locksmith");
    public static final Resource ComicIssue = m.createResource(NS+"ComicIssue");
    public static final Resource CourseInstance = m.createResource(NS+"CourseInstance");
    public static final Resource HighSchool = m.createResource(NS+"HighSchool");
    public static final Resource PaymentMethod = m.createResource(NS+"PaymentMethod");
    public static final Resource WPSideBar = m.createResource(NS+"WPSideBar");
    public static final Resource GroceryStore = m.createResource(NS+"GroceryStore");
    public static final Resource Bakery = m.createResource(NS+"Bakery");
    public static final Resource BookSeries = m.createResource(NS+"BookSeries");
    public static final Resource ResumeAction = m.createResource(NS+"ResumeAction");
    public static final Resource AutoDealer = m.createResource(NS+"AutoDealer");
    public static final Resource TVClip = m.createResource(NS+"TVClip");
    public static final Resource Airport = m.createResource(NS+"Airport");
    public static final Resource Florist = m.createResource(NS+"Florist");
    public static final Resource FilmAction = m.createResource(NS+"FilmAction");
    public static final Resource InvestmentOrDeposit = m.createResource(NS+"InvestmentOrDeposit");
    public static final Resource LocalBusiness = m.createResource(NS+"LocalBusiness");
    public static final Resource HealthPlanNetwork = m.createResource(NS+"HealthPlanNetwork");
    public static final Resource MovieSeries = m.createResource(NS+"MovieSeries");
    public static final Resource Enumeration = m.createResource(NS+"Enumeration");
    public static final Resource MedicalOrganization = m.createResource(NS+"MedicalOrganization");
    public static final Resource BodyMeasurementTypeEnumeration = m.createResource(NS+"BodyMeasurementTypeEnumeration");
    public static final Resource PlanAction = m.createResource(NS+"PlanAction");
    public static final Resource DiagnosticProcedure = m.createResource(NS+"DiagnosticProcedure");
    public static final Resource UnRegisterAction = m.createResource(NS+"UnRegisterAction");
    public static final Resource ReadAction = m.createResource(NS+"ReadAction");
    public static final Resource EnergyStarEnergyEfficiencyEnumeration = m.createResource(NS+"EnergyStarEnergyEfficiencyEnumeration");
    public static final Resource Church = m.createResource(NS+"Church");
    public static final Resource AdvertiserContentArticle = m.createResource(NS+"AdvertiserContentArticle");
    public static final Resource VisualArtwork = m.createResource(NS+"VisualArtwork");
    public static final Resource NightClub = m.createResource(NS+"NightClub");
    public static final Resource Continent = m.createResource(NS+"Continent");
    public static final Resource MedicalEnumeration = m.createResource(NS+"MedicalEnumeration");
    public static final Resource PodcastSeries = m.createResource(NS+"PodcastSeries");
    public static final Resource PhysicalActivity = m.createResource(NS+"PhysicalActivity");
    public static final Resource LikeAction = m.createResource(NS+"LikeAction");
    public static final Resource ShareAction = m.createResource(NS+"ShareAction");
    public static final Resource TravelAgency = m.createResource(NS+"TravelAgency");
    public static final Resource EducationalOccupationalCredential = m.createResource(NS+"EducationalOccupationalCredential");
    public static final Resource MediaObject = m.createResource(NS+"MediaObject");
    public static final Resource HobbyShop = m.createResource(NS+"HobbyShop");
    public static final Resource FAQPage = m.createResource(NS+"FAQPage");
    public static final Resource MusicStore = m.createResource(NS+"MusicStore");
    public static final Resource ClaimReview = m.createResource(NS+"ClaimReview");
    public static final Resource EndorsementRating = m.createResource(NS+"EndorsementRating");
    public static final Resource ReturnAction = m.createResource(NS+"ReturnAction");
    public static final Resource Reservation = m.createResource(NS+"Reservation");
    public static final Resource ShippingRateSettings = m.createResource(NS+"ShippingRateSettings");
    public static final Resource HowToTool = m.createResource(NS+"HowToTool");
    public static final Resource BusReservation = m.createResource(NS+"BusReservation");
    public static final Resource ImageObject = m.createResource(NS+"ImageObject");
    public static final Resource TipAction = m.createResource(NS+"TipAction");
    public static final Resource MonetaryAmount = m.createResource(NS+"MonetaryAmount");
    public static final Resource Resort = m.createResource(NS+"Resort");
    public static final Resource RadioBroadcastService = m.createResource(NS+"RadioBroadcastService");
    public static final Resource UserInteraction = m.createResource(NS+"UserInteraction");
    public static final Resource NewsArticle = m.createResource(NS+"NewsArticle");
    public static final Resource ScreeningEvent = m.createResource(NS+"ScreeningEvent");
    public static final Resource MedicalCondition = m.createResource(NS+"MedicalCondition");
    public static final Resource MediaGallery = m.createResource(NS+"MediaGallery");
    public static final Resource CatholicChurch = m.createResource(NS+"CatholicChurch");
    public static final Resource CreativeWorkSeries = m.createResource(NS+"CreativeWorkSeries");
    public static final Resource PostalCodeRangeSpecification = m.createResource(NS+"PostalCodeRangeSpecification");
    public static final Resource Hackathon = m.createResource(NS+"Hackathon");
    public static final Resource RecyclingCenter = m.createResource(NS+"RecyclingCenter");
    public static final Resource Claim = m.createResource(NS+"Claim");
    public static final Resource Crematorium = m.createResource(NS+"Crematorium");
    public static final Resource Mountain = m.createResource(NS+"Mountain");
    public static final Resource USNonprofitType = m.createResource(NS+"USNonprofitType");
    public static final Resource OfferCatalog = m.createResource(NS+"OfferCatalog");
    public static final Resource TransferAction = m.createResource(NS+"TransferAction");
    public static final Resource VoteAction = m.createResource(NS+"VoteAction");
    public static final Resource ComicCoverArt = m.createResource(NS+"ComicCoverArt");
    public static final Resource MedicalCause = m.createResource(NS+"MedicalCause");
    public static final Resource ProductGroup = m.createResource(NS+"ProductGroup");
    public static final Resource FurnitureStore = m.createResource(NS+"FurnitureStore");
    public static final Resource MusicAlbumReleaseType = m.createResource(NS+"MusicAlbumReleaseType");
    public static final Resource Integer = m.createResource(NS+"Integer");
    public static final Resource BoatTrip = m.createResource(NS+"BoatTrip");
    public static final Resource ExchangeRateSpecification = m.createResource(NS+"ExchangeRateSpecification");
    public static final Resource Optician = m.createResource(NS+"Optician");
    public static final Resource ReturnFeesEnumeration = m.createResource(NS+"ReturnFeesEnumeration");
    public static final Resource Canal = m.createResource(NS+"Canal");
    public static final Resource DayOfWeek = m.createResource(NS+"DayOfWeek");
    public static final Resource EnergyEfficiencyEnumeration = m.createResource(NS+"EnergyEfficiencyEnumeration");
    public static final Resource Statement = m.createResource(NS+"Statement");
    public static final Resource Store = m.createResource(NS+"Store");
    public static final Resource ParcelDelivery = m.createResource(NS+"ParcelDelivery");
    public static final Resource Intangible = m.createResource(NS+"Intangible");
    public static final Resource Apartment = m.createResource(NS+"Apartment");
    public static final Resource EmployerReview = m.createResource(NS+"EmployerReview");
    public static final Resource Energy = m.createResource(NS+"Energy");
    public static final Resource Language = m.createResource(NS+"Language");
    public static final Resource RadioClip = m.createResource(NS+"RadioClip");
    public static final Resource Invoice = m.createResource(NS+"Invoice");
    public static final Resource ReportedDoseSchedule = m.createResource(NS+"ReportedDoseSchedule");
    public static final Resource EmployerAggregateRating = m.createResource(NS+"EmployerAggregateRating");
    public static final Resource GovernmentBenefitsType = m.createResource(NS+"GovernmentBenefitsType");
    public static final Resource Quiz = m.createResource(NS+"Quiz");
    public static final Resource RegisterAction = m.createResource(NS+"RegisterAction");
    public static final Resource BreadcrumbList = m.createResource(NS+"BreadcrumbList");
    public static final Resource SiteNavigationElement = m.createResource(NS+"SiteNavigationElement");
    public static final Resource CompoundPriceSpecification = m.createResource(NS+"CompoundPriceSpecification");
    public static final Resource BloodTest = m.createResource(NS+"BloodTest");
    public static final Resource HealthClub = m.createResource(NS+"HealthClub");
    public static final Resource MonetaryGrant = m.createResource(NS+"MonetaryGrant");
    public static final Resource MedicalSpecialty = m.createResource(NS+"MedicalSpecialty");
    public static final Resource Rating = m.createResource(NS+"Rating");
    public static final Resource SportsClub = m.createResource(NS+"SportsClub");
    public static final Resource Text = m.createResource(NS+"Text");
    public static final Resource HealthPlanCostSharingSpecification = m.createResource(NS+"HealthPlanCostSharingSpecification");
    public static final Resource HealthInsurancePlan = m.createResource(NS+"HealthInsurancePlan");
    public static final Resource MotorcycleDealer = m.createResource(NS+"MotorcycleDealer");
    public static final Resource ProductModel = m.createResource(NS+"ProductModel");
    public static final Resource Brand = m.createResource(NS+"Brand");
    public static final Resource OrderStatus = m.createResource(NS+"OrderStatus");
    public static final Resource WebContent = m.createResource(NS+"WebContent");
    public static final Resource Trip = m.createResource(NS+"Trip");
    public static final Resource HomeAndConstructionBusiness = m.createResource(NS+"HomeAndConstructionBusiness");
    public static final Resource DigitalDocumentPermissionType = m.createResource(NS+"DigitalDocumentPermissionType");
    public static final Resource AutomotiveBusiness = m.createResource(NS+"AutomotiveBusiness");
    public static final Resource DepositAccount = m.createResource(NS+"DepositAccount");
    public static final Resource CityHall = m.createResource(NS+"CityHall");
    public static final Resource UseAction = m.createResource(NS+"UseAction");
    public static final Resource Ticket = m.createResource(NS+"Ticket");
    public static final Resource ClothingStore = m.createResource(NS+"ClothingStore");
    public static final Resource RsvpAction = m.createResource(NS+"RsvpAction");
    public static final Resource Residence = m.createResource(NS+"Residence");
    public static final Resource PublicationEvent = m.createResource(NS+"PublicationEvent");
    public static final Resource SportsOrganization = m.createResource(NS+"SportsOrganization");
    public static final Resource ProfilePage = m.createResource(NS+"ProfilePage");
    public static final Resource AuthorizeAction = m.createResource(NS+"AuthorizeAction");
    public static final Resource ToyStore = m.createResource(NS+"ToyStore");
    public static final Resource TVSeason = m.createResource(NS+"TVSeason");
    public static final Resource WearableMeasurementTypeEnumeration = m.createResource(NS+"WearableMeasurementTypeEnumeration");
    public static final Resource MusicReleaseFormatType = m.createResource(NS+"MusicReleaseFormatType");
    public static final Resource Consortium = m.createResource(NS+"Consortium");
    public static final Resource Researcher = m.createResource(NS+"Researcher");
    public static final Resource MedicalSymptom = m.createResource(NS+"MedicalSymptom");
    public static final Resource EntryPoint = m.createResource(NS+"EntryPoint");
    public static final Resource StatisticalPopulation = m.createResource(NS+"StatisticalPopulation");
    public static final Resource PublicToilet = m.createResource(NS+"PublicToilet");
    public static final Resource TelevisionStation = m.createResource(NS+"TelevisionStation");
    public static final Resource BoatReservation = m.createResource(NS+"BoatReservation");
    public static final Resource MedicalTrialDesign = m.createResource(NS+"MedicalTrialDesign");
    public static final Resource CarUsageType = m.createResource(NS+"CarUsageType");
    public static final Resource DrugClass = m.createResource(NS+"DrugClass");
    public static final Resource FireStation = m.createResource(NS+"FireStation");
    public static final Resource MedicalRiskCalculator = m.createResource(NS+"MedicalRiskCalculator");
    public static final Resource MedicalClinic = m.createResource(NS+"MedicalClinic");
    public static final Resource EmailMessage = m.createResource(NS+"EmailMessage");
    public static final Resource AskPublicNewsArticle = m.createResource(NS+"AskPublicNewsArticle");
    public static final Resource SingleFamilyResidence = m.createResource(NS+"SingleFamilyResidence");
    public static final Resource MedicalObservationalStudyDesign = m.createResource(NS+"MedicalObservationalStudyDesign");
    public static final Resource RecommendedDoseSchedule = m.createResource(NS+"RecommendedDoseSchedule");
    public static final Resource InteractAction = m.createResource(NS+"InteractAction");
    public static final Resource ArtGallery = m.createResource(NS+"ArtGallery");
    public static final Resource MoveAction = m.createResource(NS+"MoveAction");
    public static final Resource MobileApplication = m.createResource(NS+"MobileApplication");
    public static final Resource MerchantReturnEnumeration = m.createResource(NS+"MerchantReturnEnumeration");
    public static final Resource CreativeWorkSeason = m.createResource(NS+"CreativeWorkSeason");
    public static final Resource Airline = m.createResource(NS+"Airline");
    public static final Resource EntertainmentBusiness = m.createResource(NS+"EntertainmentBusiness");
    public static final Resource VideoGameSeries = m.createResource(NS+"VideoGameSeries");
    public static final Resource WarrantyScope = m.createResource(NS+"WarrantyScope");
    public static final Resource AudioObject = m.createResource(NS+"AudioObject");
    public static final Resource BroadcastEvent = m.createResource(NS+"BroadcastEvent");
    public static final Resource SchoolDistrict = m.createResource(NS+"SchoolDistrict");
    public static final Resource DrugPregnancyCategory = m.createResource(NS+"DrugPregnancyCategory");
    public static final Resource ScholarlyArticle = m.createResource(NS+"ScholarlyArticle");
    public static final Resource DDxElement = m.createResource(NS+"DDxElement");
    public static final Resource PaymentStatusType = m.createResource(NS+"PaymentStatusType");
    public static final Resource PostalAddress = m.createResource(NS+"PostalAddress");
    public static final Resource ActivateAction = m.createResource(NS+"ActivateAction");
    public static final Resource Action = m.createResource(NS+"Action");
    public static final Resource FindAction = m.createResource(NS+"FindAction");
    public static final Resource ParentAudience = m.createResource(NS+"ParentAudience");
    public static final Resource EventVenue = m.createResource(NS+"EventVenue");
    public static final Resource MusicAlbumProductionType = m.createResource(NS+"MusicAlbumProductionType");
    public static final Resource NonprofitType = m.createResource(NS+"NonprofitType");
    public static final Resource JobPosting = m.createResource(NS+"JobPosting");
    public static final Resource ComicSeries = m.createResource(NS+"ComicSeries");
    public static final Resource QualitativeValue = m.createResource(NS+"QualitativeValue");
    public static final Resource AutomatedTeller = m.createResource(NS+"AutomatedTeller");
    public static final Resource UserPageVisits = m.createResource(NS+"UserPageVisits");
    public static final Resource DrugStrength = m.createResource(NS+"DrugStrength");
    public static final Resource LinkRole = m.createResource(NS+"LinkRole");
    public static final Resource WebSite = m.createResource(NS+"WebSite");
    public static final Resource Book = m.createResource(NS+"Book");
    public static final Resource LendAction = m.createResource(NS+"LendAction");
    public static final Resource NLNonprofitType = m.createResource(NS+"NLNonprofitType");
    public static final Resource Flight = m.createResource(NS+"Flight");
    public static final Resource ElementarySchool = m.createResource(NS+"ElementarySchool");
    public static final Resource FoodEvent = m.createResource(NS+"FoodEvent");
    public static final Resource Audience = m.createResource(NS+"Audience");
    public static final Resource Patient = m.createResource(NS+"Patient");
    public static final Resource ListenAction = m.createResource(NS+"ListenAction");
    public static final Resource DiscussionForumPosting = m.createResource(NS+"DiscussionForumPosting");
    public static final Resource MotorizedBicycle = m.createResource(NS+"MotorizedBicycle");
    public static final Resource RadioChannel = m.createResource(NS+"RadioChannel");
    public static final Resource FoodEstablishmentReservation = m.createResource(NS+"FoodEstablishmentReservation");
    public static final Resource FoodService = m.createResource(NS+"FoodService");
    public static final Resource Park = m.createResource(NS+"Park");
    public static final Resource TheaterGroup = m.createResource(NS+"TheaterGroup");
    public static final Resource SpecialAnnouncement = m.createResource(NS+"SpecialAnnouncement");
    public static final Resource CableOrSatelliteService = m.createResource(NS+"CableOrSatelliteService");
    public static final Resource DoseSchedule = m.createResource(NS+"DoseSchedule");
    public static final Resource AllocateAction = m.createResource(NS+"AllocateAction");
    public static final Resource AssessAction = m.createResource(NS+"AssessAction");
    public static final Resource StadiumOrArena = m.createResource(NS+"StadiumOrArena");
    public static final Resource CancelAction = m.createResource(NS+"CancelAction");
    public static final Resource PhysicalTherapy = m.createResource(NS+"PhysicalTherapy");
    public static final Resource AssignAction = m.createResource(NS+"AssignAction");
    public static final Resource WholesaleStore = m.createResource(NS+"WholesaleStore");
    public static final Resource FMRadioChannel = m.createResource(NS+"FMRadioChannel");
    public static final Resource AdministrativeArea = m.createResource(NS+"AdministrativeArea");
    public static final Resource State = m.createResource(NS+"State");
    public static final Resource Car = m.createResource(NS+"Car");
    public static final Resource CreativeWork = m.createResource(NS+"CreativeWork");
    public static final Resource RestrictedDiet = m.createResource(NS+"RestrictedDiet");
    public static final Resource BedAndBreakfast = m.createResource(NS+"BedAndBreakfast");
    public static final Resource NutritionInformation = m.createResource(NS+"NutritionInformation");
    public static final Resource MedicalAudienceType = m.createResource(NS+"MedicalAudienceType");
    public static final Resource PerformingArtsTheater = m.createResource(NS+"PerformingArtsTheater");
    public static final Resource CategoryCodeSet = m.createResource(NS+"CategoryCodeSet");
    public static final Resource HowTo = m.createResource(NS+"HowTo");
    public static final Resource VideoGameClip = m.createResource(NS+"VideoGameClip");
    public static final Resource DonateAction = m.createResource(NS+"DonateAction");
    public static final Resource LodgingReservation = m.createResource(NS+"LodgingReservation");
    public static final Resource ChildCare = m.createResource(NS+"ChildCare");
    public static final Resource VisualArtsEvent = m.createResource(NS+"VisualArtsEvent");
    public static final Resource AutoWash = m.createResource(NS+"AutoWash");
    public static final Resource PresentationDigitalDocument = m.createResource(NS+"PresentationDigitalDocument");
    public static final Resource Table = m.createResource(NS+"Table");
    public static final Resource SurgicalProcedure = m.createResource(NS+"SurgicalProcedure");
    public static final Resource EventStatusType = m.createResource(NS+"EventStatusType");
    public static final Resource AskAction = m.createResource(NS+"AskAction");
    public static final Resource Painting = m.createResource(NS+"Painting");
    public static final Resource MedicalConditionStage = m.createResource(NS+"MedicalConditionStage");
    public static final Resource ImageGallery = m.createResource(NS+"ImageGallery");
    public static final Resource CheckoutPage = m.createResource(NS+"CheckoutPage");
    public static final Resource AggregateRating = m.createResource(NS+"AggregateRating");
    public static final Resource TrainTrip = m.createResource(NS+"TrainTrip");
    public static final Resource LegalValueLevel = m.createResource(NS+"LegalValueLevel");
    public static final Resource Clip = m.createResource(NS+"Clip");
    public static final Resource VideoGallery = m.createResource(NS+"VideoGallery");
    public static final Resource Periodical = m.createResource(NS+"Periodical");
    public static final Resource ScheduleAction = m.createResource(NS+"ScheduleAction");
    public static final Resource DatedMoneySpecification = m.createResource(NS+"DatedMoneySpecification");
    public static final Resource CategoryCode = m.createResource(NS+"CategoryCode");
    public static final Resource PriceTypeEnumeration = m.createResource(NS+"PriceTypeEnumeration");
    public static final Resource TVEpisode = m.createResource(NS+"TVEpisode");
    public static final Resource MeasurementTypeEnumeration = m.createResource(NS+"MeasurementTypeEnumeration");
    public static final Resource ArchiveComponent = m.createResource(NS+"ArchiveComponent");
    public static final Resource TravelAction = m.createResource(NS+"TravelAction");
    public static final Resource DataFeedItem = m.createResource(NS+"DataFeedItem");
    public static final Resource DriveWheelConfigurationValue = m.createResource(NS+"DriveWheelConfigurationValue");
    public static final Resource ReceiveAction = m.createResource(NS+"ReceiveAction");
    public static final Resource Accommodation = m.createResource(NS+"Accommodation");
    public static final Resource ContactPage = m.createResource(NS+"ContactPage");
    public static final Resource AboutPage = m.createResource(NS+"AboutPage");
    public static final Resource Physician = m.createResource(NS+"Physician");
    public static final Resource Pond = m.createResource(NS+"Pond");
    public static final Resource AudioObjectSnapshot = m.createResource(NS+"AudioObjectSnapshot");
    public static final Resource MedicalWebPage = m.createResource(NS+"MedicalWebPage");
    public static final Resource WebPageElement = m.createResource(NS+"WebPageElement");
    public static final Resource MedicalSign = m.createResource(NS+"MedicalSign");
    public static final Resource Reservoir = m.createResource(NS+"Reservoir");
    public static final Resource Person = m.createResource(NS+"Person");
    public static final Resource Festival = m.createResource(NS+"Festival");
    public static final Resource CampingPitch = m.createResource(NS+"CampingPitch");
    public static final Resource DiagnosticLab = m.createResource(NS+"DiagnosticLab");
    public static final Resource Museum = m.createResource(NS+"Museum");
    public static final Resource UserCheckins = m.createResource(NS+"UserCheckins");
    public static final Resource TaxiStand = m.createResource(NS+"TaxiStand");
    public static final Resource GenderType = m.createResource(NS+"GenderType");
    public static final Resource AmpStory = m.createResource(NS+"AmpStory");
    public static final Resource RentalCarReservation = m.createResource(NS+"RentalCarReservation");
    public static final Resource FinancialProduct = m.createResource(NS+"FinancialProduct");
    public static final Resource GatedResidenceCommunity = m.createResource(NS+"GatedResidenceCommunity");
    public static final Resource HowToStep = m.createResource(NS+"HowToStep");
    public static final Resource Poster = m.createResource(NS+"Poster");
    public static final Resource LifestyleModification = m.createResource(NS+"LifestyleModification");
    public static final Resource Article = m.createResource(NS+"Article");
    public static final Resource CreateAction = m.createResource(NS+"CreateAction");
    public static final Resource DateTime = m.createResource(NS+"DateTime");
    public static final Resource DepartAction = m.createResource(NS+"DepartAction");
    public static final Resource LegalForceStatus = m.createResource(NS+"LegalForceStatus");
    public static final Resource NewsMediaOrganization = m.createResource(NS+"NewsMediaOrganization");
    public static final Resource PreOrderAction = m.createResource(NS+"PreOrderAction");
    public static final Resource Duration = m.createResource(NS+"Duration");
    public static final Resource GameServerStatus = m.createResource(NS+"GameServerStatus");
    public static final Resource DryCleaningOrLaundry = m.createResource(NS+"DryCleaningOrLaundry");
    public static final Resource Season = m.createResource(NS+"Season");
    public static final Resource CriticReview = m.createResource(NS+"CriticReview");
    public static final Resource Number = m.createResource(NS+"Number");
    public static final Resource AgreeAction = m.createResource(NS+"AgreeAction");
    public static final Resource Dentist = m.createResource(NS+"Dentist");
    public static final Resource Permit = m.createResource(NS+"Permit");
    public static final Resource Plumber = m.createResource(NS+"Plumber");
    public static final Resource BoatTerminal = m.createResource(NS+"BoatTerminal");
    public static final Resource MusicVideoObject = m.createResource(NS+"MusicVideoObject");
    public static final Resource Zoo = m.createResource(NS+"Zoo");
    public static final Resource IceCreamShop = m.createResource(NS+"IceCreamShop");
    public static final Resource StructuredValue = m.createResource(NS+"StructuredValue");
    public static final Resource PlaceOfWorship = m.createResource(NS+"PlaceOfWorship");
    public static final Resource StatusEnumeration = m.createResource(NS+"StatusEnumeration");
    public static final Resource Menu = m.createResource(NS+"Menu");
    public static final Resource ComedyClub = m.createResource(NS+"ComedyClub");
    public static final Resource Recipe = m.createResource(NS+"Recipe");
    public static final Resource Beach = m.createResource(NS+"Beach");
    public static final Resource CafeOrCoffeeShop = m.createResource(NS+"CafeOrCoffeeShop");
    public static final Resource SatiricalArticle = m.createResource(NS+"SatiricalArticle");
    public static final Resource FlightReservation = m.createResource(NS+"FlightReservation");
    public static final Resource UnitPriceSpecification = m.createResource(NS+"UnitPriceSpecification");
    public static final Resource FundingAgency = m.createResource(NS+"FundingAgency");
    public static final Resource IndividualProduct = m.createResource(NS+"IndividualProduct");
    public static final Resource TherapeuticProcedure = m.createResource(NS+"TherapeuticProcedure");
    public static final Resource CheckAction = m.createResource(NS+"CheckAction");
    public static final Resource Role = m.createResource(NS+"Role");
    public static final Resource BusinessFunction = m.createResource(NS+"BusinessFunction");
    public static final Resource GameServer = m.createResource(NS+"GameServer");
    public static final Resource OfferShippingDetails = m.createResource(NS+"OfferShippingDetails");
    public static final Resource Motel = m.createResource(NS+"Motel");
    public static final Resource WPHeader = m.createResource(NS+"WPHeader");
    public static final Resource InteractionCounter = m.createResource(NS+"InteractionCounter");
    public static final Resource SpreadsheetDigitalDocument = m.createResource(NS+"SpreadsheetDigitalDocument");
    public static final Resource ServiceChannel = m.createResource(NS+"ServiceChannel");
    public static final Resource ExhibitionEvent = m.createResource(NS+"ExhibitionEvent");
    public static final Resource ArchiveOrganization = m.createResource(NS+"ArchiveOrganization");
    public static final Resource Gene = m.createResource(NS+"Gene");
    public static final Resource DefinedRegion = m.createResource(NS+"DefinedRegion");
    public static final Resource MedicalGuidelineRecommendation = m.createResource(NS+"MedicalGuidelineRecommendation");
    public static final Resource Service = m.createResource(NS+"Service");
    public static final Resource MobilePhoneStore = m.createResource(NS+"MobilePhoneStore");
    public static final Resource TouristTrip = m.createResource(NS+"TouristTrip");
    public static final Resource FastFoodRestaurant = m.createResource(NS+"FastFoodRestaurant");
    public static final Resource ItemListOrderType = m.createResource(NS+"ItemListOrderType");
    public static final Resource TieAction = m.createResource(NS+"TieAction");
    public static final Resource WantAction = m.createResource(NS+"WantAction");
    public static final Resource OwnershipInfo = m.createResource(NS+"OwnershipInfo");
    public static final Resource DownloadAction = m.createResource(NS+"DownloadAction");
    public static final Resource BookStore = m.createResource(NS+"BookStore");
    public static final Resource ExerciseAction = m.createResource(NS+"ExerciseAction");
    public static final Resource Thesis = m.createResource(NS+"Thesis");
    public static final Resource TreatmentIndication = m.createResource(NS+"TreatmentIndication");
    public static final Resource Code = m.createResource(NS+"Code");
    public static final Resource EUEnergyEfficiencyEnumeration = m.createResource(NS+"EUEnergyEfficiencyEnumeration");
    public static final Resource TouristAttraction = m.createResource(NS+"TouristAttraction");
    public static final Resource HousePainter = m.createResource(NS+"HousePainter");
    public static final Resource Courthouse = m.createResource(NS+"Courthouse");
    public static final Resource PropertyValueSpecification = m.createResource(NS+"PropertyValueSpecification");
    public static final Resource DanceEvent = m.createResource(NS+"DanceEvent");
    public static final Resource LoanOrCredit = m.createResource(NS+"LoanOrCredit");
    public static final Resource OfferForLease = m.createResource(NS+"OfferForLease");
    public static final Resource PayAction = m.createResource(NS+"PayAction");
    public static final Resource Vein = m.createResource(NS+"Vein");
    public static final Resource UpdateAction = m.createResource(NS+"UpdateAction");
    public static final Resource MortgageLoan = m.createResource(NS+"MortgageLoan");
    public static final Resource TypeAndQuantityNode = m.createResource(NS+"TypeAndQuantityNode");
    public static final Resource IgnoreAction = m.createResource(NS+"IgnoreAction");
    public static final Resource OpeningHoursSpecification = m.createResource(NS+"OpeningHoursSpecification");
    public static final Resource EducationalAudience = m.createResource(NS+"EducationalAudience");
    public static final Resource SportsActivityLocation = m.createResource(NS+"SportsActivityLocation");
    public static final Resource Bridge = m.createResource(NS+"Bridge");
    public static final Resource DeliveryMethod = m.createResource(NS+"DeliveryMethod");
    public static final Resource MedicalTrial = m.createResource(NS+"MedicalTrial");
    public static final Resource PaymentCard = m.createResource(NS+"PaymentCard");
    public static final Resource Mass = m.createResource(NS+"Mass");
    public static final Resource OrganizationRole = m.createResource(NS+"OrganizationRole");
    public static final Resource ImagingTest = m.createResource(NS+"ImagingTest");
    public static final Resource PetStore = m.createResource(NS+"PetStore");
    public static final Resource AutoRepair = m.createResource(NS+"AutoRepair");
    public static final Resource ChildrensEvent = m.createResource(NS+"ChildrensEvent");
    public static final Resource MarryAction = m.createResource(NS+"MarryAction");
    public static final Resource UserPlays = m.createResource(NS+"UserPlays");
    public static final Resource Grant = m.createResource(NS+"Grant");
    public static final Resource ResearchProject = m.createResource(NS+"ResearchProject");
    public static final Resource School = m.createResource(NS+"School");
    public static final Resource MotorcycleRepair = m.createResource(NS+"MotorcycleRepair");
    public static final Resource TakeAction = m.createResource(NS+"TakeAction");
    public static final Resource Comment = m.createResource(NS+"Comment");
    public static final Resource ImageObjectSnapshot = m.createResource(NS+"ImageObjectSnapshot");
    public static final Resource Time = m.createResource(NS+"Time");
    public static final Resource AutoPartsStore = m.createResource(NS+"AutoPartsStore");
    public static final Resource DeliveryTimeSettings = m.createResource(NS+"DeliveryTimeSettings");
    public static final Resource EngineSpecification = m.createResource(NS+"EngineSpecification");
    public static final Resource TennisComplex = m.createResource(NS+"TennisComplex");
    public static final Resource ReviewNewsArticle = m.createResource(NS+"ReviewNewsArticle");
    public static final Resource RentAction = m.createResource(NS+"RentAction");
    public static final Resource FloorPlan = m.createResource(NS+"FloorPlan");
    public static final Resource MedicalGuideline = m.createResource(NS+"MedicalGuideline");
    public static final Resource BikeStore = m.createResource(NS+"BikeStore");
    public static final Resource MusicRecording = m.createResource(NS+"MusicRecording");
    public static final Resource ReturnLabelSourceEnumeration = m.createResource(NS+"ReturnLabelSourceEnumeration");
    public static final Resource TireShop = m.createResource(NS+"TireShop");
    public static final Resource Newspaper = m.createResource(NS+"Newspaper");
    public static final Resource PublicationVolume = m.createResource(NS+"PublicationVolume");
    public static final Resource AccountingService = m.createResource(NS+"AccountingService");
    public static final Resource EventSeries = m.createResource(NS+"EventSeries");
    public static final Resource Audiobook = m.createResource(NS+"Audiobook");
    public static final Resource PostOffice = m.createResource(NS+"PostOffice");
    public static final Resource URL = m.createResource(NS+"URL");
    public static final Resource TrainReservation = m.createResource(NS+"TrainReservation");
    public static final Resource HairSalon = m.createResource(NS+"HairSalon");
    public static final Resource BuddhistTemple = m.createResource(NS+"BuddhistTemple");
    public static final Resource RefundTypeEnumeration = m.createResource(NS+"RefundTypeEnumeration");
    public static final Resource VirtualLocation = m.createResource(NS+"VirtualLocation");
    public static final Resource VideoGame = m.createResource(NS+"VideoGame");
    public static final Resource MedicalScholarlyArticle = m.createResource(NS+"MedicalScholarlyArticle");
    public static final Resource ShippingDeliveryTime = m.createResource(NS+"ShippingDeliveryTime");
    public static final Resource ItemList = m.createResource(NS+"ItemList");
    public static final Resource GeoShape = m.createResource(NS+"GeoShape");
    public static final Resource BusOrCoach = m.createResource(NS+"BusOrCoach");
    public static final Resource UserComments = m.createResource(NS+"UserComments");
    public static final Resource Legislation = m.createResource(NS+"Legislation");
    public static final Resource ApprovedIndication = m.createResource(NS+"ApprovedIndication");
    public static final Resource ComputerStore = m.createResource(NS+"ComputerStore");
    public static final Resource MoneyTransfer = m.createResource(NS+"MoneyTransfer");
    public static final Resource RiverBodyOfWater = m.createResource(NS+"RiverBodyOfWater");
    public static final Resource AMRadioChannel = m.createResource(NS+"AMRadioChannel");
    public static final Resource PhysicalActivityCategory = m.createResource(NS+"PhysicalActivityCategory");
    public static final Resource ChemicalSubstance = m.createResource(NS+"ChemicalSubstance");
    public static final Resource MedicalIndication = m.createResource(NS+"MedicalIndication");
    public static final Resource HinduTemple = m.createResource(NS+"HinduTemple");
    public static final Resource DaySpa = m.createResource(NS+"DaySpa");
    public static final Resource DrugCostCategory = m.createResource(NS+"DrugCostCategory");
    public static final Resource ItemPage = m.createResource(NS+"ItemPage");
    public static final Resource GeospatialGeometry = m.createResource(NS+"GeospatialGeometry");
    public static final Resource PerformanceRole = m.createResource(NS+"PerformanceRole");
    public static final Resource QuantitativeValue = m.createResource(NS+"QuantitativeValue");
    public static final Resource ElectronicsStore = m.createResource(NS+"ElectronicsStore");
    public static final Resource DepartmentStore = m.createResource(NS+"DepartmentStore");
    public static final Resource OfferForPurchase = m.createResource(NS+"OfferForPurchase");
    public static final Resource WorkBasedProgram = m.createResource(NS+"WorkBasedProgram");
    public static final Resource CommunicateAction = m.createResource(NS+"CommunicateAction");
    public static final Resource ShoppingCenter = m.createResource(NS+"ShoppingCenter");
    public static final Resource CoverArt = m.createResource(NS+"CoverArt");
    public static final Resource BroadcastFrequencySpecification = m.createResource(NS+"BroadcastFrequencySpecification");
    public static final Resource Restaurant = m.createResource(NS+"Restaurant");
    public static final Resource GolfCourse = m.createResource(NS+"GolfCourse");
    public static final Resource WinAction = m.createResource(NS+"WinAction");
    public static final Resource Answer = m.createResource(NS+"Answer");
    public static final Resource LearningResource = m.createResource(NS+"LearningResource");
    public static final Resource SocialMediaPosting = m.createResource(NS+"SocialMediaPosting");
    public static final Resource Motorcycle = m.createResource(NS+"Motorcycle");
    public static final Resource PaintAction = m.createResource(NS+"PaintAction");
    public static final Resource BusinessEvent = m.createResource(NS+"BusinessEvent");
    public static final Resource MedicalGuidelineContraindication = m.createResource(NS+"MedicalGuidelineContraindication");
    public static final Resource Thing = m.createResource(NS+"Thing");
    public static final Resource Occupation = m.createResource(NS+"Occupation");
    public static final Resource QAPage = m.createResource(NS+"QAPage");
    public static final Resource CheckOutAction = m.createResource(NS+"CheckOutAction");
    public static final Resource AnimalShelter = m.createResource(NS+"AnimalShelter");
    public static final Resource MedicalRiskScore = m.createResource(NS+"MedicalRiskScore");
    public static final Resource BackgroundNewsArticle = m.createResource(NS+"BackgroundNewsArticle");
    public static final Resource ContactPoint = m.createResource(NS+"ContactPoint");
    public static final Resource MerchantReturnPolicy = m.createResource(NS+"MerchantReturnPolicy");
    public static final Resource EndorseAction = m.createResource(NS+"EndorseAction");
    public static final Resource DefinedTerm = m.createResource(NS+"DefinedTerm");
    public static final Resource Course = m.createResource(NS+"Course");
    public static final Resource Float = m.createResource(NS+"Float");
    public static final Resource Hotel = m.createResource(NS+"Hotel");
    public static final Resource LakeBodyOfWater = m.createResource(NS+"LakeBodyOfWater");
    public static final Resource Drug = m.createResource(NS+"Drug");
    public static final Resource BorrowAction = m.createResource(NS+"BorrowAction");
    public static final Resource MaximumDoseSchedule = m.createResource(NS+"MaximumDoseSchedule");
    public static final Resource NGO = m.createResource(NS+"NGO");
    public static final Resource SteeringPositionValue = m.createResource(NS+"SteeringPositionValue");
    public static final Resource ExercisePlan = m.createResource(NS+"ExercisePlan");
    public static final Resource MediaReviewItem = m.createResource(NS+"MediaReviewItem");
    public static final Resource SearchResultsPage = m.createResource(NS+"SearchResultsPage");
    public static final Resource Specialty = m.createResource(NS+"Specialty");
    public static final Resource DisagreeAction = m.createResource(NS+"DisagreeAction");
    public static final Resource PublicationIssue = m.createResource(NS+"PublicationIssue");
    public static final Resource NailSalon = m.createResource(NS+"NailSalon");
    public static final Resource BioChemEntity = m.createResource(NS+"BioChemEntity");
    public static final Resource OpinionNewsArticle = m.createResource(NS+"OpinionNewsArticle");
    public static final Resource LodgingBusiness = m.createResource(NS+"LodgingBusiness");
    public static final Resource Taxi = m.createResource(NS+"Taxi");
    public static final Resource Blog = m.createResource(NS+"Blog");
    public static final Resource Review = m.createResource(NS+"Review");
    public static final Resource AlignmentObject = m.createResource(NS+"AlignmentObject");
    public static final Resource BroadcastChannel = m.createResource(NS+"BroadcastChannel");
    public static final Resource WebApplication = m.createResource(NS+"WebApplication");
    public static final Resource Boolean = m.createResource(NS+"Boolean");
    public static final Resource SearchAction = m.createResource(NS+"SearchAction");
    public static final Resource PrependAction = m.createResource(NS+"PrependAction");
    public static final Resource WPFooter = m.createResource(NS+"WPFooter");
    public static final Resource HealthPlanFormulary = m.createResource(NS+"HealthPlanFormulary");
    public static final Resource ParkingFacility = m.createResource(NS+"ParkingFacility");
    public static final Resource CovidTestingFacility = m.createResource(NS+"CovidTestingFacility");
    public static final Resource Property = m.createResource(NS+"Property");
    public static final Resource FollowAction = m.createResource(NS+"FollowAction");
    public static final Resource MedicalContraindication = m.createResource(NS+"MedicalContraindication");
    public static final Resource LymphaticVessel = m.createResource(NS+"LymphaticVessel");
    public static final Resource MapCategoryType = m.createResource(NS+"MapCategoryType");
    public static final Resource InsuranceAgency = m.createResource(NS+"InsuranceAgency");
    public static final Resource LegislationObject = m.createResource(NS+"LegislationObject");
    public static final Resource ShortStory = m.createResource(NS+"ShortStory");
    public static final Resource XPathType = m.createResource(NS+"XPathType");
    public static final Resource OceanBodyOfWater = m.createResource(NS+"OceanBodyOfWater");
    public static final Resource ViewAction = m.createResource(NS+"ViewAction");
    public static final Resource ItemAvailability = m.createResource(NS+"ItemAvailability");
    public static final Resource PreventionIndication = m.createResource(NS+"PreventionIndication");
    public static final Resource DrawAction = m.createResource(NS+"DrawAction");
    public static final Resource DrugCost = m.createResource(NS+"DrugCost");
    public static final Resource MusicRelease = m.createResource(NS+"MusicRelease");
    public static final Resource ReplyAction = m.createResource(NS+"ReplyAction");
    public static final Resource LoseAction = m.createResource(NS+"LoseAction");
    public static final Resource ReturnMethodEnumeration = m.createResource(NS+"ReturnMethodEnumeration");
    public static final Resource BroadcastService = m.createResource(NS+"BroadcastService");
    public static final Resource DataDownload = m.createResource(NS+"DataDownload");
    public static final Resource Substance = m.createResource(NS+"Substance");
    public static final Resource ApplyAction = m.createResource(NS+"ApplyAction");
    public static final Resource Joint = m.createResource(NS+"Joint");
    public static final Resource ReserveAction = m.createResource(NS+"ReserveAction");
    public static final Resource CDCPMDRecord = m.createResource(NS+"CDCPMDRecord");
    public static final Resource BedType = m.createResource(NS+"BedType");
    public static final Resource EmployeeRole = m.createResource(NS+"EmployeeRole");
    public static final Resource RsvpResponseType = m.createResource(NS+"RsvpResponseType");
    public static final Resource CheckInAction = m.createResource(NS+"CheckInAction");
    public static final Resource Ligament = m.createResource(NS+"Ligament");
    public static final Resource DataType = m.createResource(NS+"DataType");
    public static final Resource PublicSwimmingPool = m.createResource(NS+"PublicSwimmingPool");
    public static final Resource SellAction = m.createResource(NS+"SellAction");
    public static final Resource Preschool = m.createResource(NS+"Preschool");
    public static final Resource CollectionPage = m.createResource(NS+"CollectionPage");
    public static final Resource FundingScheme = m.createResource(NS+"FundingScheme");
    public static final Resource Synagogue = m.createResource(NS+"Synagogue");
    public static final Resource Series = m.createResource(NS+"Series");
    public static final Resource MusicVenue = m.createResource(NS+"MusicVenue");
    public static final Resource UserLikes = m.createResource(NS+"UserLikes");
    public static final Resource CollegeOrUniversity = m.createResource(NS+"CollegeOrUniversity");
    public static final Resource SizeGroupEnumeration = m.createResource(NS+"SizeGroupEnumeration");
    public static final Resource Drawing = m.createResource(NS+"Drawing");
    public static final Resource MedicalTestPanel = m.createResource(NS+"MedicalTestPanel");
    public static final Resource MedicalTherapy = m.createResource(NS+"MedicalTherapy");
    public static final Resource ContactPointOption = m.createResource(NS+"ContactPointOption");
    public static final Resource SheetMusic = m.createResource(NS+"SheetMusic");
    public static final Resource ChooseAction = m.createResource(NS+"ChooseAction");
    public static final Resource GovernmentService = m.createResource(NS+"GovernmentService");
    public static final Resource Chapter = m.createResource(NS+"Chapter");
    public static final Resource AggregateOffer = m.createResource(NS+"AggregateOffer");
    public static final Resource PerformAction = m.createResource(NS+"PerformAction");
    public static final Resource Observation = m.createResource(NS+"Observation");
    public static final Resource Manuscript = m.createResource(NS+"Manuscript");
    public static final Resource Embassy = m.createResource(NS+"Embassy");
    public static final Resource MenuItem = m.createResource(NS+"MenuItem");
    public static final Resource TVSeries = m.createResource(NS+"TVSeries");
    public static final Resource SeekToAction = m.createResource(NS+"SeekToAction");
    public static final Resource AutoRental = m.createResource(NS+"AutoRental");
    public static final Resource HyperToc = m.createResource(NS+"HyperToc");
    public static final Resource Sculpture = m.createResource(NS+"Sculpture");
    public static final Resource TouristInformationCenter = m.createResource(NS+"TouristInformationCenter");
    public static final Resource Event = m.createResource(NS+"Event");
    public static final Resource BookmarkAction = m.createResource(NS+"BookmarkAction");
    public static final Resource MusicEvent = m.createResource(NS+"MusicEvent");
    public static final Resource EnergyConsumptionDetails = m.createResource(NS+"EnergyConsumptionDetails");
    public static final Resource PathologyTest = m.createResource(NS+"PathologyTest");
    public static final Resource GovernmentBuilding = m.createResource(NS+"GovernmentBuilding");
    public static final Resource WarrantyPromise = m.createResource(NS+"WarrantyPromise");
    public static final Resource DefenceEstablishment = m.createResource(NS+"DefenceEstablishment");
    public static final Resource Barcode = m.createResource(NS+"Barcode");
    public static final Resource DeleteAction = m.createResource(NS+"DeleteAction");
    public static final Resource ControlAction = m.createResource(NS+"ControlAction");
    public static final Resource MusicAlbum = m.createResource(NS+"MusicAlbum");
    public static final Resource MedicalEvidenceLevel = m.createResource(NS+"MedicalEvidenceLevel");
    public static final Resource SportsTeam = m.createResource(NS+"SportsTeam");
    public static final Resource CompleteDataFeed = m.createResource(NS+"CompleteDataFeed");
    public static final Resource TouristDestination = m.createResource(NS+"TouristDestination");
    public static final Resource BusinessAudience = m.createResource(NS+"BusinessAudience");
    public static final Resource DataFeed = m.createResource(NS+"DataFeed");
    public static final Resource Bone = m.createResource(NS+"Bone");
    public static final Resource UserTweets = m.createResource(NS+"UserTweets");
    public static final Resource LiveBlogPosting = m.createResource(NS+"LiveBlogPosting");
    public static final Resource AcceptAction = m.createResource(NS+"AcceptAction");
    public static final Resource MedicalDevicePurpose = m.createResource(NS+"MedicalDevicePurpose");
    public static final Resource AmusementPark = m.createResource(NS+"AmusementPark");
    public static final Resource SeaBodyOfWater = m.createResource(NS+"SeaBodyOfWater");
    public static final Resource LocationFeatureSpecification = m.createResource(NS+"LocationFeatureSpecification");
    public static final Resource EducationEvent = m.createResource(NS+"EducationEvent");
    public static final Resource OccupationalExperienceRequirements = m.createResource(NS+"OccupationalExperienceRequirements");
    public static final Resource TrackAction = m.createResource(NS+"TrackAction");
    public static final Resource MusicComposition = m.createResource(NS+"MusicComposition");
    public static final Resource EventReservation = m.createResource(NS+"EventReservation");
    public static final Resource RadiationTherapy = m.createResource(NS+"RadiationTherapy");
    public static final Resource Date = m.createResource(NS+"Date");
    public static final Resource DigitalDocument = m.createResource(NS+"DigitalDocument");
    public static final Resource EmergencyService = m.createResource(NS+"EmergencyService");
    public static final Resource HowToDirection = m.createResource(NS+"HowToDirection");
    public static final Resource FoodEstablishment = m.createResource(NS+"FoodEstablishment");
    public static final Resource PalliativeProcedure = m.createResource(NS+"PalliativeProcedure");
    public static final Resource ProgramMembership = m.createResource(NS+"ProgramMembership");
    public static final Resource AutoBodyShop = m.createResource(NS+"AutoBodyShop");
    public static final Resource BefriendAction = m.createResource(NS+"BefriendAction");
    public static final Resource ConvenienceStore = m.createResource(NS+"ConvenienceStore");
    public static final Resource HyperTocEntry = m.createResource(NS+"HyperTocEntry");
    public static final Resource MovingCompany = m.createResource(NS+"MovingCompany");
    public static final Resource BarOrPub = m.createResource(NS+"BarOrPub");
    public static final Resource FinancialService = m.createResource(NS+"FinancialService");
    public static final Resource RealEstateListing = m.createResource(NS+"RealEstateListing");
    public static final Resource WebAPI = m.createResource(NS+"WebAPI");
    public static final Resource RVPark = m.createResource(NS+"RVPark");
    public static final Resource UserBlocks = m.createResource(NS+"UserBlocks");
    public static final Resource ReportageNewsArticle = m.createResource(NS+"ReportageNewsArticle");
    public static final Resource ReviewAction = m.createResource(NS+"ReviewAction");
    public static final Resource InternetCafe = m.createResource(NS+"InternetCafe");
    public static final Resource OutletStore = m.createResource(NS+"OutletStore");
    public static final Resource VideoObjectSnapshot = m.createResource(NS+"VideoObjectSnapshot");
    public static final Resource DataCatalog = m.createResource(NS+"DataCatalog");
    public static final Resource ArriveAction = m.createResource(NS+"ArriveAction");
    public static final Resource PriceComponentTypeEnumeration = m.createResource(NS+"PriceComponentTypeEnumeration");
    public static final Resource UserDownloads = m.createResource(NS+"UserDownloads");
    public static final Resource RoofingContractor = m.createResource(NS+"RoofingContractor");
    public static final Resource Episode = m.createResource(NS+"Episode");
    public static final Resource OccupationalTherapy = m.createResource(NS+"OccupationalTherapy");
    public static final Resource InvestmentFund = m.createResource(NS+"InvestmentFund");
    public static final Resource Map = m.createResource(NS+"Map");
    public static final Resource MedicalStudy = m.createResource(NS+"MedicalStudy");
    public static final Resource PerformingGroup = m.createResource(NS+"PerformingGroup");
    public static final Resource MonetaryAmountDistribution = m.createResource(NS+"MonetaryAmountDistribution");
    public static final Resource LegislativeBuilding = m.createResource(NS+"LegislativeBuilding");
    public static final Resource Casino = m.createResource(NS+"Casino");
    public static final Resource Quotation = m.createResource(NS+"Quotation");
    public static final Resource GeoCoordinates = m.createResource(NS+"GeoCoordinates");
    public static final Resource Demand = m.createResource(NS+"Demand");
    public static final Resource GovernmentPermit = m.createResource(NS+"GovernmentPermit");
    public static final Resource PaymentService = m.createResource(NS+"PaymentService");
    public static final Resource InviteAction = m.createResource(NS+"InviteAction");
    public static final Resource Movie = m.createResource(NS+"Movie");
    public static final Resource BrainStructure = m.createResource(NS+"BrainStructure");
    public static final Resource Attorney = m.createResource(NS+"Attorney");
    public static final Resource PodcastSeason = m.createResource(NS+"PodcastSeason");
    public static final Resource InstallAction = m.createResource(NS+"InstallAction");
    public static final Resource MediaManipulationRatingEnumeration = m.createResource(NS+"MediaManipulationRatingEnumeration");
    public static final Resource EducationalOccupationalProgram = m.createResource(NS+"EducationalOccupationalProgram");
    public static final Resource ResearchOrganization = m.createResource(NS+"ResearchOrganization");
    public static final Resource BankAccount = m.createResource(NS+"BankAccount");
    public static final Resource GeneralContractor = m.createResource(NS+"GeneralContractor");
    public static final Resource Landform = m.createResource(NS+"Landform");
    public static final Resource SizeSystemEnumeration = m.createResource(NS+"SizeSystemEnumeration");
    public static final Resource HardwareStore = m.createResource(NS+"HardwareStore");
    public static final Resource TheaterEvent = m.createResource(NS+"TheaterEvent");
    public static final Resource MusicGroup = m.createResource(NS+"MusicGroup");
    public static final Resource BowlingAlley = m.createResource(NS+"BowlingAlley");
    public static final Resource WearableSizeSystemEnumeration = m.createResource(NS+"WearableSizeSystemEnumeration");
    public static final Resource Guide = m.createResource(NS+"Guide");
    public static final Resource PhysicalExam = m.createResource(NS+"PhysicalExam");
    public static final Resource Suite = m.createResource(NS+"Suite");
    public static final Resource CorrectionComment = m.createResource(NS+"CorrectionComment");
    public static final Resource MovieClip = m.createResource(NS+"MovieClip");
    public static final Resource Playground = m.createResource(NS+"Playground");
    public static final Resource UKNonprofitType = m.createResource(NS+"UKNonprofitType");
    public static final Resource Conversation = m.createResource(NS+"Conversation");
    public static final Resource WearAction = m.createResource(NS+"WearAction");
    public static final Resource Recommendation = m.createResource(NS+"Recommendation");
    public static final Resource Organization = m.createResource(NS+"Organization");
    public static final Resource OfferItemCondition = m.createResource(NS+"OfferItemCondition");
    public static final Resource Waterfall = m.createResource(NS+"Waterfall");
    public static final Resource MedicalProcedure = m.createResource(NS+"MedicalProcedure");
    public static final Resource PropertyValue = m.createResource(NS+"PropertyValue");
    public static final Resource Diet = m.createResource(NS+"Diet");
    public static final Resource CssSelectorType = m.createResource(NS+"CssSelectorType");
    public static final Resource Corporation = m.createResource(NS+"Corporation");
    public static final Resource GardenStore = m.createResource(NS+"GardenStore");
    public static final Resource SkiResort = m.createResource(NS+"SkiResort");
    public static final Resource MedicalSignOrSymptom = m.createResource(NS+"MedicalSignOrSymptom");
    public static final Resource MenuSection = m.createResource(NS+"MenuSection");
    public static final Resource GovernmentOrganization = m.createResource(NS+"GovernmentOrganization");
    public static final Resource MedicalDevice = m.createResource(NS+"MedicalDevice");
    public static final Resource Place = m.createResource(NS+"Place");
    public static final Resource DModel = m.createResource(NS+"DModel");
    public static final Resource LandmarksOrHistoricalBuildings = m.createResource(NS+"LandmarksOrHistoricalBuildings");
    public static final Resource MedicalEntity = m.createResource(NS+"MedicalEntity");
    public static final Resource Muscle = m.createResource(NS+"Muscle");
    public static final Resource HotelRoom = m.createResource(NS+"HotelRoom");
    public static final Resource BusStation = m.createResource(NS+"BusStation");
    public static final Resource SocialEvent = m.createResource(NS+"SocialEvent");
    public static final Resource PawnShop = m.createResource(NS+"PawnShop");
    public static final Resource MedicalStudyStatus = m.createResource(NS+"MedicalStudyStatus");
    public static final Resource ReactAction = m.createResource(NS+"ReactAction");
    public static final Resource HowToSupply = m.createResource(NS+"HowToSupply");
    public static final Resource PaymentChargeSpecification = m.createResource(NS+"PaymentChargeSpecification");
    public static final Resource Photograph = m.createResource(NS+"Photograph");
    public static final Resource AddAction = m.createResource(NS+"AddAction");
    public static final Resource Class = m.createResource(NS+"Class");
    public static final Resource InsertAction = m.createResource(NS+"InsertAction");
    public static final Resource UserReview = m.createResource(NS+"UserReview");
    public static final Resource Hostel = m.createResource(NS+"Hostel");
    public static final Resource DanceGroup = m.createResource(NS+"DanceGroup");
    public static final Resource Artery = m.createResource(NS+"Artery");
    public static final Resource MedicalObservationalStudy = m.createResource(NS+"MedicalObservationalStudy");
    public static final Resource PhotographAction = m.createResource(NS+"PhotographAction");
    public static final Resource ComicStory = m.createResource(NS+"ComicStory");
    public static final Resource AnalysisNewsArticle = m.createResource(NS+"AnalysisNewsArticle");
    public static final Resource Distillery = m.createResource(NS+"Distillery");
    public static final Resource OnDemandEvent = m.createResource(NS+"OnDemandEvent");
    public static final Resource NoteDigitalDocument = m.createResource(NS+"NoteDigitalDocument");
    public static final Resource AnatomicalSystem = m.createResource(NS+"AnatomicalSystem");
    public static final Resource Order = m.createResource(NS+"Order");
    public static final Resource PriceSpecification = m.createResource(NS+"PriceSpecification");
    public static final Resource EducationalOrganization = m.createResource(NS+"EducationalOrganization");
    public static final Resource Game = m.createResource(NS+"Game");
    public static final Resource GovernmentOffice = m.createResource(NS+"GovernmentOffice");
    public static final Resource ProfessionalService = m.createResource(NS+"ProfessionalService");
    public static final Resource Cemetery = m.createResource(NS+"Cemetery");
    public static final Resource MedicalProcedureType = m.createResource(NS+"MedicalProcedureType");
    public static final Resource Electrician = m.createResource(NS+"Electrician");
    public static final Resource PsychologicalTreatment = m.createResource(NS+"PsychologicalTreatment");
    public static final Resource BusinessEntityType = m.createResource(NS+"BusinessEntityType");
    public static final Resource MusicPlaylist = m.createResource(NS+"MusicPlaylist");
    public static final Resource SuspendAction = m.createResource(NS+"SuspendAction");
    public static final Resource InfectiousDisease = m.createResource(NS+"InfectiousDisease");
    public static final Resource SoftwareSourceCode = m.createResource(NS+"SoftwareSourceCode");
    public static final Resource MediaSubscription = m.createResource(NS+"MediaSubscription");
    public static final Resource RadioEpisode = m.createResource(NS+"RadioEpisode");
    public static final Resource SizeSpecification = m.createResource(NS+"SizeSpecification");
    public static final Resource DeliveryChargeSpecification = m.createResource(NS+"DeliveryChargeSpecification");
    public static final Resource DeactivateAction = m.createResource(NS+"DeactivateAction");
    public static final Resource LegalService = m.createResource(NS+"LegalService");
    public static final Resource BuyAction = m.createResource(NS+"BuyAction");
    public static final Resource ProductCollection = m.createResource(NS+"ProductCollection");
    public static final Resource EventAttendanceModeEnumeration = m.createResource(NS+"EventAttendanceModeEnumeration");
    public static final Resource MedicalAudience = m.createResource(NS+"MedicalAudience");
    public static final Resource BeautySalon = m.createResource(NS+"BeautySalon");
    public static final Resource Hospital = m.createResource(NS+"Hospital");
    public static final Resource PodcastEpisode = m.createResource(NS+"PodcastEpisode");
    public static final Resource BusStop = m.createResource(NS+"BusStop");
    public static final Resource ConfirmAction = m.createResource(NS+"ConfirmAction");
    public static final Resource SelfStorage = m.createResource(NS+"SelfStorage");
    public static final Resource MedicalTest = m.createResource(NS+"MedicalTest");
    public static final Resource BlogPosting = m.createResource(NS+"BlogPosting");
    public static final Resource BankOrCreditUnion = m.createResource(NS+"BankOrCreditUnion");
    public static final Resource MedicalIntangible = m.createResource(NS+"MedicalIntangible");
    public static final Resource GasStation = m.createResource(NS+"GasStation");
    public static final Resource LiquorStore = m.createResource(NS+"LiquorStore");
    public static final Resource CurrencyConversionService = m.createResource(NS+"CurrencyConversionService");
    public static final Resource TattooParlor = m.createResource(NS+"TattooParlor");
    public static final Resource LeaveAction = m.createResource(NS+"LeaveAction");
    public static final Resource TechArticle = m.createResource(NS+"TechArticle");
    public static final Resource TaxiService = m.createResource(NS+"TaxiService");
    public static final Resource HomeGoodsStore = m.createResource(NS+"HomeGoodsStore");
    public static final Resource Report = m.createResource(NS+"Report");
    public static final Resource MedicineSystem = m.createResource(NS+"MedicineSystem");
    public static final Resource MediaReview = m.createResource(NS+"MediaReview");
    public static final Resource MedicalRiskFactor = m.createResource(NS+"MedicalRiskFactor");
    public static final Resource ApartmentComplex = m.createResource(NS+"ApartmentComplex");
    public static final Resource AdultEntertainment = m.createResource(NS+"AdultEntertainment");
    public static final Resource SuperficialAnatomy = m.createResource(NS+"SuperficialAnatomy");
    public static final Resource Notary = m.createResource(NS+"Notary");
    public static final Resource ExerciseGym = m.createResource(NS+"ExerciseGym");
    public static final Resource Project = m.createResource(NS+"Project");
    public static final Resource SportsEvent = m.createResource(NS+"SportsEvent");
    public static final Resource RadioStation = m.createResource(NS+"RadioStation");
    public static final Resource ReplaceAction = m.createResource(NS+"ReplaceAction");
    public static final Resource DislikeAction = m.createResource(NS+"DislikeAction");
    public static final Resource MedicalBusiness = m.createResource(NS+"MedicalBusiness");
    public static final Resource HealthAndBeautyBusiness = m.createResource(NS+"HealthAndBeautyBusiness");
    public static final Resource GeoCircle = m.createResource(NS+"GeoCircle");
    public static final Resource SolveMathAction = m.createResource(NS+"SolveMathAction");
    public static final Resource JewelryStore = m.createResource(NS+"JewelryStore");
    public static final Resource BusTrip = m.createResource(NS+"BusTrip");
    public static final Resource TrainStation = m.createResource(NS+"TrainStation");
    public static final Resource BoardingPolicyType = m.createResource(NS+"BoardingPolicyType");
    public static final Resource Vehicle = m.createResource(NS+"Vehicle");
    public static final Resource SomeProducts = m.createResource(NS+"SomeProducts");
    public static final Resource Taxon = m.createResource(NS+"Taxon");
    public static final Resource VideoObject = m.createResource(NS+"VideoObject");
    public static final Resource AnatomicalStructure = m.createResource(NS+"AnatomicalStructure");
    public static final Resource ReservationStatusType = m.createResource(NS+"ReservationStatusType");
    public static final Resource RepaymentSpecification = m.createResource(NS+"RepaymentSpecification");
    public static final Resource APIReference = m.createResource(NS+"APIReference");
    public static final Resource InfectiousAgentClass = m.createResource(NS+"InfectiousAgentClass");
    public static final Resource HowToSection = m.createResource(NS+"HowToSection");
    public static final Resource Dataset = m.createResource(NS+"Dataset");
    public static final Resource WriteAction = m.createResource(NS+"WriteAction");
    public static final Resource RadioSeries = m.createResource(NS+"RadioSeries");
    public static final Resource WearableSizeGroupEnumeration = m.createResource(NS+"WearableSizeGroupEnumeration");
    public static final Resource LibrarySystem = m.createResource(NS+"LibrarySystem");
    public static final Resource HVACBusiness = m.createResource(NS+"HVACBusiness");
    public static final Resource Collection = m.createResource(NS+"Collection");
    public static final Resource Winery = m.createResource(NS+"Winery");
    public static final Resource QuantitativeValueDistribution = m.createResource(NS+"QuantitativeValueDistribution");
    public static final Resource JoinAction = m.createResource(NS+"JoinAction");
    public static final Resource SubwayStation = m.createResource(NS+"SubwayStation");
    public static final Resource PronounceableText = m.createResource(NS+"PronounceableText");
    public static final Resource Room = m.createResource(NS+"Room");
    public static final Resource GiveAction = m.createResource(NS+"GiveAction");
    public static final Resource VitalSign = m.createResource(NS+"VitalSign");
    public static final Resource MeetingRoom = m.createResource(NS+"MeetingRoom");
    public static final Resource ConsumeAction = m.createResource(NS+"ConsumeAction");
    public static final Resource WatchAction = m.createResource(NS+"WatchAction");
    public static final Resource HowToItem = m.createResource(NS+"HowToItem");
    public static final Resource SubscribeAction = m.createResource(NS+"SubscribeAction");
    public static final Resource OrderItem = m.createResource(NS+"OrderItem");
    public static final Resource HowToTip = m.createResource(NS+"HowToTip");
    public static final Resource RadioSeason = m.createResource(NS+"RadioSeason");
    public static final Resource Library = m.createResource(NS+"Library");
    public static final Resource Campground = m.createResource(NS+"Campground");
    public static final Resource Quantity = m.createResource(NS+"Quantity");
    public static final Resource WebPage = m.createResource(NS+"WebPage");
    public static final Resource Seat = m.createResource(NS+"Seat");
    public static final Resource AppendAction = m.createResource(NS+"AppendAction");
    public static final Resource DrinkAction = m.createResource(NS+"DrinkAction");
    public static final Resource HealthTopicContent = m.createResource(NS+"HealthTopicContent");
    public static final Resource SendAction = m.createResource(NS+"SendAction");
    public static final Resource PlayAction = m.createResource(NS+"PlayAction");
    public static final Resource DigitalDocumentPermission = m.createResource(NS+"DigitalDocumentPermission");
    public static final Resource Distance = m.createResource(NS+"Distance");
    public static final Resource DrugPrescriptionStatus = m.createResource(NS+"DrugPrescriptionStatus");
    public static final Resource UserPlusOnes = m.createResource(NS+"UserPlusOnes");
    public static final Resource PeopleAudience = m.createResource(NS+"PeopleAudience");
    public static final Resource OrganizeAction = m.createResource(NS+"OrganizeAction");
    public static final Resource Offer = m.createResource(NS+"Offer");
    public static final Resource ActionStatusType = m.createResource(NS+"ActionStatusType");
    public static final Resource WPAdBlock = m.createResource(NS+"WPAdBlock");
    public static final Resource MovieTheater = m.createResource(NS+"MovieTheater");
    public static final Resource BedDetails = m.createResource(NS+"BedDetails");
    public static final Resource MathSolver = m.createResource(NS+"MathSolver");
    public static final Resource DefinedTermSet = m.createResource(NS+"DefinedTermSet");
    public static final Resource OfficeEquipmentStore = m.createResource(NS+"OfficeEquipmentStore");
    public static final Resource LiteraryEvent = m.createResource(NS+"LiteraryEvent");
    public static final Resource MedicalRiskEstimator = m.createResource(NS+"MedicalRiskEstimator");
    public static final Resource Brewery = m.createResource(NS+"Brewery");
    public static final Resource Question = m.createResource(NS+"Question");
    public static final Resource GamePlayMode = m.createResource(NS+"GamePlayMode");
    public static final Resource Protein = m.createResource(NS+"Protein");
    public static final Resource SpeakableSpecification = m.createResource(NS+"SpeakableSpecification");
    public static final Resource MensClothingStore = m.createResource(NS+"MensClothingStore");
    public static final Resource Nerve = m.createResource(NS+"Nerve");
    public static final Resource CookAction = m.createResource(NS+"CookAction");
    public static final Resource ReservationPackage = m.createResource(NS+"ReservationPackage");
    public static final Resource DeliveryEvent = m.createResource(NS+"DeliveryEvent");
    public static final Resource MedicalImagingTechnique = m.createResource(NS+"MedicalImagingTechnique");
    public static final Resource HealthAspectEnumeration = m.createResource(NS+"HealthAspectEnumeration");
    public static final Resource City = m.createResource(NS+"City");
    public static final Resource Country = m.createResource(NS+"Country");
    public static final Resource Schedule = m.createResource(NS+"Schedule");
    public static final Resource DiscoverAction = m.createResource(NS+"DiscoverAction");
    public static final Resource TaxiReservation = m.createResource(NS+"TaxiReservation");
    public static final Resource CommentAction = m.createResource(NS+"CommentAction");
    public static final Resource ShoeStore = m.createResource(NS+"ShoeStore");
    public static final Resource House = m.createResource(NS+"House");
    public static final Resource ComputerLanguage = m.createResource(NS+"ComputerLanguage");
    public static final Resource RealEstateAgent = m.createResource(NS+"RealEstateAgent");
    public static final Resource Mosque = m.createResource(NS+"Mosque");
    public static final Resource CreditCard = m.createResource(NS+"CreditCard");
    public static final Resource OrderAction = m.createResource(NS+"OrderAction");
    public static final Resource SaleEvent = m.createResource(NS+"SaleEvent");
    public static final Resource TradeAction = m.createResource(NS+"TradeAction");
    public static final Resource BodyOfWater = m.createResource(NS+"BodyOfWater");
    public static final Resource InformAction = m.createResource(NS+"InformAction");
    public static final Resource DietarySupplement = m.createResource(NS+"DietarySupplement");
    public static final Resource CivicStructure = m.createResource(NS+"CivicStructure");
    public static final Resource MiddleSchool = m.createResource(NS+"MiddleSchool");
    public static final Resource EatAction = m.createResource(NS+"EatAction");
    public static final Resource MedicalCode = m.createResource(NS+"MedicalCode");
    public static final Resource MerchantReturnPolicySeasonalOverride = m.createResource(NS+"MerchantReturnPolicySeasonalOverride");
    public static final Resource VeterinaryCare = m.createResource(NS+"VeterinaryCare");
    public static final Resource MovieRentalStore = m.createResource(NS+"MovieRentalStore");
    public static final Resource Vessel = m.createResource(NS+"Vessel");
    public static final Resource PoliceStation = m.createResource(NS+"PoliceStation");
    public static final Resource BookFormatType = m.createResource(NS+"BookFormatType");
    public static final Resource AchieveAction = m.createResource(NS+"AchieveAction");
    public static final Resource SportingGoodsStore = m.createResource(NS+"SportingGoodsStore");
    public static final Resource MolecularEntity = m.createResource(NS+"MolecularEntity");
    public static final Resource WorkersUnion = m.createResource(NS+"WorkersUnion");
    public static final Resource Pharmacy = m.createResource(NS+"Pharmacy");
    public static final Resource Message = m.createResource(NS+"Message");
    public static final Resource SoftwareApplication = m.createResource(NS+"SoftwareApplication");
    public static final Resource ActionAccessSpecification = m.createResource(NS+"ActionAccessSpecification");
    public static final Resource QuoteAction = m.createResource(NS+"QuoteAction");
    public static final Resource DrugLegalStatus = m.createResource(NS+"DrugLegalStatus");
    public static final Resource ComedyEvent = m.createResource(NS+"ComedyEvent");
    public static final Resource Play = m.createResource(NS+"Play");
    public static final Resource RejectAction = m.createResource(NS+"RejectAction");
    public static final Resource ListItem = m.createResource(NS+"ListItem");
    public static final Resource TextDigitalDocument = m.createResource(NS+"TextDigitalDocument");
    public static final Resource Aquarium = m.createResource(NS+"Aquarium");
    public static final Property merchant = m.createProperty(NS+"merchant");
    public static final Property torque = m.createProperty(NS+"torque");
    public static final Property musicReleaseFormat = m.createProperty(NS+"musicReleaseFormat");
    public static final Property programType = m.createProperty(NS+"programType");
    public static final Property timeRequired = m.createProperty(NS+"timeRequired");
    public static final Property game = m.createProperty(NS+"game");
    public static final Property procedure = m.createProperty(NS+"procedure");
    public static final Property usesHealthPlanIdStandard = m.createProperty(NS+"usesHealthPlanIdStandard");
    public static final Property trailer = m.createProperty(NS+"trailer");
    public static final Property roleName = m.createProperty(NS+"roleName");
    public static final Property discussionUrl = m.createProperty(NS+"discussionUrl");
    public static final Property contributor = m.createProperty(NS+"contributor");
    public static final Property containsPlace = m.createProperty(NS+"containsPlace");
    public static final Property netWorth = m.createProperty(NS+"netWorth");
    public static final Property ethicsPolicy = m.createProperty(NS+"ethicsPolicy");
    public static final Property assesses = m.createProperty(NS+"assesses");
    public static final Property arrivalStation = m.createProperty(NS+"arrivalStation");
    public static final Property differentialDiagnosis = m.createProperty(NS+"differentialDiagnosis");
    public static final Property awayTeam = m.createProperty(NS+"awayTeam");
    public static final Property workPerformed = m.createProperty(NS+"workPerformed");
    public static final Property accommodationCategory = m.createProperty(NS+"accommodationCategory");
    public static final Property schoolClosuresInfo = m.createProperty(NS+"schoolClosuresInfo");
    public static final Property relatedTo = m.createProperty(NS+"relatedTo");
    public static final Property requiresSubscription = m.createProperty(NS+"requiresSubscription");
    public static final Property video = m.createProperty(NS+"video");
    public static final Property broadcastTimezone = m.createProperty(NS+"broadcastTimezone");
    public static final Property addressCountry = m.createProperty(NS+"addressCountry");
    public static final Property suggestedMinAge = m.createProperty(NS+"suggestedMinAge");
    public static final Property hasDigitalDocumentPermission = m.createProperty(NS+"hasDigitalDocumentPermission");
    public static final Property hasEnergyConsumptionDetails = m.createProperty(NS+"hasEnergyConsumptionDetails");
    public static final Property scheduleTimezone = m.createProperty(NS+"scheduleTimezone");
    public static final Property honorificPrefix = m.createProperty(NS+"honorificPrefix");
    public static final Property photos = m.createProperty(NS+"photos");
    public static final Property unsaturatedFatContent = m.createProperty(NS+"unsaturatedFatContent");
    public static final Property articleBody = m.createProperty(NS+"articleBody");
    public static final Property requiredCollateral = m.createProperty(NS+"requiredCollateral");
    public static final Property paymentMethod = m.createProperty(NS+"paymentMethod");
    public static final Property tributary = m.createProperty(NS+"tributary");
    public static final Property validFrom = m.createProperty(NS+"validFrom");
    public static final Property itemListOrder = m.createProperty(NS+"itemListOrder");
    public static final Property characterName = m.createProperty(NS+"characterName");
    public static final Property subStageSuffix = m.createProperty(NS+"subStageSuffix");
    public static final Property sensoryUnit = m.createProperty(NS+"sensoryUnit");
    public static final Property vehicleSpecialUsage = m.createProperty(NS+"vehicleSpecialUsage");
    public static final Property taxID = m.createProperty(NS+"taxID");
    public static final Property eligibleQuantity = m.createProperty(NS+"eligibleQuantity");
    public static final Property travelBans = m.createProperty(NS+"travelBans");
    public static final Property accountMinimumInflow = m.createProperty(NS+"accountMinimumInflow");
    public static final Property departureBoatTerminal = m.createProperty(NS+"departureBoatTerminal");
    public static final Property artEdition = m.createProperty(NS+"artEdition");
    public static final Property antagonist = m.createProperty(NS+"antagonist");
    public static final Property language = m.createProperty(NS+"language");
    public static final Property duplicateTherapy = m.createProperty(NS+"duplicateTherapy");
    public static final Property positiveNotes = m.createProperty(NS+"positiveNotes");
    public static final Property inBroadcastLineup = m.createProperty(NS+"inBroadcastLineup");
    public static final Property passengerPriorityStatus = m.createProperty(NS+"passengerPriorityStatus");
    public static final Property saturatedFatContent = m.createProperty(NS+"saturatedFatContent");
    public static final Property department = m.createProperty(NS+"department");
    public static final Property competencyRequired = m.createProperty(NS+"competencyRequired");
    public static final Property targetProduct = m.createProperty(NS+"targetProduct");
    public static final Property publicTransportClosuresInfo = m.createProperty(NS+"publicTransportClosuresInfo");
    public static final Property audienceType = m.createProperty(NS+"audienceType");
    public static final Property replacee = m.createProperty(NS+"replacee");
    public static final Property affectedBy = m.createProperty(NS+"affectedBy");
    public static final Property album = m.createProperty(NS+"album");
    public static final Property workFeatured = m.createProperty(NS+"workFeatured");
    public static final Property floorSize = m.createProperty(NS+"floorSize");
    public static final Property billingStart = m.createProperty(NS+"billingStart");
    public static final Property coursePrerequisites = m.createProperty(NS+"coursePrerequisites");
    public static final Property discusses = m.createProperty(NS+"discusses");
    public static final Property reviewedBy = m.createProperty(NS+"reviewedBy");
    public static final Property employees = m.createProperty(NS+"employees");
    public static final Property reservationStatus = m.createProperty(NS+"reservationStatus");
    public static final Property geoEquals = m.createProperty(NS+"geoEquals");
    public static final Property maintainer = m.createProperty(NS+"maintainer");
    public static final Property aircraft = m.createProperty(NS+"aircraft");
    public static final Property step = m.createProperty(NS+"step");
    public static final Property diet = m.createProperty(NS+"diet");
    public static final Property hasMeasurement = m.createProperty(NS+"hasMeasurement");
    public static final Property percentile90 = m.createProperty(NS+"percentile90");
    public static final Property legislationType = m.createProperty(NS+"legislationType");
    public static final Property vehicleEngine = m.createProperty(NS+"vehicleEngine");
    public static final Property acceptedOffer = m.createProperty(NS+"acceptedOffer");
    public static final Property numberOfAxles = m.createProperty(NS+"numberOfAxles");
    public static final Property availableDeliveryMethod = m.createProperty(NS+"availableDeliveryMethod");
    public static final Property priceRange = m.createProperty(NS+"priceRange");
    public static final Property issuedBy = m.createProperty(NS+"issuedBy");
    public static final Property hasCredential = m.createProperty(NS+"hasCredential");
    public static final Property isAcceptingNewPatients = m.createProperty(NS+"isAcceptingNewPatients");
    public static final Property associatedDisease = m.createProperty(NS+"associatedDisease");
    public static final Property releaseNotes = m.createProperty(NS+"releaseNotes");
    public static final Property foundingDate = m.createProperty(NS+"foundingDate");
    public static final Property isConsumableFor = m.createProperty(NS+"isConsumableFor");
    public static final Property biomechnicalClass = m.createProperty(NS+"biomechnicalClass");
    public static final Property about = m.createProperty(NS+"about");
    public static final Property creativeWorkStatus = m.createProperty(NS+"creativeWorkStatus");
    public static final Property albums = m.createProperty(NS+"albums");
    public static final Property sponsor = m.createProperty(NS+"sponsor");
    public static final Property processorRequirements = m.createProperty(NS+"processorRequirements");
    public static final Property termsPerYear = m.createProperty(NS+"termsPerYear");
    public static final Property arrivalBusStop = m.createProperty(NS+"arrivalBusStop");
    public static final Property paymentDue = m.createProperty(NS+"paymentDue");
    public static final Property vehicleConfiguration = m.createProperty(NS+"vehicleConfiguration");
    public static final Property alternativeHeadline = m.createProperty(NS+"alternativeHeadline");
    public static final Property healthPlanNetworkTier = m.createProperty(NS+"healthPlanNetworkTier");
    public static final Property legislationPassedBy = m.createProperty(NS+"legislationPassedBy");
    public static final Property funder = m.createProperty(NS+"funder");
    public static final Property inAlbum = m.createProperty(NS+"inAlbum");
    public static final Property warrantyScope = m.createProperty(NS+"warrantyScope");
    public static final Property successorOf = m.createProperty(NS+"successorOf");
    public static final Property significance = m.createProperty(NS+"significance");
    public static final Property bloodSupply = m.createProperty(NS+"bloodSupply");
    public static final Property hasCategoryCode = m.createProperty(NS+"hasCategoryCode");
    public static final Property expectsAcceptanceOf = m.createProperty(NS+"expectsAcceptanceOf");
    public static final Property durationOfWarranty = m.createProperty(NS+"durationOfWarranty");
    public static final Property photo = m.createProperty(NS+"photo");
    public static final Property isAccessoryOrSparePartFor = m.createProperty(NS+"isAccessoryOrSparePartFor");
    public static final Property trackingUrl = m.createProperty(NS+"trackingUrl");
    public static final Property namedPosition = m.createProperty(NS+"namedPosition");
    public static final Property mentions = m.createProperty(NS+"mentions");
    public static final Property musicArrangement = m.createProperty(NS+"musicArrangement");
    public static final Property loanPaymentFrequency = m.createProperty(NS+"loanPaymentFrequency");
    public static final Property offeredBy = m.createProperty(NS+"offeredBy");
    public static final Property strengthValue = m.createProperty(NS+"strengthValue");
    public static final Property teaches = m.createProperty(NS+"teaches");
    public static final Property populationType = m.createProperty(NS+"populationType");
    public static final Property toRecipient = m.createProperty(NS+"toRecipient");
    public static final Property earlyPrepaymentPenalty = m.createProperty(NS+"earlyPrepaymentPenalty");
    public static final Property servesCuisine = m.createProperty(NS+"servesCuisine");
    public static final Property meetsEmissionStandard = m.createProperty(NS+"meetsEmissionStandard");
    public static final Property musicGroupMember = m.createProperty(NS+"musicGroupMember");
    public static final Property followee = m.createProperty(NS+"followee");
    public static final Property validThrough = m.createProperty(NS+"validThrough");
    public static final Property releaseDate = m.createProperty(NS+"releaseDate");
    public static final Property aggregateRating = m.createProperty(NS+"aggregateRating");
    public static final Property subStructure = m.createProperty(NS+"subStructure");
    public static final Property accessibilityHazard = m.createProperty(NS+"accessibilityHazard");
    public static final Property paymentAccepted = m.createProperty(NS+"paymentAccepted");
    public static final Property isPlanForApartment = m.createProperty(NS+"isPlanForApartment");
    public static final Property candidate = m.createProperty(NS+"candidate");
    public static final Property accessCode = m.createProperty(NS+"accessCode");
    public static final Property payload = m.createProperty(NS+"payload");
    public static final Property isBasedOn = m.createProperty(NS+"isBasedOn");
    public static final Property ownershipFundingInfo = m.createProperty(NS+"ownershipFundingInfo");
    public static final Property diagnosis = m.createProperty(NS+"diagnosis");
    public static final Property appearance = m.createProperty(NS+"appearance");
    public static final Property ccRecipient = m.createProperty(NS+"ccRecipient");
    public static final Property frequency = m.createProperty(NS+"frequency");
    public static final Property prepTime = m.createProperty(NS+"prepTime");
    public static final Property healthPlanCoinsuranceRate = m.createProperty(NS+"healthPlanCoinsuranceRate");
    public static final Property boardingPolicy = m.createProperty(NS+"boardingPolicy");
    public static final Property videoQuality = m.createProperty(NS+"videoQuality");
    public static final Property includedComposition = m.createProperty(NS+"includedComposition");
    public static final Property softwareHelp = m.createProperty(NS+"softwareHelp");
    public static final Property mainEntityOfPage = m.createProperty(NS+"mainEntityOfPage");
    public static final Property numberOfAirbags = m.createProperty(NS+"numberOfAirbags");
    public static final Property datePublished = m.createProperty(NS+"datePublished");
    public static final Property commentCount = m.createProperty(NS+"commentCount");
    public static final Property suitableForDiet = m.createProperty(NS+"suitableForDiet");
    public static final Property episodeNumber = m.createProperty(NS+"episodeNumber");
    public static final Property claimReviewed = m.createProperty(NS+"claimReviewed");
    public static final Property includesHealthPlanNetwork = m.createProperty(NS+"includesHealthPlanNetwork");
    public static final Property slogan = m.createProperty(NS+"slogan");
    public static final Property copyrightYear = m.createProperty(NS+"copyrightYear");
    public static final Property usesDevice = m.createProperty(NS+"usesDevice");
    public static final Property prescribingInfo = m.createProperty(NS+"prescribingInfo");
    public static final Property paymentUrl = m.createProperty(NS+"paymentUrl");
    public static final Property arrivalPlatform = m.createProperty(NS+"arrivalPlatform");
    public static final Property ratingCount = m.createProperty(NS+"ratingCount");
    public static final Property seatNumber = m.createProperty(NS+"seatNumber");
    public static final Property broadcastFrequency = m.createProperty(NS+"broadcastFrequency");
    public static final Property incentiveCompensation = m.createProperty(NS+"incentiveCompensation");
    public static final Property videoFrameSize = m.createProperty(NS+"videoFrameSize");
    public static final Property parentTaxon = m.createProperty(NS+"parentTaxon");
    public static final Property screenshot = m.createProperty(NS+"screenshot");
    public static final Property permissionType = m.createProperty(NS+"permissionType");
    public static final Property departureTime = m.createProperty(NS+"departureTime");
    public static final Property weight = m.createProperty(NS+"weight");
    public static final Property printEdition = m.createProperty(NS+"printEdition");
    public static final Property archivedAt = m.createProperty(NS+"archivedAt");
    public static final Property addressRegion = m.createProperty(NS+"addressRegion");
    public static final Property birthPlace = m.createProperty(NS+"birthPlace");
    public static final Property nextItem = m.createProperty(NS+"nextItem");
    public static final Property dateDeleted = m.createProperty(NS+"dateDeleted");
    public static final Property faxNumber = m.createProperty(NS+"faxNumber");
    public static final Property countryOfOrigin = m.createProperty(NS+"countryOfOrigin");
    public static final Property accessibilityFeature = m.createProperty(NS+"accessibilityFeature");
    public static final Property cvdNumBedsOcc = m.createProperty(NS+"cvdNumBedsOcc");
    public static final Property area = m.createProperty(NS+"area");
    public static final Property servicePhone = m.createProperty(NS+"servicePhone");
    public static final Property interactionStatistic = m.createProperty(NS+"interactionStatistic");
    public static final Property instructor = m.createProperty(NS+"instructor");
    public static final Property sportsActivityLocation = m.createProperty(NS+"sportsActivityLocation");
    public static final Property seeks = m.createProperty(NS+"seeks");
    public static final Property containsSeason = m.createProperty(NS+"containsSeason");
    public static final Property addOn = m.createProperty(NS+"addOn");
    public static final Property browserRequirements = m.createProperty(NS+"browserRequirements");
    public static final Property lesserOrEqual = m.createProperty(NS+"lesserOrEqual");
    public static final Property cvdNumC19HospPats = m.createProperty(NS+"cvdNumC19HospPats");
    public static final Property distinguishingSign = m.createProperty(NS+"distinguishingSign");
    public static final Property valueMaxLength = m.createProperty(NS+"valueMaxLength");
    public static final Property height = m.createProperty(NS+"height");
    public static final Property numberOfBedrooms = m.createProperty(NS+"numberOfBedrooms");
    public static final Property itinerary = m.createProperty(NS+"itinerary");
    public static final Property afterMedia = m.createProperty(NS+"afterMedia");
    public static final Property citation = m.createProperty(NS+"citation");
    public static final Property honorificSuffix = m.createProperty(NS+"honorificSuffix");
    public static final Property map = m.createProperty(NS+"map");
    public static final Property occupationalCategory = m.createProperty(NS+"occupationalCategory");
    public static final Property seatingCapacity = m.createProperty(NS+"seatingCapacity");
    public static final Property pregnancyCategory = m.createProperty(NS+"pregnancyCategory");
    public static final Property longitude = m.createProperty(NS+"longitude");
    public static final Property cvdCollectionDate = m.createProperty(NS+"cvdCollectionDate");
    public static final Property applicationContact = m.createProperty(NS+"applicationContact");
    public static final Property supportingData = m.createProperty(NS+"supportingData");
    public static final Property geoDisjoint = m.createProperty(NS+"geoDisjoint");
    public static final Property distance = m.createProperty(NS+"distance");
    public static final Property leaseLength = m.createProperty(NS+"leaseLength");
    public static final Property mpn = m.createProperty(NS+"mpn");
    public static final Property superEvent = m.createProperty(NS+"superEvent");
    public static final Property advanceBookingRequirement = m.createProperty(NS+"advanceBookingRequirement");
    public static final Property mechanismOfAction = m.createProperty(NS+"mechanismOfAction");
    public static final Property audience = m.createProperty(NS+"audience");
    public static final Property duration = m.createProperty(NS+"duration");
    public static final Property typeOfBed = m.createProperty(NS+"typeOfBed");
    public static final Property programName = m.createProperty(NS+"programName");
    public static final Property comprisedOf = m.createProperty(NS+"comprisedOf");
    public static final Property coverageEndTime = m.createProperty(NS+"coverageEndTime");
    public static final Property starRating = m.createProperty(NS+"starRating");
    public static final Property startTime = m.createProperty(NS+"startTime");
    public static final Property membershipPointsEarned = m.createProperty(NS+"membershipPointsEarned");
    public static final Property codingSystem = m.createProperty(NS+"codingSystem");
    public static final Property vehicleInteriorColor = m.createProperty(NS+"vehicleInteriorColor");
    public static final Property rangeIncludes = m.createProperty(NS+"rangeIncludes");
    public static final Property nerve = m.createProperty(NS+"nerve");
    public static final Property activityDuration = m.createProperty(NS+"activityDuration");
    public static final Property correctionsPolicy = m.createProperty(NS+"correctionsPolicy");
    public static final Property benefits = m.createProperty(NS+"benefits");
    public static final Property articleSection = m.createProperty(NS+"articleSection");
    public static final Property sportsTeam = m.createProperty(NS+"sportsTeam");
    public static final Property encodesCreativeWork = m.createProperty(NS+"encodesCreativeWork");
    public static final Property courseMode = m.createProperty(NS+"courseMode");
    public static final Property servingSize = m.createProperty(NS+"servingSize");
    public static final Property subTest = m.createProperty(NS+"subTest");
    public static final Property masthead = m.createProperty(NS+"masthead");
    public static final Property subEvents = m.createProperty(NS+"subEvents");
    public static final Property hoursAvailable = m.createProperty(NS+"hoursAvailable");
    public static final Property salaryCurrency = m.createProperty(NS+"salaryCurrency");
    public static final Property releaseOf = m.createProperty(NS+"releaseOf");
    public static final Property documentation = m.createProperty(NS+"documentation");
    public static final Property memberOf = m.createProperty(NS+"memberOf");
    public static final Property owns = m.createProperty(NS+"owns");
    public static final Property propertyID = m.createProperty(NS+"propertyID");
    public static final Property hasPOS = m.createProperty(NS+"hasPOS");
    public static final Property legislationLegalForce = m.createProperty(NS+"legislationLegalForce");
    public static final Property marginOfError = m.createProperty(NS+"marginOfError");
    public static final Property nsn = m.createProperty(NS+"nsn");
    public static final Property normalRange = m.createProperty(NS+"normalRange");
    public static final Property isLiveBroadcast = m.createProperty(NS+"isLiveBroadcast");
    public static final Property wordCount = m.createProperty(NS+"wordCount");
    public static final Property doseSchedule = m.createProperty(NS+"doseSchedule");
    public static final Property priceValidUntil = m.createProperty(NS+"priceValidUntil");
    public static final Property recognizedBy = m.createProperty(NS+"recognizedBy");
    public static final Property legislationDate = m.createProperty(NS+"legislationDate");
    public static final Property smiles = m.createProperty(NS+"smiles");
    public static final Property associatedMedia = m.createProperty(NS+"associatedMedia");
    public static final Property colleagues = m.createProperty(NS+"colleagues");
    public static final Property percentile75 = m.createProperty(NS+"percentile75");
    public static final Property containedInPlace = m.createProperty(NS+"containedInPlace");
    public static final Property includesAttraction = m.createProperty(NS+"includesAttraction");
    public static final Property version = m.createProperty(NS+"version");
    public static final Property postalCodePrefix = m.createProperty(NS+"postalCodePrefix");
    public static final Property repeatFrequency = m.createProperty(NS+"repeatFrequency");
    public static final Property vehicleTransmission = m.createProperty(NS+"vehicleTransmission");
    public static final Property agent = m.createProperty(NS+"agent");
    public static final Property broadcastChannelId = m.createProperty(NS+"broadcastChannelId");
    public static final Property seller = m.createProperty(NS+"seller");
    public static final Property collectionSize = m.createProperty(NS+"collectionSize");
    public static final Property legalName = m.createProperty(NS+"legalName");
    public static final Property customer = m.createProperty(NS+"customer");
    public static final Property caption = m.createProperty(NS+"caption");
    public static final Property termsOfService = m.createProperty(NS+"termsOfService");
    public static final Property transmissionMethod = m.createProperty(NS+"transmissionMethod");
    public static final Property supply = m.createProperty(NS+"supply");
    public static final Property bookEdition = m.createProperty(NS+"bookEdition");
    public static final Property epidemiology = m.createProperty(NS+"epidemiology");
    public static final Property specialCommitments = m.createProperty(NS+"specialCommitments");
    public static final Property countryOfAssembly = m.createProperty(NS+"countryOfAssembly");
    public static final Property sku = m.createProperty(NS+"sku");
    public static final Property width = m.createProperty(NS+"width");
    public static final Property numberOfItems = m.createProperty(NS+"numberOfItems");
    public static final Property scheduledTime = m.createProperty(NS+"scheduledTime");
    public static final Property signOrSymptom = m.createProperty(NS+"signOrSymptom");
    public static final Property availableOnDevice = m.createProperty(NS+"availableOnDevice");
    public static final Property remainingAttendeeCapacity = m.createProperty(NS+"remainingAttendeeCapacity");
    public static final Property taxonRank = m.createProperty(NS+"taxonRank");
    public static final Property printColumn = m.createProperty(NS+"printColumn");
    public static final Property fuelEfficiency = m.createProperty(NS+"fuelEfficiency");
    public static final Property algorithm = m.createProperty(NS+"algorithm");
    public static final Property category = m.createProperty(NS+"category");
    public static final Property availableStrength = m.createProperty(NS+"availableStrength");
    public static final Property imagingTechnique = m.createProperty(NS+"imagingTechnique");
    public static final Property exerciseType = m.createProperty(NS+"exerciseType");
    public static final Property clinicalPharmacology = m.createProperty(NS+"clinicalPharmacology");
    public static final Property confirmationNumber = m.createProperty(NS+"confirmationNumber");
    public static final Property taxonomicRange = m.createProperty(NS+"taxonomicRange");
    public static final Property educationalProgramMode = m.createProperty(NS+"educationalProgramMode");
    public static final Property recipeCategory = m.createProperty(NS+"recipeCategory");
    public static final Property isUnlabelledFallback = m.createProperty(NS+"isUnlabelledFallback");
    public static final Property learningResourceType = m.createProperty(NS+"learningResourceType");
    public static final Property encodings = m.createProperty(NS+"encodings");
    public static final Property organizer = m.createProperty(NS+"organizer");
    public static final Property volumeNumber = m.createProperty(NS+"volumeNumber");
    public static final Property dateCreated = m.createProperty(NS+"dateCreated");
    public static final Property legislationLegalValue = m.createProperty(NS+"legislationLegalValue");
    public static final Property realEstateAgent = m.createProperty(NS+"realEstateAgent");
    public static final Property loanMortgageMandateAmount = m.createProperty(NS+"loanMortgageMandateAmount");
    public static final Property dietFeatures = m.createProperty(NS+"dietFeatures");
    public static final Property offerCount = m.createProperty(NS+"offerCount");
    public static final Property partOfTVSeries = m.createProperty(NS+"partOfTVSeries");
    public static final Property customerRemorseReturnShippingFeesAmount = m.createProperty(NS+"customerRemorseReturnShippingFeesAmount");
    public static final Property coverageStartTime = m.createProperty(NS+"coverageStartTime");
    public static final Property includesHealthPlanFormulary = m.createProperty(NS+"includesHealthPlanFormulary");
    public static final Property floorLevel = m.createProperty(NS+"floorLevel");
    public static final Property hasMolecularFunction = m.createProperty(NS+"hasMolecularFunction");
    public static final Property trackingNumber = m.createProperty(NS+"trackingNumber");
    public static final Property sourcedFrom = m.createProperty(NS+"sourcedFrom");
    public static final Property postalCodeEnd = m.createProperty(NS+"postalCodeEnd");
    public static final Property inventoryLevel = m.createProperty(NS+"inventoryLevel");
    public static final Property departureAirport = m.createProperty(NS+"departureAirport");
    public static final Property dataFeedElement = m.createProperty(NS+"dataFeedElement");
    public static final Property providesService = m.createProperty(NS+"providesService");
    public static final Property unitText = m.createProperty(NS+"unitText");
    public static final Property replacer = m.createProperty(NS+"replacer");
    public static final Property securityScreening = m.createProperty(NS+"securityScreening");
    public static final Property loanType = m.createProperty(NS+"loanType");
    public static final Property characterAttribute = m.createProperty(NS+"characterAttribute");
    public static final Property validFor = m.createProperty(NS+"validFor");
    public static final Property hasDefinedTerm = m.createProperty(NS+"hasDefinedTerm");
    public static final Property breastfeedingWarning = m.createProperty(NS+"breastfeedingWarning");
    public static final Property occupancy = m.createProperty(NS+"occupancy");
    public static final Property alternateName = m.createProperty(NS+"alternateName");
    public static final Property repetitions = m.createProperty(NS+"repetitions");
    public static final Property programmingModel = m.createProperty(NS+"programmingModel");
    public static final Property title = m.createProperty(NS+"title");
    public static final Property doorTime = m.createProperty(NS+"doorTime");
    public static final Property itemListElement = m.createProperty(NS+"itemListElement");
    public static final Property itemDefectReturnLabelSource = m.createProperty(NS+"itemDefectReturnLabelSource");
    public static final Property maximumPhysicalAttendeeCapacity = m.createProperty(NS+"maximumPhysicalAttendeeCapacity");
    public static final Property merchantReturnDays = m.createProperty(NS+"merchantReturnDays");
    public static final Property translationOfWork = m.createProperty(NS+"translationOfWork");
    public static final Property hasMenu = m.createProperty(NS+"hasMenu");
    public static final Property latitude = m.createProperty(NS+"latitude");
    public static final Property recognizingAuthority = m.createProperty(NS+"recognizingAuthority");
    public static final Property dropoffLocation = m.createProperty(NS+"dropoffLocation");
    public static final Property departureTerminal = m.createProperty(NS+"departureTerminal");
    public static final Property cvdNumTotBeds = m.createProperty(NS+"cvdNumTotBeds");
    public static final Property strengthUnit = m.createProperty(NS+"strengthUnit");
    public static final Property cargoVolume = m.createProperty(NS+"cargoVolume");
    public static final Property serviceLocation = m.createProperty(NS+"serviceLocation");
    public static final Property amenityFeature = m.createProperty(NS+"amenityFeature");
    public static final Property multipleValues = m.createProperty(NS+"multipleValues");
    public static final Property geoCoveredBy = m.createProperty(NS+"geoCoveredBy");
    public static final Property departureGate = m.createProperty(NS+"departureGate");
    public static final Property applicationSubCategory = m.createProperty(NS+"applicationSubCategory");
    public static final Property track = m.createProperty(NS+"track");
    public static final Property endOffset = m.createProperty(NS+"endOffset");
    public static final Property deathDate = m.createProperty(NS+"deathDate");
    public static final Property season = m.createProperty(NS+"season");
    public static final Property geoMidpoint = m.createProperty(NS+"geoMidpoint");
    public static final Property medicineSystem = m.createProperty(NS+"medicineSystem");
    public static final Property quarantineGuidelines = m.createProperty(NS+"quarantineGuidelines");
    public static final Property howPerformed = m.createProperty(NS+"howPerformed");
    public static final Property additionalNumberOfGuests = m.createProperty(NS+"additionalNumberOfGuests");
    public static final Property hiringOrganization = m.createProperty(NS+"hiringOrganization");
    public static final Property appliesToPaymentMethod = m.createProperty(NS+"appliesToPaymentMethod");
    public static final Property itemShipped = m.createProperty(NS+"itemShipped");
    public static final Property currency = m.createProperty(NS+"currency");
    public static final Property seriousAdverseOutcome = m.createProperty(NS+"seriousAdverseOutcome");
    public static final Property legislationConsolidates = m.createProperty(NS+"legislationConsolidates");
    public static final Property engineType = m.createProperty(NS+"engineType");
    public static final Property executableLibraryName = m.createProperty(NS+"executableLibraryName");
    public static final Property cvdNumVentUse = m.createProperty(NS+"cvdNumVentUse");
    public static final Property percentile10 = m.createProperty(NS+"percentile10");
    public static final Property encodesBioChemEntity = m.createProperty(NS+"encodesBioChemEntity");
    public static final Property servicePostalAddress = m.createProperty(NS+"servicePostalAddress");
    public static final Property childMaxAge = m.createProperty(NS+"childMaxAge");
    public static final Property actor = m.createProperty(NS+"actor");
    public static final Property costCurrency = m.createProperty(NS+"costCurrency");
    public static final Property checkinTime = m.createProperty(NS+"checkinTime");
    public static final Property fuelType = m.createProperty(NS+"fuelType");
    public static final Property employmentUnit = m.createProperty(NS+"employmentUnit");
    public static final Property variableMeasured = m.createProperty(NS+"variableMeasured");
    public static final Property broadcastServiceTier = m.createProperty(NS+"broadcastServiceTier");
    public static final Property sodiumContent = m.createProperty(NS+"sodiumContent");
    public static final Property broadcastDisplayName = m.createProperty(NS+"broadcastDisplayName");
    public static final Property inChI = m.createProperty(NS+"inChI");
    public static final Property geoWithin = m.createProperty(NS+"geoWithin");
    public static final Property membershipNumber = m.createProperty(NS+"membershipNumber");
    public static final Property returnPolicySeasonalOverride = m.createProperty(NS+"returnPolicySeasonalOverride");
    public static final Property directors = m.createProperty(NS+"directors");
    public static final Property vehicleInteriorType = m.createProperty(NS+"vehicleInteriorType");
    public static final Property sdDatePublished = m.createProperty(NS+"sdDatePublished");
    public static final Property recordLabel = m.createProperty(NS+"recordLabel");
    public static final Property activeIngredient = m.createProperty(NS+"activeIngredient");
    public static final Property supplyTo = m.createProperty(NS+"supplyTo");
    public static final Property isRelatedTo = m.createProperty(NS+"isRelatedTo");
    public static final Property loanPaymentAmount = m.createProperty(NS+"loanPaymentAmount");
    public static final Property keywords = m.createProperty(NS+"keywords");
    public static final Property itemDefectReturnFees = m.createProperty(NS+"itemDefectReturnFees");
    public static final Property courseWorkload = m.createProperty(NS+"courseWorkload");
    public static final Property expectedPrognosis = m.createProperty(NS+"expectedPrognosis");
    public static final Property healthPlanDrugTier = m.createProperty(NS+"healthPlanDrugTier");
    public static final Property seasons = m.createProperty(NS+"seasons");
    public static final Property drug = m.createProperty(NS+"drug");
    public static final Property renegotiableLoan = m.createProperty(NS+"renegotiableLoan");
    public static final Property openingHours = m.createProperty(NS+"openingHours");
    public static final Property availableAtOrFrom = m.createProperty(NS+"availableAtOrFrom");
    public static final Property dosageForm = m.createProperty(NS+"dosageForm");
    public static final Property recordingOf = m.createProperty(NS+"recordingOf");
    public static final Property deliveryAddress = m.createProperty(NS+"deliveryAddress");
    public static final Property depth = m.createProperty(NS+"depth");
    public static final Property availableThrough = m.createProperty(NS+"availableThrough");
    public static final Property cvdNumICUBedsOcc = m.createProperty(NS+"cvdNumICUBedsOcc");
    public static final Property petsAllowed = m.createProperty(NS+"petsAllowed");
    public static final Property reviews = m.createProperty(NS+"reviews");
    public static final Property hasOccupation = m.createProperty(NS+"hasOccupation");
    public static final Property foodWarning = m.createProperty(NS+"foodWarning");
    public static final Property restPeriods = m.createProperty(NS+"restPeriods");
    public static final Property fileSize = m.createProperty(NS+"fileSize");
    public static final Property nonProprietaryName = m.createProperty(NS+"nonProprietaryName");
    public static final Property postOp = m.createProperty(NS+"postOp");
    public static final Property pagination = m.createProperty(NS+"pagination");
    public static final Property tourBookingPage = m.createProperty(NS+"tourBookingPage");
    public static final Property borrower = m.createProperty(NS+"borrower");
    public static final Property returnLabelSource = m.createProperty(NS+"returnLabelSource");
    public static final Property connectedTo = m.createProperty(NS+"connectedTo");
    public static final Property address = m.createProperty(NS+"address");
    public static final Property previousItem = m.createProperty(NS+"previousItem");
    public static final Property embeddedTextCaption = m.createProperty(NS+"embeddedTextCaption");
    public static final Property healthPlanCostSharing = m.createProperty(NS+"healthPlanCostSharing");
    public static final Property parentOrganization = m.createProperty(NS+"parentOrganization");
    public static final Property clipNumber = m.createProperty(NS+"clipNumber");
    public static final Property elevation = m.createProperty(NS+"elevation");
    public static final Property webFeed = m.createProperty(NS+"webFeed");
    public static final Property nationality = m.createProperty(NS+"nationality");
    public static final Property openingHoursSpecification = m.createProperty(NS+"openingHoursSpecification");
    public static final Property molecularWeight = m.createProperty(NS+"molecularWeight");
    public static final Property dateReceived = m.createProperty(NS+"dateReceived");
    public static final Property addressLocality = m.createProperty(NS+"addressLocality");
    public static final Property seasonNumber = m.createProperty(NS+"seasonNumber");
    public static final Property healthPlanCopayOption = m.createProperty(NS+"healthPlanCopayOption");
    public static final Property educationalLevel = m.createProperty(NS+"educationalLevel");
    public static final Property applicableLocation = m.createProperty(NS+"applicableLocation");
    public static final Property countriesSupported = m.createProperty(NS+"countriesSupported");
    public static final Property shippingDestination = m.createProperty(NS+"shippingDestination");
    public static final Property ingredients = m.createProperty(NS+"ingredients");
    public static final Property isSimilarTo = m.createProperty(NS+"isSimilarTo");
    public static final Property referenceQuantity = m.createProperty(NS+"referenceQuantity");
    public static final Property code = m.createProperty(NS+"code");
    public static final Property offersPrescriptionByMail = m.createProperty(NS+"offersPrescriptionByMail");
    public static final Property homeLocation = m.createProperty(NS+"homeLocation");
    public static final Property affiliation = m.createProperty(NS+"affiliation");
    public static final Property postalCodeRange = m.createProperty(NS+"postalCodeRange");
    public static final Property embedUrl = m.createProperty(NS+"embedUrl");
    public static final Property opens = m.createProperty(NS+"opens");
    public static final Property hasDeliveryMethod = m.createProperty(NS+"hasDeliveryMethod");
    public static final Property stage = m.createProperty(NS+"stage");
    public static final Property contentType = m.createProperty(NS+"contentType");
    public static final Property streetAddress = m.createProperty(NS+"streetAddress");
    public static final Property availabilityEnds = m.createProperty(NS+"availabilityEnds");
    public static final Property globalLocationNumber = m.createProperty(NS+"globalLocationNumber");
    public static final Property workHours = m.createProperty(NS+"workHours");
    public static final Property duringMedia = m.createProperty(NS+"duringMedia");
    public static final Property busNumber = m.createProperty(NS+"busNumber");
    public static final Property referencesOrder = m.createProperty(NS+"referencesOrder");
    public static final Property instrument = m.createProperty(NS+"instrument");
    public static final Property hasEnergyEfficiencyCategory = m.createProperty(NS+"hasEnergyEfficiencyCategory");
    public static final Property orderItemStatus = m.createProperty(NS+"orderItemStatus");
    public static final Property orderQuantity = m.createProperty(NS+"orderQuantity");
    public static final Property hasRepresentation = m.createProperty(NS+"hasRepresentation");
    public static final Property maximumAttendeeCapacity = m.createProperty(NS+"maximumAttendeeCapacity");
    public static final Property partOfEpisode = m.createProperty(NS+"partOfEpisode");
    public static final Property partOfSystem = m.createProperty(NS+"partOfSystem");
    public static final Property variantCover = m.createProperty(NS+"variantCover");
    public static final Property claimInterpreter = m.createProperty(NS+"claimInterpreter");
    public static final Property recipient = m.createProperty(NS+"recipient");
    public static final Property postOfficeBoxNumber = m.createProperty(NS+"postOfficeBoxNumber");
    public static final Property broadcastFrequencyValue = m.createProperty(NS+"broadcastFrequencyValue");
    public static final Property collection = m.createProperty(NS+"collection");
    public static final Property maps = m.createProperty(NS+"maps");
    public static final Property thumbnailUrl = m.createProperty(NS+"thumbnailUrl");
    public static final Property labelDetails = m.createProperty(NS+"labelDetails");
    public static final Property vehicleSeatingCapacity = m.createProperty(NS+"vehicleSeatingCapacity");
    public static final Property resultComment = m.createProperty(NS+"resultComment");
    public static final Property authenticator = m.createProperty(NS+"authenticator");
    public static final Property paymentMethodId = m.createProperty(NS+"paymentMethodId");
    public static final Property contactPoints = m.createProperty(NS+"contactPoints");
    public static final Property sdLicense = m.createProperty(NS+"sdLicense");
    public static final Property knowsLanguage = m.createProperty(NS+"knowsLanguage");
    public static final Property molecularFormula = m.createProperty(NS+"molecularFormula");
    public static final Property query = m.createProperty(NS+"query");
    public static final Property tongueWeight = m.createProperty(NS+"tongueWeight");
    public static final Property reviewBody = m.createProperty(NS+"reviewBody");
    public static final Property performer = m.createProperty(NS+"performer");
    public static final Property parentItem = m.createProperty(NS+"parentItem");
    public static final Property performers = m.createProperty(NS+"performers");
    public static final Property jobTitle = m.createProperty(NS+"jobTitle");
    public static final Property position = m.createProperty(NS+"position");
    public static final Property significantLink = m.createProperty(NS+"significantLink");
    public static final Property recipeInstructions = m.createProperty(NS+"recipeInstructions");
    public static final Property foundingLocation = m.createProperty(NS+"foundingLocation");
    public static final Property pickupLocation = m.createProperty(NS+"pickupLocation");
    public static final Property hasOfferCatalog = m.createProperty(NS+"hasOfferCatalog");
    public static final Property arrivalAirport = m.createProperty(NS+"arrivalAirport");
    public static final Property minPrice = m.createProperty(NS+"minPrice");
    public static final Property eventSchedule = m.createProperty(NS+"eventSchedule");
    public static final Property fromLocation = m.createProperty(NS+"fromLocation");
    public static final Property sdPublisher = m.createProperty(NS+"sdPublisher");
    public static final Property gameTip = m.createProperty(NS+"gameTip");
    public static final Property jobStartDate = m.createProperty(NS+"jobStartDate");
    public static final Property discount = m.createProperty(NS+"discount");
    public static final Property chemicalRole = m.createProperty(NS+"chemicalRole");
    public static final Property contentSize = m.createProperty(NS+"contentSize");
    public static final Property checkoutTime = m.createProperty(NS+"checkoutTime");
    public static final Property isBasedOnUrl = m.createProperty(NS+"isBasedOnUrl");
    public static final Property responsibilities = m.createProperty(NS+"responsibilities");
    public static final Property preparation = m.createProperty(NS+"preparation");
    public static final Property restockingFee = m.createProperty(NS+"restockingFee");
    public static final Property liveBlogUpdate = m.createProperty(NS+"liveBlogUpdate");
    public static final Property vehicleModelDate = m.createProperty(NS+"vehicleModelDate");
    public static final Property recommendedIntake = m.createProperty(NS+"recommendedIntake");
    public static final Property iataCode = m.createProperty(NS+"iataCode");
    public static final Property relatedLink = m.createProperty(NS+"relatedLink");
    public static final Property childMinAge = m.createProperty(NS+"childMinAge");
    public static final Property announcementLocation = m.createProperty(NS+"announcementLocation");
    public static final Property targetUrl = m.createProperty(NS+"targetUrl");
    public static final Property downPayment = m.createProperty(NS+"downPayment");
    public static final Property leiCode = m.createProperty(NS+"leiCode");
    public static final Property textValue = m.createProperty(NS+"textValue");
    public static final Property award = m.createProperty(NS+"award");
    public static final Property birthDate = m.createProperty(NS+"birthDate");
    public static final Property price = m.createProperty(NS+"price");
    public static final Property courseCode = m.createProperty(NS+"courseCode");
    public static final Property possibleComplication = m.createProperty(NS+"possibleComplication");
    public static final Property menuAddOn = m.createProperty(NS+"menuAddOn");
    public static final Property potentialUse = m.createProperty(NS+"potentialUse");
    public static final Property carrier = m.createProperty(NS+"carrier");
    public static final Property temporal = m.createProperty(NS+"temporal");
    public static final Property refundType = m.createProperty(NS+"refundType");
    public static final Property skills = m.createProperty(NS+"skills");
    public static final Property serviceArea = m.createProperty(NS+"serviceArea");
    public static final Property publisherImprint = m.createProperty(NS+"publisherImprint");
    public static final Property governmentBenefitsInfo = m.createProperty(NS+"governmentBenefitsInfo");
    public static final Property playerType = m.createProperty(NS+"playerType");
    public static final Property busName = m.createProperty(NS+"busName");
    public static final Property correction = m.createProperty(NS+"correction");
    public static final Property parents = m.createProperty(NS+"parents");
    public static final Property beforeMedia = m.createProperty(NS+"beforeMedia");
    public static final Property numberOfPreviousOwners = m.createProperty(NS+"numberOfPreviousOwners");
    public static final Property mediaItemAppearance = m.createProperty(NS+"mediaItemAppearance");
    public static final Property jobLocationType = m.createProperty(NS+"jobLocationType");
    public static final Property yearsInOperation = m.createProperty(NS+"yearsInOperation");
    public static final Property bookingTime = m.createProperty(NS+"bookingTime");
    public static final Property events = m.createProperty(NS+"events");
    public static final Property nutrition = m.createProperty(NS+"nutrition");
    public static final Property associatedAnatomy = m.createProperty(NS+"associatedAnatomy");
    public static final Property member = m.createProperty(NS+"member");
    public static final Property publicationType = m.createProperty(NS+"publicationType");
    public static final Property runsTo = m.createProperty(NS+"runsTo");
    public static final Property healthcareReportingData = m.createProperty(NS+"healthcareReportingData");
    public static final Property sensoryRequirement = m.createProperty(NS+"sensoryRequirement");
    public static final Property arrivalBoatTerminal = m.createProperty(NS+"arrivalBoatTerminal");
    public static final Property shippingRate = m.createProperty(NS+"shippingRate");
    public static final Property pattern = m.createProperty(NS+"pattern");
    public static final Property countriesNotSupported = m.createProperty(NS+"countriesNotSupported");
    public static final Property warning = m.createProperty(NS+"warning");
    public static final Property identifier = m.createProperty(NS+"identifier");
    public static final Property baseSalary = m.createProperty(NS+"baseSalary");
    public static final Property estimatedFlightDuration = m.createProperty(NS+"estimatedFlightDuration");
    public static final Property numberOfLoanPayments = m.createProperty(NS+"numberOfLoanPayments");
    public static final Property isEncodedByBioChemEntity = m.createProperty(NS+"isEncodedByBioChemEntity");
    public static final Property datePosted = m.createProperty(NS+"datePosted");
    public static final Property serviceType = m.createProperty(NS+"serviceType");
    public static final Property lyricist = m.createProperty(NS+"lyricist");
    public static final Property priceType = m.createProperty(NS+"priceType");
    public static final Property study = m.createProperty(NS+"study");
    public static final Property numberOfForwardGears = m.createProperty(NS+"numberOfForwardGears");
    public static final Property targetDescription = m.createProperty(NS+"targetDescription");
    public static final Property amountOfThisGood = m.createProperty(NS+"amountOfThisGood");
    public static final Property exceptDate = m.createProperty(NS+"exceptDate");
    public static final Property targetName = m.createProperty(NS+"targetName");
    public static final Property gender = m.createProperty(NS+"gender");
    public static final Property workPresented = m.createProperty(NS+"workPresented");
    public static final Property isProprietary = m.createProperty(NS+"isProprietary");
    public static final Property actionAccessibilityRequirement = m.createProperty(NS+"actionAccessibilityRequirement");
    public static final Property productID = m.createProperty(NS+"productID");
    public static final Property numberOfPlayers = m.createProperty(NS+"numberOfPlayers");
    public static final Property closes = m.createProperty(NS+"closes");
    public static final Property processingTime = m.createProperty(NS+"processingTime");
    public static final Property totalPaymentDue = m.createProperty(NS+"totalPaymentDue");
    public static final Property annualPercentageRate = m.createProperty(NS+"annualPercentageRate");
    public static final Property answerCount = m.createProperty(NS+"answerCount");
    public static final Property associatedArticle = m.createProperty(NS+"associatedArticle");
    public static final Property iupacName = m.createProperty(NS+"iupacName");
    public static final Property arrivalGate = m.createProperty(NS+"arrivalGate");
    public static final Property legislationTransposes = m.createProperty(NS+"legislationTransposes");
    public static final Property rsvpResponse = m.createProperty(NS+"rsvpResponse");
    public static final Property requirements = m.createProperty(NS+"requirements");
    public static final Property targetPopulation = m.createProperty(NS+"targetPopulation");
    public static final Property bccRecipient = m.createProperty(NS+"bccRecipient");
    public static final Property numberOfDoors = m.createProperty(NS+"numberOfDoors");
    public static final Property associatedMediaReview = m.createProperty(NS+"associatedMediaReview");
    public static final Property totalPrice = m.createProperty(NS+"totalPrice");
    public static final Property typicalCreditsPerTerm = m.createProperty(NS+"typicalCreditsPerTerm");
    public static final Property translator = m.createProperty(NS+"translator");
    public static final Property dissolutionDate = m.createProperty(NS+"dissolutionDate");
    public static final Property encodingType = m.createProperty(NS+"encodingType");
    public static final Property upvoteCount = m.createProperty(NS+"upvoteCount");
    public static final Property eduQuestionType = m.createProperty(NS+"eduQuestionType");
    public static final Property wheelbase = m.createProperty(NS+"wheelbase");
    public static final Property unitCode = m.createProperty(NS+"unitCode");
    public static final Property author = m.createProperty(NS+"author");
    public static final Property actors = m.createProperty(NS+"actors");
    public static final Property replyToUrl = m.createProperty(NS+"replyToUrl");
    public static final Property smokingAllowed = m.createProperty(NS+"smokingAllowed");
    public static final Property healthPlanId = m.createProperty(NS+"healthPlanId");
    public static final Property hasMap = m.createProperty(NS+"hasMap");
    public static final Property publishedOn = m.createProperty(NS+"publishedOn");
    public static final Property totalTime = m.createProperty(NS+"totalTime");
    public static final Property billingIncrement = m.createProperty(NS+"billingIncrement");
    public static final Property bioChemInteraction = m.createProperty(NS+"bioChemInteraction");
    public static final Property lender = m.createProperty(NS+"lender");
    public static final Property numConstraints = m.createProperty(NS+"numConstraints");
    public static final Property cvdNumC19OverflowPats = m.createProperty(NS+"cvdNumC19OverflowPats");
    public static final Property eventStatus = m.createProperty(NS+"eventStatus");
    public static final Property issuedThrough = m.createProperty(NS+"issuedThrough");
    public static final Property cookingMethod = m.createProperty(NS+"cookingMethod");
    public static final Property knownVehicleDamages = m.createProperty(NS+"knownVehicleDamages");
    public static final Property character = m.createProperty(NS+"character");
    public static final Property childTaxon = m.createProperty(NS+"childTaxon");
    public static final Property blogPosts = m.createProperty(NS+"blogPosts");
    public static final Property returnPolicyCountry = m.createProperty(NS+"returnPolicyCountry");
    public static final Property artworkSurface = m.createProperty(NS+"artworkSurface");
    public static final Property drugUnit = m.createProperty(NS+"drugUnit");
    public static final Property validIn = m.createProperty(NS+"validIn");
    public static final Property monoisotopicMolecularWeight = m.createProperty(NS+"monoisotopicMolecularWeight");
    public static final Property numTracks = m.createProperty(NS+"numTracks");
    public static final Property ticketNumber = m.createProperty(NS+"ticketNumber");
    public static final Property geoIntersects = m.createProperty(NS+"geoIntersects");
    public static final Property downvoteCount = m.createProperty(NS+"downvoteCount");
    public static final Property numberOfEpisodes = m.createProperty(NS+"numberOfEpisodes");
    public static final Property applicantLocationRequirements = m.createProperty(NS+"applicantLocationRequirements");
    public static final Property signDetected = m.createProperty(NS+"signDetected");
    public static final Property xpath = m.createProperty(NS+"xpath");
    public static final Property warrantyPromise = m.createProperty(NS+"warrantyPromise");
    public static final Property abridged = m.createProperty(NS+"abridged");
    public static final Property shippingSettingsLink = m.createProperty(NS+"shippingSettingsLink");
    public static final Property numberOfFullBathrooms = m.createProperty(NS+"numberOfFullBathrooms");
    public static final Property messageAttachment = m.createProperty(NS+"messageAttachment");
    public static final Property targetCollection = m.createProperty(NS+"targetCollection");
    public static final Property pageStart = m.createProperty(NS+"pageStart");
    public static final Property returnShippingFeesAmount = m.createProperty(NS+"returnShippingFeesAmount");
    public static final Property speechToTextMarkup = m.createProperty(NS+"speechToTextMarkup");
    public static final Property endorsee = m.createProperty(NS+"endorsee");
    public static final Property blogPost = m.createProperty(NS+"blogPost");
    public static final Property numberedPosition = m.createProperty(NS+"numberedPosition");
    public static final Property serviceAudience = m.createProperty(NS+"serviceAudience");
    public static final Property priceComponent = m.createProperty(NS+"priceComponent");
    public static final Property isLocatedInSubcellularLocation = m.createProperty(NS+"isLocatedInSubcellularLocation");
    public static final Property suggestedGender = m.createProperty(NS+"suggestedGender");
    public static final Property orderStatus = m.createProperty(NS+"orderStatus");
    public static final Property comment = m.createProperty(NS+"comment");
    public static final Property sha256 = m.createProperty(NS+"sha256");
    public static final Property proprietaryName = m.createProperty(NS+"proprietaryName");
    public static final Property stepValue = m.createProperty(NS+"stepValue");
    public static final Property ratingExplanation = m.createProperty(NS+"ratingExplanation");
    public static final Property bankAccountType = m.createProperty(NS+"bankAccountType");
    public static final Property educationalCredentialAwarded = m.createProperty(NS+"educationalCredentialAwarded");
    public static final Property pickupTime = m.createProperty(NS+"pickupTime");
    public static final Property cheatCode = m.createProperty(NS+"cheatCode");
    public static final Property suggestedMaxAge = m.createProperty(NS+"suggestedMaxAge");
    public static final Property icaoCode = m.createProperty(NS+"icaoCode");
    public static final Property identifyingTest = m.createProperty(NS+"identifyingTest");
    public static final Property mathExpression = m.createProperty(NS+"mathExpression");
    public static final Property ineligibleRegion = m.createProperty(NS+"ineligibleRegion");
    public static final Property lesser = m.createProperty(NS+"lesser");
    public static final Property estimatesRiskOf = m.createProperty(NS+"estimatesRiskOf");
    public static final Property creditedTo = m.createProperty(NS+"creditedTo");
    public static final Property accountablePerson = m.createProperty(NS+"accountablePerson");
    public static final Property awards = m.createProperty(NS+"awards");
    public static final Property contentRating = m.createProperty(NS+"contentRating");
    public static final Property spouse = m.createProperty(NS+"spouse");
    public static final Property transcript = m.createProperty(NS+"transcript");
    public static final Property weightTotal = m.createProperty(NS+"weightTotal");
    public static final Property interestRate = m.createProperty(NS+"interestRate");
    public static final Property inDefinedTermSet = m.createProperty(NS+"inDefinedTermSet");
    public static final Property healthPlanPharmacyCategory = m.createProperty(NS+"healthPlanPharmacyCategory");
    public static final Property gracePeriod = m.createProperty(NS+"gracePeriod");
    public static final Property isInvolvedInBiologicalProcess = m.createProperty(NS+"isInvolvedInBiologicalProcess");
    public static final Property codeRepository = m.createProperty(NS+"codeRepository");
    public static final Property serviceSmsNumber = m.createProperty(NS+"serviceSmsNumber");
    public static final Property valueMinLength = m.createProperty(NS+"valueMinLength");
    public static final Property parentService = m.createProperty(NS+"parentService");
    public static final Property interactionCount = m.createProperty(NS+"interactionCount");
    public static final Property missionCoveragePrioritiesPolicy = m.createProperty(NS+"missionCoveragePrioritiesPolicy");
    public static final Property acceptsReservations = m.createProperty(NS+"acceptsReservations");
    public static final Property jobBenefits = m.createProperty(NS+"jobBenefits");
    public static final Property costCategory = m.createProperty(NS+"costCategory");
    public static final Property telephone = m.createProperty(NS+"telephone");
    public static final Property url = m.createProperty(NS+"url");
    public static final Property yield = m.createProperty(NS+"yield");
    public static final Property constrainingProperty = m.createProperty(NS+"constrainingProperty");
    public static final Property priceSpecification = m.createProperty(NS+"priceSpecification");
    public static final Property originatesFrom = m.createProperty(NS+"originatesFrom");
    public static final Property tracks = m.createProperty(NS+"tracks");
    public static final Property educationalRole = m.createProperty(NS+"educationalRole");
    public static final Property causeOf = m.createProperty(NS+"causeOf");
    public static final Property yearBuilt = m.createProperty(NS+"yearBuilt");
    public static final Property domiciledMortgage = m.createProperty(NS+"domiciledMortgage");
    public static final Property isGift = m.createProperty(NS+"isGift");
    public static final Property noBylinesPolicy = m.createProperty(NS+"noBylinesPolicy");
    public static final Property vendor = m.createProperty(NS+"vendor");
    public static final Property workLocation = m.createProperty(NS+"workLocation");
    public static final Property infectiousAgentClass = m.createProperty(NS+"infectiousAgentClass");
    public static final Property subOrganization = m.createProperty(NS+"subOrganization");
    public static final Property loanRepaymentForm = m.createProperty(NS+"loanRepaymentForm");
    public static final Property publishedBy = m.createProperty(NS+"publishedBy");
    public static final Property deliveryLeadTime = m.createProperty(NS+"deliveryLeadTime");
    public static final Property contactPoint = m.createProperty(NS+"contactPoint");
    public static final Property interactionService = m.createProperty(NS+"interactionService");
    public static final Property playMode = m.createProperty(NS+"playMode");
    public static final Property provider = m.createProperty(NS+"provider");
    public static final Property trialDesign = m.createProperty(NS+"trialDesign");
    public static final Property medicalSpecialty = m.createProperty(NS+"medicalSpecialty");
    public static final Property itemCondition = m.createProperty(NS+"itemCondition");
    public static final Property amount = m.createProperty(NS+"amount");
    public static final Property additionalProperty = m.createProperty(NS+"additionalProperty");
    public static final Property hasVariant = m.createProperty(NS+"hasVariant");
    public static final Property coach = m.createProperty(NS+"coach");
    public static final Property hasMenuItem = m.createProperty(NS+"hasMenuItem");
    public static final Property accessibilityControl = m.createProperty(NS+"accessibilityControl");
    public static final Property line = m.createProperty(NS+"line");
    public static final Property isPartOfBioChemEntity = m.createProperty(NS+"isPartOfBioChemEntity");
    public static final Property feesAndCommissionsSpecification = m.createProperty(NS+"feesAndCommissionsSpecification");
    public static final Property partOfInvoice = m.createProperty(NS+"partOfInvoice");
    public static final Property alumniOf = m.createProperty(NS+"alumniOf");
    public static final Property occupationLocation = m.createProperty(NS+"occupationLocation");
    public static final Property hasBioChemEntityPart = m.createProperty(NS+"hasBioChemEntityPart");
    public static final Property programmingLanguage = m.createProperty(NS+"programmingLanguage");
    public static final Property expectedArrivalUntil = m.createProperty(NS+"expectedArrivalUntil");
    public static final Property makesOffer = m.createProperty(NS+"makesOffer");
    public static final Property steeringPosition = m.createProperty(NS+"steeringPosition");
    public static final Property originalMediaContextDescription = m.createProperty(NS+"originalMediaContextDescription");
    public static final Property studyLocation = m.createProperty(NS+"studyLocation");
    public static final Property answerExplanation = m.createProperty(NS+"answerExplanation");
    public static final Property resultReview = m.createProperty(NS+"resultReview");
    public static final Property surface = m.createProperty(NS+"surface");
    public static final Property dependencies = m.createProperty(NS+"dependencies");
    public static final Property winner = m.createProperty(NS+"winner");
    public static final Property jobLocation = m.createProperty(NS+"jobLocation");
    public static final Property businessFunction = m.createProperty(NS+"businessFunction");
    public static final Property availableIn = m.createProperty(NS+"availableIn");
    public static final Property sampleType = m.createProperty(NS+"sampleType");
    public static final Property modifiedTime = m.createProperty(NS+"modifiedTime");
    public static final Property requiredGender = m.createProperty(NS+"requiredGender");
    public static final Property credentialCategory = m.createProperty(NS+"credentialCategory");
    public static final Property branchCode = m.createProperty(NS+"branchCode");
    public static final Property seatSection = m.createProperty(NS+"seatSection");
    public static final Property cvdNumC19MechVentPats = m.createProperty(NS+"cvdNumC19MechVentPats");
    public static final Property publisher = m.createProperty(NS+"publisher");
    public static final Property speakable = m.createProperty(NS+"speakable");
    public static final Property drugClass = m.createProperty(NS+"drugClass");
    public static final Property name = m.createProperty(NS+"name");
    public static final Property primaryImageOfPage = m.createProperty(NS+"primaryImageOfPage");
    public static final Property utterances = m.createProperty(NS+"utterances");
    public static final Property sharedContent = m.createProperty(NS+"sharedContent");
    public static final Property jurisdiction = m.createProperty(NS+"jurisdiction");
    public static final Property bookingAgent = m.createProperty(NS+"bookingAgent");
    public static final Property trainName = m.createProperty(NS+"trainName");
    public static final Property creator = m.createProperty(NS+"creator");
    public static final Property nerveMotor = m.createProperty(NS+"nerveMotor");
    public static final Property brand = m.createProperty(NS+"brand");
    public static final Property applicationCategory = m.createProperty(NS+"applicationCategory");
    public static final Property byMonthDay = m.createProperty(NS+"byMonthDay");
    public static final Property departurePlatform = m.createProperty(NS+"departurePlatform");
    public static final Property contentUrl = m.createProperty(NS+"contentUrl");
    public static final Property callSign = m.createProperty(NS+"callSign");
    public static final Property deliveryMethod = m.createProperty(NS+"deliveryMethod");
    public static final Property application = m.createProperty(NS+"application");
    public static final Property greaterOrEqual = m.createProperty(NS+"greaterOrEqual");
    public static final Property expertConsiderations = m.createProperty(NS+"expertConsiderations");
    public static final Property runtime = m.createProperty(NS+"runtime");
    public static final Property specialOpeningHoursSpecification = m.createProperty(NS+"specialOpeningHoursSpecification");
    public static final Property orderNumber = m.createProperty(NS+"orderNumber");
    public static final Property educationalUse = m.createProperty(NS+"educationalUse");
    public static final Property subReservation = m.createProperty(NS+"subReservation");
    public static final Property naturalProgression = m.createProperty(NS+"naturalProgression");
    public static final Property commentTime = m.createProperty(NS+"commentTime");
    public static final Property vehicleIdentificationNumber = m.createProperty(NS+"vehicleIdentificationNumber");
    public static final Property bioChemSimilarity = m.createProperty(NS+"bioChemSimilarity");
    public static final Property regionsAllowed = m.createProperty(NS+"regionsAllowed");
    public static final Property contactType = m.createProperty(NS+"contactType");
    public static final Property status = m.createProperty(NS+"status");
    public static final Property cashBack = m.createProperty(NS+"cashBack");
    public static final Property valueAddedTaxIncluded = m.createProperty(NS+"valueAddedTaxIncluded");
    public static final Property manufacturer = m.createProperty(NS+"manufacturer");
    public static final Property attendees = m.createProperty(NS+"attendees");
    public static final Property worksFor = m.createProperty(NS+"worksFor");
    public static final Property healthPlanMarketingUrl = m.createProperty(NS+"healthPlanMarketingUrl");
    public static final Property cvdNumVent = m.createProperty(NS+"cvdNumVent");
    public static final Property assembly = m.createProperty(NS+"assembly");
    public static final Property foodEstablishment = m.createProperty(NS+"foodEstablishment");
    public static final Property artform = m.createProperty(NS+"artform");
    public static final Property lodgingUnitType = m.createProperty(NS+"lodgingUnitType");
    public static final Property creditText = m.createProperty(NS+"creditText");
    public static final Property naics = m.createProperty(NS+"naics");
    public static final Property interpretedAsClaim = m.createProperty(NS+"interpretedAsClaim");
    public static final Property dateVehicleFirstRegistered = m.createProperty(NS+"dateVehicleFirstRegistered");
    public static final Property fundedItem = m.createProperty(NS+"fundedItem");
    public static final Property billingDuration = m.createProperty(NS+"billingDuration");
    public static final Property issueNumber = m.createProperty(NS+"issueNumber");
    public static final Property productionDate = m.createProperty(NS+"productionDate");
    public static final Property circle = m.createProperty(NS+"circle");
    public static final Property performTime = m.createProperty(NS+"performTime");
    public static final Property isPartOf = m.createProperty(NS+"isPartOf");
    public static final Property appliesToDeliveryMethod = m.createProperty(NS+"appliesToDeliveryMethod");
    public static final Property usedToDiagnose = m.createProperty(NS+"usedToDiagnose");
    public static final Property nonEqual = m.createProperty(NS+"nonEqual");
    public static final Property exifData = m.createProperty(NS+"exifData");
    public static final Property device = m.createProperty(NS+"device");
    public static final Property sizeSystem = m.createProperty(NS+"sizeSystem");
    public static final Property applicationDeadline = m.createProperty(NS+"applicationDeadline");
    public static final Property jobImmediateStart = m.createProperty(NS+"jobImmediateStart");
    public static final Property object = m.createProperty(NS+"object");
    public static final Property costOrigin = m.createProperty(NS+"costOrigin");
    public static final Property bodyType = m.createProperty(NS+"bodyType");
    public static final Property spatial = m.createProperty(NS+"spatial");
    public static final Property hospitalAffiliation = m.createProperty(NS+"hospitalAffiliation");
    public static final Property geoCovers = m.createProperty(NS+"geoCovers");
    public static final Property recordedAt = m.createProperty(NS+"recordedAt");
    public static final Property hasBroadcastChannel = m.createProperty(NS+"hasBroadcastChannel");
    public static final Property foodEvent = m.createProperty(NS+"foodEvent");
    public static final Property performerIn = m.createProperty(NS+"performerIn");
    public static final Property sportsEvent = m.createProperty(NS+"sportsEvent");
    public static final Property securityClearanceRequirement = m.createProperty(NS+"securityClearanceRequirement");
    public static final Property mediaAuthenticityCategory = m.createProperty(NS+"mediaAuthenticityCategory");
    public static final Property accelerationTime = m.createProperty(NS+"accelerationTime");
    public static final Property physiologicalBenefits = m.createProperty(NS+"physiologicalBenefits");
    public static final Property availableFrom = m.createProperty(NS+"availableFrom");
    public static final Property inverseOf = m.createProperty(NS+"inverseOf");
    public static final Property artMedium = m.createProperty(NS+"artMedium");
    public static final Property providerMobility = m.createProperty(NS+"providerMobility");
    public static final Property recordedAs = m.createProperty(NS+"recordedAs");
    public static final Property orderDate = m.createProperty(NS+"orderDate");
    public static final Property clincalPharmacology = m.createProperty(NS+"clincalPharmacology");
    public static final Property free = m.createProperty(NS+"free");
    public static final Property albumRelease = m.createProperty(NS+"albumRelease");
    public static final Property termDuration = m.createProperty(NS+"termDuration");
    public static final Property applicationStartDate = m.createProperty(NS+"applicationStartDate");
    public static final Property copyrightNotice = m.createProperty(NS+"copyrightNotice");
    public static final Property medicalAudience = m.createProperty(NS+"medicalAudience");
    public static final Property alignmentType = m.createProperty(NS+"alignmentType");
    public static final Property requiredQuantity = m.createProperty(NS+"requiredQuantity");
    public static final Property productionCompany = m.createProperty(NS+"productionCompany");
    public static final Property assemblyVersion = m.createProperty(NS+"assemblyVersion");
    public static final Property memoryRequirements = m.createProperty(NS+"memoryRequirements");
    public static final Property doseValue = m.createProperty(NS+"doseValue");
    public static final Property intensity = m.createProperty(NS+"intensity");
    public static final Property cholesterolContent = m.createProperty(NS+"cholesterolContent");
    public static final Property contentLocation = m.createProperty(NS+"contentLocation");
    public static final Property accessibilityAPI = m.createProperty(NS+"accessibilityAPI");
    public static final Property copyrightHolder = m.createProperty(NS+"copyrightHolder");
    public static final Property acrissCode = m.createProperty(NS+"acrissCode");
    public static final Property menu = m.createProperty(NS+"menu");
    public static final Property vatID = m.createProperty(NS+"vatID");
    public static final Property disambiguatingDescription = m.createProperty(NS+"disambiguatingDescription");
    public static final Property dateline = m.createProperty(NS+"dateline");
    public static final Property accommodationFloorPlan = m.createProperty(NS+"accommodationFloorPlan");
    public static final Property partOfTrip = m.createProperty(NS+"partOfTrip");
    public static final Property providesBroadcastService = m.createProperty(NS+"providesBroadcastService");
    public static final Property energyEfficiencyScaleMin = m.createProperty(NS+"energyEfficiencyScaleMin");
    public static final Property returnMethod = m.createProperty(NS+"returnMethod");
    public static final Property partOfOrder = m.createProperty(NS+"partOfOrder");
    public static final Property gtin8 = m.createProperty(NS+"gtin8");
    public static final Property serviceUrl = m.createProperty(NS+"serviceUrl");
    public static final Property cvdNumC19Died = m.createProperty(NS+"cvdNumC19Died");
    public static final Property valueName = m.createProperty(NS+"valueName");
    public static final Property athlete = m.createProperty(NS+"athlete");
    public static final Property hasBioPolymerSequence = m.createProperty(NS+"hasBioPolymerSequence");
    public static final Property musicalKey = m.createProperty(NS+"musicalKey");
    public static final Property employmentType = m.createProperty(NS+"employmentType");
    public static final Property dateSent = m.createProperty(NS+"dateSent");
    public static final Property isAvailableGenerically = m.createProperty(NS+"isAvailableGenerically");
    public static final Property productSupported = m.createProperty(NS+"productSupported");
    public static final Property cvdNumICUBeds = m.createProperty(NS+"cvdNumICUBeds");
    public static final Property pregnancyWarning = m.createProperty(NS+"pregnancyWarning");
    public static final Property mainContentOfPage = m.createProperty(NS+"mainContentOfPage");
    public static final Property urlTemplate = m.createProperty(NS+"urlTemplate");
    public static final Property associatedReview = m.createProperty(NS+"associatedReview");
    public static final Property broadcastOfEvent = m.createProperty(NS+"broadcastOfEvent");
    public static final Property printSection = m.createProperty(NS+"printSection");
    public static final Property byMonth = m.createProperty(NS+"byMonth");
    public static final Property followup = m.createProperty(NS+"followup");
    public static final Property minValue = m.createProperty(NS+"minValue");
    public static final Property relatedCondition = m.createProperty(NS+"relatedCondition");
    public static final Property employee = m.createProperty(NS+"employee");
    public static final Property conditionsOfAccess = m.createProperty(NS+"conditionsOfAccess");
    public static final Property installUrl = m.createProperty(NS+"installUrl");
    public static final Property maximumEnrollment = m.createProperty(NS+"maximumEnrollment");
    public static final Property isrcCode = m.createProperty(NS+"isrcCode");
    public static final Property issn = m.createProperty(NS+"issn");
    public static final Property hostingOrganization = m.createProperty(NS+"hostingOrganization");
    public static final Property warranty = m.createProperty(NS+"warranty");
    public static final Property backstory = m.createProperty(NS+"backstory");
    public static final Property size = m.createProperty(NS+"size");
    public static final Property homeTeam = m.createProperty(NS+"homeTeam");
    public static final Property workload = m.createProperty(NS+"workload");
    public static final Property contentReferenceTime = m.createProperty(NS+"contentReferenceTime");
    public static final Property freeShippingThreshold = m.createProperty(NS+"freeShippingThreshold");
    public static final Property proficiencyLevel = m.createProperty(NS+"proficiencyLevel");
    public static final Property occupationalCredentialAwarded = m.createProperty(NS+"occupationalCredentialAwarded");
    public static final Property subEvent = m.createProperty(NS+"subEvent");
    public static final Property includedRiskFactor = m.createProperty(NS+"includedRiskFactor");
    public static final Property rxcui = m.createProperty(NS+"rxcui");
    public static final Property publishingPrinciples = m.createProperty(NS+"publishingPrinciples");
    public static final Property paymentStatus = m.createProperty(NS+"paymentStatus");
    public static final Property sourceOrganization = m.createProperty(NS+"sourceOrganization");
    public static final Property billingAddress = m.createProperty(NS+"billingAddress");
    public static final Property representativeOfPage = m.createProperty(NS+"representativeOfPage");
    public static final Property siblings = m.createProperty(NS+"siblings");
    public static final Property totalJobOpenings = m.createProperty(NS+"totalJobOpenings");
    public static final Property structuralClass = m.createProperty(NS+"structuralClass");
    public static final Property dateModified = m.createProperty(NS+"dateModified");
    public static final Property costPerUnit = m.createProperty(NS+"costPerUnit");
    public static final Property diseasePreventionInfo = m.createProperty(NS+"diseasePreventionInfo");
    public static final Property potentialAction = m.createProperty(NS+"potentialAction");
    public static final Property arrivalTime = m.createProperty(NS+"arrivalTime");
    public static final Property isicV4 = m.createProperty(NS+"isicV4");
    public static final Property suggestedAge = m.createProperty(NS+"suggestedAge");
    public static final Property experienceInPlaceOfEducation = m.createProperty(NS+"experienceInPlaceOfEducation");
    public static final Property acceptedPaymentMethod = m.createProperty(NS+"acceptedPaymentMethod");
    public static final Property financialAidEligible = m.createProperty(NS+"financialAidEligible");
    public static final Property cookTime = m.createProperty(NS+"cookTime");
    public static final Property holdingArchive = m.createProperty(NS+"holdingArchive");
    public static final Property license = m.createProperty(NS+"license");
    public static final Property tissueSample = m.createProperty(NS+"tissueSample");
    public static final Property transitTimeLabel = m.createProperty(NS+"transitTimeLabel");
    public static final Property ratingValue = m.createProperty(NS+"ratingValue");
    public static final Property numberOfCredits = m.createProperty(NS+"numberOfCredits");
    public static final Property releasedEvent = m.createProperty(NS+"releasedEvent");
    public static final Property administrationRoute = m.createProperty(NS+"administrationRoute");
    public static final Property serverStatus = m.createProperty(NS+"serverStatus");
    public static final Property subjectOf = m.createProperty(NS+"subjectOf");
    public static final Property sugarContent = m.createProperty(NS+"sugarContent");
    public static final Property acquiredFrom = m.createProperty(NS+"acquiredFrom");
    public static final Property itemDefectReturnShippingFeesAmount = m.createProperty(NS+"itemDefectReturnShippingFeesAmount");
    public static final Property contactlessPayment = m.createProperty(NS+"contactlessPayment");
    public static final Property highPrice = m.createProperty(NS+"highPrice");
    public static final Property minimumPaymentDue = m.createProperty(NS+"minimumPaymentDue");
    public static final Property maxValue = m.createProperty(NS+"maxValue");
    public static final Property colleague = m.createProperty(NS+"colleague");
    public static final Property healthPlanDrugOption = m.createProperty(NS+"healthPlanDrugOption");
    public static final Property orderDelivery = m.createProperty(NS+"orderDelivery");
    public static final Property permittedUsage = m.createProperty(NS+"permittedUsage");
    public static final Property codeValue = m.createProperty(NS+"codeValue");
    public static final Property mealService = m.createProperty(NS+"mealService");
    public static final Property item = m.createProperty(NS+"item");
    public static final Property orderItemNumber = m.createProperty(NS+"orderItemNumber");
    public static final Property numberOfBathroomsTotal = m.createProperty(NS+"numberOfBathroomsTotal");
    public static final Property serviceOperator = m.createProperty(NS+"serviceOperator");
    public static final Property prescriptionStatus = m.createProperty(NS+"prescriptionStatus");
    public static final Property relatedStructure = m.createProperty(NS+"relatedStructure");
    public static final Property gameItem = m.createProperty(NS+"gameItem");
    public static final Property gtin = m.createProperty(NS+"gtin");
    public static final Property breadcrumb = m.createProperty(NS+"breadcrumb");
    public static final Property maximumVirtualAttendeeCapacity = m.createProperty(NS+"maximumVirtualAttendeeCapacity");
    public static final Property producer = m.createProperty(NS+"producer");
    public static final Property actionOption = m.createProperty(NS+"actionOption");
    public static final Property videoFormat = m.createProperty(NS+"videoFormat");
    public static final Property gtin13 = m.createProperty(NS+"gtin13");
    public static final Property applicationSuite = m.createProperty(NS+"applicationSuite");
    public static final Property sibling = m.createProperty(NS+"sibling");
    public static final Property eventAttendanceMode = m.createProperty(NS+"eventAttendanceMode");
    public static final Property steps = m.createProperty(NS+"steps");
    public static final Property numChildren = m.createProperty(NS+"numChildren");
    public static final Property screenCount = m.createProperty(NS+"screenCount");
    public static final Property sender = m.createProperty(NS+"sender");
    public static final Property departureBusStop = m.createProperty(NS+"departureBusStop");
    public static final Property numberOfPartialBathrooms = m.createProperty(NS+"numberOfPartialBathrooms");
    public static final Property polygon = m.createProperty(NS+"polygon");
    public static final Property storageRequirements = m.createProperty(NS+"storageRequirements");
    public static final Property director = m.createProperty(NS+"director");
    public static final Property codeSampleType = m.createProperty(NS+"codeSampleType");
    public static final Property includedInHealthInsurancePlan = m.createProperty(NS+"includedInHealthInsurancePlan");
    public static final Property boardingGroup = m.createProperty(NS+"boardingGroup");
    public static final Property description = m.createProperty(NS+"description");
    public static final Property observationDate = m.createProperty(NS+"observationDate");
    public static final Property cutoffTime = m.createProperty(NS+"cutoffTime");
    public static final Property acquireLicensePage = m.createProperty(NS+"acquireLicensePage");
    public static final Property produces = m.createProperty(NS+"produces");
    public static final Property participant = m.createProperty(NS+"participant");
    public static final Property dayOfWeek = m.createProperty(NS+"dayOfWeek");
    public static final Property gtin12 = m.createProperty(NS+"gtin12");
    public static final Property children = m.createProperty(NS+"children");
    public static final Property primaryPrevention = m.createProperty(NS+"primaryPrevention");
    public static final Property albumProductionType = m.createProperty(NS+"albumProductionType");
    public static final Property colorist = m.createProperty(NS+"colorist");
    public static final Property shippingLabel = m.createProperty(NS+"shippingLabel");
    public static final Property healthPlanNetworkId = m.createProperty(NS+"healthPlanNetworkId");
    public static final Property geoOverlaps = m.createProperty(NS+"geoOverlaps");
    public static final Property handlingTime = m.createProperty(NS+"handlingTime");
    public static final Property reservedTicket = m.createProperty(NS+"reservedTicket");
    public static final Property overdosage = m.createProperty(NS+"overdosage");
    public static final Property beneficiaryBank = m.createProperty(NS+"beneficiaryBank");
    public static final Property businessDays = m.createProperty(NS+"businessDays");
    public static final Property evidenceLevel = m.createProperty(NS+"evidenceLevel");
    public static final Property founder = m.createProperty(NS+"founder");
    public static final Property readonlyValue = m.createProperty(NS+"readonlyValue");
    public static final Property inProductGroupWithID = m.createProperty(NS+"inProductGroupWithID");
    public static final Property numberOfBeds = m.createProperty(NS+"numberOfBeds");
    public static final Property additionalName = m.createProperty(NS+"additionalName");
    public static final Property supersededBy = m.createProperty(NS+"supersededBy");
    public static final Property monthlyMinimumRepaymentAmount = m.createProperty(NS+"monthlyMinimumRepaymentAmount");
    public static final Property eligibilityToWorkRequirement = m.createProperty(NS+"eligibilityToWorkRequirement");
    public static final Property benefitsSummaryUrl = m.createProperty(NS+"benefitsSummaryUrl");
    public static final Property color = m.createProperty(NS+"color");
    public static final Property inker = m.createProperty(NS+"inker");
    public static final Property material = m.createProperty(NS+"material");
    public static final Property guideline = m.createProperty(NS+"guideline");
    public static final Property negativeNotes = m.createProperty(NS+"negativeNotes");
    public static final Property observedNode = m.createProperty(NS+"observedNode");
    public static final Property dropoffTime = m.createProperty(NS+"dropoffTime");
    public static final Property cvdNumC19HOPats = m.createProperty(NS+"cvdNumC19HOPats");
    public static final Property availableLanguage = m.createProperty(NS+"availableLanguage");
    public static final Property availableTest = m.createProperty(NS+"availableTest");
    public static final Property penciler = m.createProperty(NS+"penciler");
    public static final Property permitAudience = m.createProperty(NS+"permitAudience");
    public static final Property expressedIn = m.createProperty(NS+"expressedIn");
    public static final Property featureList = m.createProperty(NS+"featureList");
    public static final Property ownedFrom = m.createProperty(NS+"ownedFrom");
    public static final Property carrierRequirements = m.createProperty(NS+"carrierRequirements");
    public static final Property greater = m.createProperty(NS+"greater");
    public static final Property sizeGroup = m.createProperty(NS+"sizeGroup");
    public static final Property legislationChanges = m.createProperty(NS+"legislationChanges");
    public static final Property salaryUponCompletion = m.createProperty(NS+"salaryUponCompletion");
    public static final Property recommendationStrength = m.createProperty(NS+"recommendationStrength");
    public static final Property layoutImage = m.createProperty(NS+"layoutImage");
    public static final Property legislationApplies = m.createProperty(NS+"legislationApplies");
    public static final Property eligibleDuration = m.createProperty(NS+"eligibleDuration");
    public static final Property hasPart = m.createProperty(NS+"hasPart");
    public static final Property isVariantOf = m.createProperty(NS+"isVariantOf");
    public static final Property availabilityStarts = m.createProperty(NS+"availabilityStarts");
    public static final Property regionDrained = m.createProperty(NS+"regionDrained");
    public static final Property userInteractionCount = m.createProperty(NS+"userInteractionCount");
    public static final Property mainEntity = m.createProperty(NS+"mainEntity");
    public static final Property headline = m.createProperty(NS+"headline");
    public static final Property genre = m.createProperty(NS+"genre");
    public static final Property sameAs = m.createProperty(NS+"sameAs");
    public static final Property gtin14 = m.createProperty(NS+"gtin14");
    public static final Property spatialCoverage = m.createProperty(NS+"spatialCoverage");
    public static final Property usageInfo = m.createProperty(NS+"usageInfo");
    public static final Property endDate = m.createProperty(NS+"endDate");
    public static final Property recourseLoan = m.createProperty(NS+"recourseLoan");
    public static final Property fatContent = m.createProperty(NS+"fatContent");
    public static final Property logo = m.createProperty(NS+"logo");
    public static final Property follows = m.createProperty(NS+"follows");
    public static final Property members = m.createProperty(NS+"members");
    public static final Property diseaseSpreadStatistics = m.createProperty(NS+"diseaseSpreadStatistics");
    public static final Property byArtist = m.createProperty(NS+"byArtist");
    public static final Property isbn = m.createProperty(NS+"isbn");
    public static final Property diagram = m.createProperty(NS+"diagram");
    public static final Property functionalClass = m.createProperty(NS+"functionalClass");
    public static final Property interactingDrug = m.createProperty(NS+"interactingDrug");
    public static final Property proteinContent = m.createProperty(NS+"proteinContent");
    public static final Property branch = m.createProperty(NS+"branch");
    public static final Property associatedPathophysiology = m.createProperty(NS+"associatedPathophysiology");
    public static final Property printPage = m.createProperty(NS+"printPage");
    public static final Property cvdFacilityCounty = m.createProperty(NS+"cvdFacilityCounty");
    public static final Property relatedTherapy = m.createProperty(NS+"relatedTherapy");
    public static final Property departureStation = m.createProperty(NS+"departureStation");
    public static final Property passengerSequenceNumber = m.createProperty(NS+"passengerSequenceNumber");
    public static final Property repeatCount = m.createProperty(NS+"repeatCount");
    public static final Property typicalTest = m.createProperty(NS+"typicalTest");
    public static final Property doseUnit = m.createProperty(NS+"doseUnit");
    public static final Property illustrator = m.createProperty(NS+"illustrator");
    public static final Property incentives = m.createProperty(NS+"incentives");
    public static final Property availableService = m.createProperty(NS+"availableService");
    public static final Property industry = m.createProperty(NS+"industry");
    public static final Property arrivalTerminal = m.createProperty(NS+"arrivalTerminal");
    public static final Property evidenceOrigin = m.createProperty(NS+"evidenceOrigin");
    public static final Property publicAccess = m.createProperty(NS+"publicAccess");
    public static final Property itemLocation = m.createProperty(NS+"itemLocation");
    public static final Property lowPrice = m.createProperty(NS+"lowPrice");
    public static final Property acceptedAnswer = m.createProperty(NS+"acceptedAnswer");
    public static final Property gamePlatform = m.createProperty(NS+"gamePlatform");
    public static final Property branchOf = m.createProperty(NS+"branchOf");
    public static final Property bitrate = m.createProperty(NS+"bitrate");
    public static final Property mileageFromOdometer = m.createProperty(NS+"mileageFromOdometer");
    public static final Property activityFrequency = m.createProperty(NS+"activityFrequency");
    public static final Property touristType = m.createProperty(NS+"touristType");
    public static final Property loanTerm = m.createProperty(NS+"loanTerm");
    public static final Property previousStartDate = m.createProperty(NS+"previousStartDate");
    public static final Property gettingTestedInfo = m.createProperty(NS+"gettingTestedInfo");
    public static final Property includesObject = m.createProperty(NS+"includesObject");
    public static final Property educationalAlignment = m.createProperty(NS+"educationalAlignment");
    public static final Property isFamilyFriendly = m.createProperty(NS+"isFamilyFriendly");
    public static final Property safetyConsideration = m.createProperty(NS+"safetyConsideration");
    public static final Property productGroupID = m.createProperty(NS+"productGroupID");
    public static final Property containedIn = m.createProperty(NS+"containedIn");
    public static final Property monthsOfExperience = m.createProperty(NS+"monthsOfExperience");
    public static final Property event = m.createProperty(NS+"event");
    public static final Property hasCourse = m.createProperty(NS+"hasCourse");
    public static final Property deliveryTime = m.createProperty(NS+"deliveryTime");
    public static final Property requiredMaxAge = m.createProperty(NS+"requiredMaxAge");
    public static final Property numberOfPages = m.createProperty(NS+"numberOfPages");
    public static final Property recordedIn = m.createProperty(NS+"recordedIn");
    public static final Property maximumIntake = m.createProperty(NS+"maximumIntake");
    public static final Property programMembershipUsed = m.createProperty(NS+"programMembershipUsed");
    public static final Property episode = m.createProperty(NS+"episode");
    public static final Property isAccessibleForFree = m.createProperty(NS+"isAccessibleForFree");
    public static final Property adverseOutcome = m.createProperty(NS+"adverseOutcome");
    public static final Property shippingDetails = m.createProperty(NS+"shippingDetails");
    public static final Property inStoreReturnsOffered = m.createProperty(NS+"inStoreReturnsOffered");
    public static final Property bodyLocation = m.createProperty(NS+"bodyLocation");
    public static final Property typicalAgeRange = m.createProperty(NS+"typicalAgeRange");
    public static final Property geoTouches = m.createProperty(NS+"geoTouches");
    public static final Property additionalVariable = m.createProperty(NS+"additionalVariable");
    public static final Property commentText = m.createProperty(NS+"commentText");
    public static final Property accessMode = m.createProperty(NS+"accessMode");
    public static final Property exerciseRelatedDiet = m.createProperty(NS+"exerciseRelatedDiet");
    public static final Property familyName = m.createProperty(NS+"familyName");
    public static final Property driveWheelConfiguration = m.createProperty(NS+"driveWheelConfiguration");
    public static final Property ticketedSeat = m.createProperty(NS+"ticketedSeat");
    public static final Property geoRadius = m.createProperty(NS+"geoRadius");
    public static final Property grantee = m.createProperty(NS+"grantee");
    public static final Property httpMethod = m.createProperty(NS+"httpMethod");
    public static final Property suggestedAnswer = m.createProperty(NS+"suggestedAnswer");
    public static final Property doesNotShip = m.createProperty(NS+"doesNotShip");
    public static final Property increasesRiskOf = m.createProperty(NS+"increasesRiskOf");
    public static final Property physicalRequirement = m.createProperty(NS+"physicalRequirement");
    public static final Property aspect = m.createProperty(NS+"aspect");
    public static final Property readBy = m.createProperty(NS+"readBy");
    public static final Property recipeCuisine = m.createProperty(NS+"recipeCuisine");
    public static final Property healthCondition = m.createProperty(NS+"healthCondition");
    public static final Property geo = m.createProperty(NS+"geo");
    public static final Property legislationJurisdiction = m.createProperty(NS+"legislationJurisdiction");
    public static final Property originalMediaLink = m.createProperty(NS+"originalMediaLink");
    public static final Property broadcastSubChannel = m.createProperty(NS+"broadcastSubChannel");
    public static final Property floorLimit = m.createProperty(NS+"floorLimit");
    public static final Property recipeYield = m.createProperty(NS+"recipeYield");
    public static final Property softwareRequirements = m.createProperty(NS+"softwareRequirements");
    public static final Property hasDriveThroughService = m.createProperty(NS+"hasDriveThroughService");
    public static final Property softwareAddOn = m.createProperty(NS+"softwareAddOn");
    public static final Property tocEntry = m.createProperty(NS+"tocEntry");
    public static final Property lodgingUnitDescription = m.createProperty(NS+"lodgingUnitDescription");
    public static final Property numberOfAccommodationUnits = m.createProperty(NS+"numberOfAccommodationUnits");
    public static final Property ticketToken = m.createProperty(NS+"ticketToken");
    public static final Property flightNumber = m.createProperty(NS+"flightNumber");
    public static final Property workExample = m.createProperty(NS+"workExample");
    public static final Property unnamedSourcesPolicy = m.createProperty(NS+"unnamedSourcesPolicy");
    public static final Property gameLocation = m.createProperty(NS+"gameLocation");
    public static final Property areaServed = m.createProperty(NS+"areaServed");
    public static final Property hasCourseInstance = m.createProperty(NS+"hasCourseInstance");
    public static final Property reservationId = m.createProperty(NS+"reservationId");
    public static final Property stageAsNumber = m.createProperty(NS+"stageAsNumber");
    public static final Property geoCrosses = m.createProperty(NS+"geoCrosses");
    public static final Property arterialBranch = m.createProperty(NS+"arterialBranch");
    public static final Property encoding = m.createProperty(NS+"encoding");
    public static final Property inChIKey = m.createProperty(NS+"inChIKey");
    public static final Property scheduledPaymentDate = m.createProperty(NS+"scheduledPaymentDate");
    public static final Property alternativeOf = m.createProperty(NS+"alternativeOf");
    public static final Property numAdults = m.createProperty(NS+"numAdults");
    public static final Property webCheckinTime = m.createProperty(NS+"webCheckinTime");
    public static final Property diversityPolicy = m.createProperty(NS+"diversityPolicy");
    public static final Property accountId = m.createProperty(NS+"accountId");
    public static final Property hasMerchantReturnPolicy = m.createProperty(NS+"hasMerchantReturnPolicy");
    public static final Property termCode = m.createProperty(NS+"termCode");
    public static final Property predecessorOf = m.createProperty(NS+"predecessorOf");
    public static final Property directApply = m.createProperty(NS+"directApply");
    public static final Property postalCode = m.createProperty(NS+"postalCode");
    public static final Property educationalFramework = m.createProperty(NS+"educationalFramework");
    public static final Property duns = m.createProperty(NS+"duns");
    public static final Property relatedAnatomy = m.createProperty(NS+"relatedAnatomy");
    public static final Property verificationFactCheckingPolicy = m.createProperty(NS+"verificationFactCheckingPolicy");
    public static final Property returnPolicyCategory = m.createProperty(NS+"returnPolicyCategory");
    public static final Property letterer = m.createProperty(NS+"letterer");
    public static final Property identifyingExam = m.createProperty(NS+"identifyingExam");
    public static final Property actionPlatform = m.createProperty(NS+"actionPlatform");
    public static final Property customerRemorseReturnFees = m.createProperty(NS+"customerRemorseReturnFees");
    public static final Property location = m.createProperty(NS+"location");
    public static final Property box = m.createProperty(NS+"box");
    public static final Property cvdNumC19OFMechVentPats = m.createProperty(NS+"cvdNumC19OFMechVentPats");
    public static final Property healthPlanCopay = m.createProperty(NS+"healthPlanCopay");
    public static final Property text = m.createProperty(NS+"text");
    public static final Property expires = m.createProperty(NS+"expires");
    public static final Property contactOption = m.createProperty(NS+"contactOption");
    public static final Property flightDistance = m.createProperty(NS+"flightDistance");
    public static final Property relevantOccupation = m.createProperty(NS+"relevantOccupation");
    public static final Property bed = m.createProperty(NS+"bed");
    public static final Property nonprofitStatus = m.createProperty(NS+"nonprofitStatus");
    public static final Property currentExchangeRate = m.createProperty(NS+"currentExchangeRate");
    public static final Property possibleTreatment = m.createProperty(NS+"possibleTreatment");
    public static final Property speed = m.createProperty(NS+"speed");
    public static final Property significantLinks = m.createProperty(NS+"significantLinks");
    public static final Property dateIssued = m.createProperty(NS+"dateIssued");
    public static final Property accessibilitySummary = m.createProperty(NS+"accessibilitySummary");
    public static final Property typeOfGood = m.createProperty(NS+"typeOfGood");
    public static final Property percentile25 = m.createProperty(NS+"percentile25");
    public static final Property relevantSpecialty = m.createProperty(NS+"relevantSpecialty");
    public static final Property ownedThrough = m.createProperty(NS+"ownedThrough");
    public static final Property currenciesAccepted = m.createProperty(NS+"currenciesAccepted");
    public static final Property eligibleCustomerType = m.createProperty(NS+"eligibleCustomerType");
    public static final Property linkRelationship = m.createProperty(NS+"linkRelationship");
    public static final Property artist = m.createProperty(NS+"artist");
    public static final Property requiredMinAge = m.createProperty(NS+"requiredMinAge");
    public static final Property infectiousAgent = m.createProperty(NS+"infectiousAgent");
    public static final Property editor = m.createProperty(NS+"editor");
    public static final Property availableChannel = m.createProperty(NS+"availableChannel");
    public static final Property musicBy = m.createProperty(NS+"musicBy");
    public static final Property numberOfRooms = m.createProperty(NS+"numberOfRooms");
    public static final Property partySize = m.createProperty(NS+"partySize");
    public static final Property attendee = m.createProperty(NS+"attendee");
    public static final Property paymentDueDate = m.createProperty(NS+"paymentDueDate");
    public static final Property transitTime = m.createProperty(NS+"transitTime");
    public static final Property tickerSymbol = m.createProperty(NS+"tickerSymbol");
    public static final Property episodes = m.createProperty(NS+"episodes");
    public static final Property reservationFor = m.createProperty(NS+"reservationFor");
    public static final Property runtimePlatform = m.createProperty(NS+"runtimePlatform");
    public static final Property priceCurrency = m.createProperty(NS+"priceCurrency");
    public static final Property entertainmentBusiness = m.createProperty(NS+"entertainmentBusiness");
    public static final Property secondaryPrevention = m.createProperty(NS+"secondaryPrevention");
    public static final Property actionApplication = m.createProperty(NS+"actionApplication");
    public static final Property landlord = m.createProperty(NS+"landlord");
    public static final Property image = m.createProperty(NS+"image");
    public static final Property insertion = m.createProperty(NS+"insertion");
    public static final Property value = m.createProperty(NS+"value");
    public static final Property merchantReturnLink = m.createProperty(NS+"merchantReturnLink");
    public static final Property pathophysiology = m.createProperty(NS+"pathophysiology");
    public static final Property broadcastAffiliateOf = m.createProperty(NS+"broadcastAffiliateOf");
    public static final Property option = m.createProperty(NS+"option");
    public static final Property serialNumber = m.createProperty(NS+"serialNumber");
    public static final Property accountOverdraftLimit = m.createProperty(NS+"accountOverdraftLimit");
    public static final Property editEIDR = m.createProperty(NS+"editEIDR");
    public static final Property cssSelector = m.createProperty(NS+"cssSelector");
    public static final Property exerciseCourse = m.createProperty(NS+"exerciseCourse");
    public static final Property hasHealthAspect = m.createProperty(NS+"hasHealthAspect");
    public static final Property musicCompositionForm = m.createProperty(NS+"musicCompositionForm");
    public static final Property enginePower = m.createProperty(NS+"enginePower");
    public static final Property interactionType = m.createProperty(NS+"interactionType");
    public static final Property associatedClaimReview = m.createProperty(NS+"associatedClaimReview");
    public static final Property variesBy = m.createProperty(NS+"variesBy");
    public static final Property composer = m.createProperty(NS+"composer");
    public static final Property tocContinuation = m.createProperty(NS+"tocContinuation");
    public static final Property geographicArea = m.createProperty(NS+"geographicArea");
    public static final Property timeToComplete = m.createProperty(NS+"timeToComplete");
    public static final Property domainIncludes = m.createProperty(NS+"domainIncludes");
    public static final Property fileFormat = m.createProperty(NS+"fileFormat");
    public static final Property carbohydrateContent = m.createProperty(NS+"carbohydrateContent");
    public static final Property spokenByCharacter = m.createProperty(NS+"spokenByCharacter");
    public static final Property measurementTechnique = m.createProperty(NS+"measurementTechnique");
    public static final Property risks = m.createProperty(NS+"risks");
    public static final Property catalogNumber = m.createProperty(NS+"catalogNumber");
    public static final Property deathPlace = m.createProperty(NS+"deathPlace");
    public static final Property seatingType = m.createProperty(NS+"seatingType");
    public static final Property specialty = m.createProperty(NS+"specialty");
    public static final Property expectedArrivalFrom = m.createProperty(NS+"expectedArrivalFrom");
    public static final Property publication = m.createProperty(NS+"publication");
    public static final Property sport = m.createProperty(NS+"sport");
    public static final Property reviewCount = m.createProperty(NS+"reviewCount");
    public static final Property originAddress = m.createProperty(NS+"originAddress");
    public static final Property equal = m.createProperty(NS+"equal");
    public static final Property firstPerformance = m.createProperty(NS+"firstPerformance");
    public static final Property calories = m.createProperty(NS+"calories");
    public static final Property result = m.createProperty(NS+"result");
    public static final Property review = m.createProperty(NS+"review");
    public static final Property cvdNumBeds = m.createProperty(NS+"cvdNumBeds");
    public static final Property knowsAbout = m.createProperty(NS+"knowsAbout");
    public static final Property diversityStaffingReport = m.createProperty(NS+"diversityStaffingReport");
    public static final Property employerOverview = m.createProperty(NS+"employerOverview");
    public static final Property procedureType = m.createProperty(NS+"procedureType");
    public static final Property startDate = m.createProperty(NS+"startDate");
    public static final Property reportNumber = m.createProperty(NS+"reportNumber");
    public static final Property thumbnail = m.createProperty(NS+"thumbnail");
    public static final Property accessModeSufficient = m.createProperty(NS+"accessModeSufficient");
    public static final Property roofLoad = m.createProperty(NS+"roofLoad");
    public static final Property maxPrice = m.createProperty(NS+"maxPrice");
    public static final Property drainsTo = m.createProperty(NS+"drainsTo");
    public static final Property trainNumber = m.createProperty(NS+"trainNumber");
    public static final Property temporalCoverage = m.createProperty(NS+"temporalCoverage");
    public static final Property eligibleTransactionVolume = m.createProperty(NS+"eligibleTransactionVolume");
    public static final Property additionalType = m.createProperty(NS+"additionalType");
    public static final Property suggestedMeasurement = m.createProperty(NS+"suggestedMeasurement");
    public static final Property seatRow = m.createProperty(NS+"seatRow");
    public static final Property legislationIdentifier = m.createProperty(NS+"legislationIdentifier");
    public static final Property actionableFeedbackPolicy = m.createProperty(NS+"actionableFeedbackPolicy");
    public static final Property inSupportOf = m.createProperty(NS+"inSupportOf");
    public static final Property legalStatus = m.createProperty(NS+"legalStatus");
    public static final Property operatingSystem = m.createProperty(NS+"operatingSystem");
    public static final Property archiveHeld = m.createProperty(NS+"archiveHeld");
    public static final Property mapType = m.createProperty(NS+"mapType");
    public static final Property emissionsCO2 = m.createProperty(NS+"emissionsCO2");
    public static final Property datasetTimeInterval = m.createProperty(NS+"datasetTimeInterval");
    public static final Property muscleAction = m.createProperty(NS+"muscleAction");
    public static final Property modelDate = m.createProperty(NS+"modelDate");
    public static final Property studyDesign = m.createProperty(NS+"studyDesign");
    public static final Property locationCreated = m.createProperty(NS+"locationCreated");
    public static final Property validUntil = m.createProperty(NS+"validUntil");
    public static final Property orderedItem = m.createProperty(NS+"orderedItem");
    public static final Property timeOfDay = m.createProperty(NS+"timeOfDay");
    public static final Property trainingSalary = m.createProperty(NS+"trainingSalary");
    public static final Property broker = m.createProperty(NS+"broker");
    public static final Property audio = m.createProperty(NS+"audio");
    public static final Property opponent = m.createProperty(NS+"opponent");
    public static final Property inPlaylist = m.createProperty(NS+"inPlaylist");
    public static final Property error = m.createProperty(NS+"error");
    public static final Property itemReviewed = m.createProperty(NS+"itemReviewed");
    public static final Property deliveryStatus = m.createProperty(NS+"deliveryStatus");
    public static final Property phoneticText = m.createProperty(NS+"phoneticText");
    public static final Property broadcastSignalModulation = m.createProperty(NS+"broadcastSignalModulation");
    public static final Property lastReviewed = m.createProperty(NS+"lastReviewed");
    public static final Property broadcaster = m.createProperty(NS+"broadcaster");
    public static final Property inCodeSet = m.createProperty(NS+"inCodeSet");
    public static final Property _abstract = m.createProperty(NS+"_abstract");
    public static final Property parent = m.createProperty(NS+"parent");
    public static final Property guidelineDate = m.createProperty(NS+"guidelineDate");
    public static final Property eligibleRegion = m.createProperty(NS+"eligibleRegion");
    public static final Property endorsers = m.createProperty(NS+"endorsers");
    public static final Property firstAppearance = m.createProperty(NS+"firstAppearance");
    public static final Property byDay = m.createProperty(NS+"byDay");
    public static final Property defaultValue = m.createProperty(NS+"defaultValue");
    public static final Property alcoholWarning = m.createProperty(NS+"alcoholWarning");
    public static final Property median = m.createProperty(NS+"median");
    public static final Property discountCode = m.createProperty(NS+"discountCode");
    public static final Property priceComponentType = m.createProperty(NS+"priceComponentType");
    public static final Property softwareVersion = m.createProperty(NS+"softwareVersion");
    public static final Property course = m.createProperty(NS+"course");
    public static final Property toLocation = m.createProperty(NS+"toLocation");
    public static final Property biologicalRole = m.createProperty(NS+"biologicalRole");
    public static final Property pageEnd = m.createProperty(NS+"pageEnd");
    public static final Property chemicalComposition = m.createProperty(NS+"chemicalComposition");
    public static final Property inLanguage = m.createProperty(NS+"inLanguage");
    public static final Property programPrerequisites = m.createProperty(NS+"programPrerequisites");
    public static final Property catalog = m.createProperty(NS+"catalog");
    public static final Property countryOfLastProcessing = m.createProperty(NS+"countryOfLastProcessing");
    public static final Property interactivityType = m.createProperty(NS+"interactivityType");
    public static final Property postalCodeBegin = m.createProperty(NS+"postalCodeBegin");
    public static final Property estimatedSalary = m.createProperty(NS+"estimatedSalary");
    public static final Property iswcCode = m.createProperty(NS+"iswcCode");
    public static final Property partOfSeries = m.createProperty(NS+"partOfSeries");
    public static final Property partOfSeason = m.createProperty(NS+"partOfSeason");
    public static final Property includedDataCatalog = m.createProperty(NS+"includedDataCatalog");
    public static final Property valueReference = m.createProperty(NS+"valueReference");
    public static final Property isResizable = m.createProperty(NS+"isResizable");
    public static final Property lyrics = m.createProperty(NS+"lyrics");
    public static final Property exampleOfWork = m.createProperty(NS+"exampleOfWork");
    public static final Property legislationResponsible = m.createProperty(NS+"legislationResponsible");
    public static final Property gameServer = m.createProperty(NS+"gameServer");
    public static final Property recipeIngredient = m.createProperty(NS+"recipeIngredient");
    public static final Property founders = m.createProperty(NS+"founders");
    public static final Property downloadUrl = m.createProperty(NS+"downloadUrl");
    public static final Property endTime = m.createProperty(NS+"endTime");
    public static final Property knows = m.createProperty(NS+"knows");
    public static final Property hasMenuSection = m.createProperty(NS+"hasMenuSection");
    public static final Property quest = m.createProperty(NS+"quest");
    public static final Property subtitleLanguage = m.createProperty(NS+"subtitleLanguage");
    public static final Property experienceRequirements = m.createProperty(NS+"experienceRequirements");
    public static final Property targetPlatform = m.createProperty(NS+"targetPlatform");
    public static final Property alumni = m.createProperty(NS+"alumni");
    public static final Property competitor = m.createProperty(NS+"competitor");
    public static final Property newsUpdatesAndGuidelines = m.createProperty(NS+"newsUpdatesAndGuidelines");
    public static final Property studySubject = m.createProperty(NS+"studySubject");
    public static final Property itemOffered = m.createProperty(NS+"itemOffered");
    public static final Property offers = m.createProperty(NS+"offers");
    public static final Property fuelCapacity = m.createProperty(NS+"fuelCapacity");
    public static final Property trailerWeight = m.createProperty(NS+"trailerWeight");
    public static final Property returnFees = m.createProperty(NS+"returnFees");
    public static final Property numberOfAvailableAccommodationUnits = m.createProperty(NS+"numberOfAvailableAccommodationUnits");
    public static final Property transFatContent = m.createProperty(NS+"transFatContent");
    public static final Property subTrip = m.createProperty(NS+"subTrip");
    public static final Property relatedDrug = m.createProperty(NS+"relatedDrug");
    public static final Property titleEIDR = m.createProperty(NS+"titleEIDR");
    public static final Property preOp = m.createProperty(NS+"preOp");
    public static final Property loser = m.createProperty(NS+"loser");
    public static final Property encodingFormat = m.createProperty(NS+"encodingFormat");
    public static final Property worstRating = m.createProperty(NS+"worstRating");
    public static final Property uploadDate = m.createProperty(NS+"uploadDate");
    public static final Property energyEfficiencyScaleMax = m.createProperty(NS+"energyEfficiencyScaleMax");
    public static final Property distribution = m.createProperty(NS+"distribution");
    public static final Property target = m.createProperty(NS+"target");
    public static final Property contraindication = m.createProperty(NS+"contraindication");
    public static final Property workTranslation = m.createProperty(NS+"workTranslation");
    public static final Property cvdFacilityId = m.createProperty(NS+"cvdFacilityId");
    public static final Property billingPeriod = m.createProperty(NS+"billingPeriod");
    public static final Property educationRequirements = m.createProperty(NS+"educationRequirements");
    public static final Property availability = m.createProperty(NS+"availability");
    public static final Property numberOfSeasons = m.createProperty(NS+"numberOfSeasons");
    public static final Property reviewRating = m.createProperty(NS+"reviewRating");
    public static final Property model = m.createProperty(NS+"model");
    public static final Property fiberContent = m.createProperty(NS+"fiberContent");
    public static final Property riskFactor = m.createProperty(NS+"riskFactor");
    public static final Property question = m.createProperty(NS+"question");
    public static final Property measuredProperty = m.createProperty(NS+"measuredProperty");
    public static final Property givenName = m.createProperty(NS+"givenName");
    public static final Property schemaVersion = m.createProperty(NS+"schemaVersion");
    public static final Property reviewAspect = m.createProperty(NS+"reviewAspect");
    public static final Property purchaseDate = m.createProperty(NS+"purchaseDate");
    public static final Property tool = m.createProperty(NS+"tool");
    public static final Property valueRequired = m.createProperty(NS+"valueRequired");
    public static final Property fuelConsumption = m.createProperty(NS+"fuelConsumption");
    public static final Property recipe = m.createProperty(NS+"recipe");
    public static final Property bestRating = m.createProperty(NS+"bestRating");
    public static final Property byMonthWeek = m.createProperty(NS+"byMonthWeek");
    public static final Property buyer = m.createProperty(NS+"buyer");
    public static final Property dateRead = m.createProperty(NS+"dateRead");
    public static final Property dataset = m.createProperty(NS+"dataset");
    public static final Property customerRemorseReturnLabelSource = m.createProperty(NS+"customerRemorseReturnLabelSource");
    public static final Property guidelineSubject = m.createProperty(NS+"guidelineSubject");
    public static final Property includedInDataCatalog = m.createProperty(NS+"includedInDataCatalog");
    public static final Property discountCurrency = m.createProperty(NS+"discountCurrency");
    public static final Property startOffset = m.createProperty(NS+"startOffset");
    public static final Property yearlyRevenue = m.createProperty(NS+"yearlyRevenue");
    public static final Property valuePattern = m.createProperty(NS+"valuePattern");
    public static final Property actionStatus = m.createProperty(NS+"actionStatus");
    public static final Property qualifications = m.createProperty(NS+"qualifications");
    public static final Property underName = m.createProperty(NS+"underName");
    public static final Property measuredValue = m.createProperty(NS+"measuredValue");
    public static final Property permissions = m.createProperty(NS+"permissions");
    public static final Property exercisePlan = m.createProperty(NS+"exercisePlan");
    public static final Property playersOnline = m.createProperty(NS+"playersOnline");
    public static final Property email = m.createProperty(NS+"email");
    public static final Property geoContains = m.createProperty(NS+"geoContains");
    public static final Property healthPlanCoinsuranceOption = m.createProperty(NS+"healthPlanCoinsuranceOption");
    public static final Property exchangeRateSpread = m.createProperty(NS+"exchangeRateSpread");
    public static final Property legislationDateVersion = m.createProperty(NS+"legislationDateVersion");
    public static final Property materialExtent = m.createProperty(NS+"materialExtent");
    public static final Property estimatedCost = m.createProperty(NS+"estimatedCost");
    public static final Property bookFormat = m.createProperty(NS+"bookFormat");
    public static final Property serviceOutput = m.createProperty(NS+"serviceOutput");
    public static final Property albumReleaseType = m.createProperty(NS+"albumReleaseType");
    public static final Property engineDisplacement = m.createProperty(NS+"engineDisplacement");
    public static final Property numberOfEmployees = m.createProperty(NS+"numberOfEmployees");
}
