/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.constraint.ValueRangeConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.vocabulary.SHACL;

public class ValueMaxInclusiveConstraint
extends ValueRangeConstraint {
    public ValueMaxInclusiveConstraint(Node value) {
        super(value, SHACL.MaxInclusiveConstraintComponent);
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected String getErrorMessage(Node n) {
        return String.format("Data value %s is not less than or equal to %s", ShLib.displayStr(n), this.nodeValue);
    }

    @Override
    protected boolean test(int r) {
        return 1 == r || 0 == r;
    }

    @Override
    protected String getName() {
        return "maxInclusive";
    }
}

