/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIteratorCheck
extends QueryIteratorWrapper {
    private ExecutionContext execCxt;

    private QueryIteratorCheck(QueryIterator qIter, ExecutionContext execCxt) {
        super(qIter);
        if (qIter instanceof QueryIteratorCheck) {
            Log.warn((Object)this, (String)"Checking checked iterator");
        }
        this.execCxt = execCxt;
    }

    @Override
    public void close() {
        super.close();
        QueryIteratorCheck.checkForOpenIterators(this.execCxt);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        this.iterator.output(out, sCxt);
    }

    public static void checkForOpenIterators(ExecutionContext execContext) {
        QueryIteratorCheck.dump(execContext, false);
    }

    public static QueryIteratorCheck check(QueryIterator qIter, ExecutionContext execCxt) {
        if (qIter instanceof QueryIteratorCheck) {
            return (QueryIteratorCheck)qIter;
        }
        return new QueryIteratorCheck(qIter, execCxt);
    }

    private static void dump(ExecutionContext execContext, boolean includeAll) {
        Iterator<QueryIterator> iterAll;
        if (includeAll && (iterAll = execContext.listAllIterators()) != null) {
            while (iterAll.hasNext()) {
                QueryIterator qIter = iterAll.next();
                QueryIteratorCheck.warn(qIter, "Iterator: ");
            }
        }
        Iterator<QueryIterator> iterOpen = execContext.listOpenIterators();
        while (iterOpen.hasNext()) {
            QueryIterator qIterOpen = iterOpen.next();
            QueryIteratorCheck.warn(qIterOpen, "Open iterator: ");
            iterOpen.remove();
        }
    }

    private static void warn(QueryIterator qIter, String str2) {
        str2 = (String)str2 + Lib.className((Object)qIter);
        if (qIter instanceof QueryIteratorBase) {
            QueryIteratorBase qIterBase = (QueryIteratorBase)qIter;
            QueryIter qIterLN = (QueryIter)qIter;
            str2 = (String)str2 + "/" + qIterLN.getIteratorNumber();
            String x = qIterBase.debug();
            if (x.length() > 0) {
                str2 = (String)str2 + " : " + x;
            }
        }
        Log.warn(QueryIteratorCheck.class, (String)str2);
    }
}

