/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.AbstractTestDyadicDatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.IntersectionDatasetGraph;
import org.junit.Assert;
import org.junit.Test;

public class TestIntersectionDatasetGraph
extends AbstractTestDyadicDatasetGraph {
    public IntersectionDatasetGraph testInstance(DatasetGraph left, DatasetGraph right, Context c) {
        return new IntersectionDatasetGraph(left, right, c);
    }

    @Test
    public void testIntersection() {
        Graph g1 = SSE.parseGraph((String)"(graph (triple <s1> <p1> <o1> ))");
        DatasetGraph dsg1 = DatasetGraphFactory.create((Graph)g1);
        Node graphName1 = NodeFactory.createBlankNode();
        dsg1.addGraph(graphName1, g1);
        Graph g2 = SSE.parseGraph((String)"(graph (triple <s2> <p2> <o2> ))");
        DatasetGraph dsg2 = DatasetGraphFactory.create((Graph)g2);
        Node graphName2 = NodeFactory.createBlankNode();
        dsg2.addGraph(graphName2, g2);
        Node graphName3 = NodeFactory.createBlankNode();
        dsg1.addGraph(graphName3, g1);
        dsg2.addGraph(graphName3, g1);
        IntersectionDatasetGraph dsg = this.testInstance(dsg1, dsg2, Context.emptyContext);
        Assert.assertEquals((long)1L, (long)dsg.size());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(graphName1).isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(graphName2).isEmpty());
        Assert.assertTrue((boolean)g1.isIsomorphicWith(dsg.getGraph(graphName3)));
    }
}

