/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.FmtUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestSerialization {
    static PrefixMapping pmap1 = new PrefixMappingImpl();

    public TestSerialization() {
        pmap1.setNsPrefix("", "http://default/");
        pmap1.setNsPrefix("ex", "http://example/x#");
        pmap1.setNsPrefix("x", "x:");
    }

    @Test
    public void test_URI_1() {
        this.fmtURI_Prefix("http://elsewhere/", "<http://elsewhere/>", pmap1);
    }

    @Test
    public void test_URI_2() {
        this.fmtURI_Prefix("http://example/", "<http://example/>", pmap1);
    }

    @Test
    public void test_URI_3() {
        this.fmtURI_Prefix("http://default/", "<http://default/>", null);
    }

    @Test
    public void test_URI_4() {
        this.fmtURI_Base("http://example/", null, "<http://example/>");
    }

    @Test
    public void test_URI_5() {
        this.fmtURI_Base("http://example/x", "http://example/", "<x>");
    }

    @Test
    public void test_URI_6() {
        this.fmtURI_Base("http://example/x", "http://example/ns#", "<x>");
    }

    @Test
    public void test_URI_7() {
        this.fmtURI_Base("http://example/ns#x", "http://example/ns#", "<#x>");
    }

    @Test
    public void test_URI_8() {
        this.fmtURI_Base("http://example/ns#x", "http://example/ns", "<#x>");
    }

    @Test
    public void test_URI_9() {
        this.fmtURI_Base("http://example/x/y", "http://example/x/", "<y>");
    }

    @Test
    public void test_URI_10() {
        this.fmtURI_Base("http://example/x/y", "http://example/x", "<x/y>");
    }

    @Test
    public void test_URI_11() {
        this.fmtURI_Base("http://example/x/y", "http://example/", "<x/y>");
    }

    @Test
    public void test_PName_1() {
        this.fmtURI_Prefix("http://example/x#abc", "ex:abc", pmap1);
    }

    @Test
    public void test_PName_2() {
        this.fmtURI_Prefix("http://example/x#", "ex:", pmap1);
    }

    @Test
    public void test_PName_3() {
        this.fmtURI_Prefix("http://default/x", ":x", pmap1);
    }

    @Test
    public void test_PName_4() {
        this.fmtURI_Prefix("http://default/", ":", pmap1);
    }

    @Test
    public void test_PName_5() {
        this.fmtURI_Prefix("http://default/0", ":0", pmap1);
    }

    @Test
    public void test_PName_6() {
        this.fmtURI_Prefix("http://example/x#x-1", "ex:x-1", pmap1);
    }

    @Test
    public void test_PName_Bad_1() {
        this.fmtURI_Prefix("http://other/x", "<http://other/x>", pmap1);
    }

    @Test
    public void test_PName_Bad_2() {
        this.fmtURI_Prefix("http://other/x#a", "<http://other/x#a>", pmap1);
    }

    @Test
    public void test_PName_Bad_3() {
        this.fmtURI_Prefix("http://example/x##", "<http://example/x##>", pmap1);
    }

    @Test
    public void test_PName_Bad_4() {
        this.fmtURI_Prefix("http://default/x#a", "<http://default/x#a>", pmap1);
    }

    @Test
    public void test_PName_Bad_5() {
        this.fmtURI_Prefix("http://default/#a", "<http://default/#a>", pmap1);
    }

    @Test
    public void test_PName_Bad_6() {
        this.fmtURI_Prefix("http://example/x/a", "<http://example/x/a>", pmap1);
    }

    @Test
    public void test_PName_Bad_7() {
        this.fmtURI_Prefix("http://example/x.", "<http://example/x.>", pmap1);
    }

    @Test
    public void test_Dots_1() {
        this.fmtURI_Prefix("http://example/x#a.b", "ex:a.b", pmap1);
    }

    @Test
    public void test_Dots_2() {
        this.fmtURI_Prefix("http://example/x#a.b.", "<http://example/x#a.b.>", pmap1);
    }

    @Test
    public void test_Dots_3() {
        this.fmtURI_Prefix("http://example/x#.b", "<http://example/x#.b>", pmap1);
    }

    @Test
    public void testQueryPattern1() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT * { ?s ?p ?o }", true);
    }

    @Test
    public void testQueryPattern2() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT *       { ?s ?p ?o }", true);
    }

    @Test
    public void testQueryComment1() {
        this.test("SELECT * { ?s ?p ?o }", "SELECT *  # Comment\n { ?s ?p ?o }", true);
    }

    @Test
    public void testQuery1() {
        this.test("SELECT * { ?s ?p ?o . [] ?p ?o }", "SELECT ?x { ?s ?p ?o . [] ?p ?o }", false);
    }

    @Test
    public void testQueryExpr1() {
        this.test("SELECT * { ?s ?p ?o . FILTER (?o)}", "SELECT * { ?s ?p ?o   FILTER (?o)}", true);
    }

    @Test
    public void testQueryExpr2() {
        this.test("SELECT * { FILTER (?x = 3)}", "SELECT * { FILTER (?x = 3)}", true);
    }

    @Test
    public void testQueryExpr3() {
        this.test("SELECT * { FILTER (?x != 3)}", "SELECT * { FILTER (?x = 3)}", false);
    }

    @Test
    public void testQueryExpr4() {
        this.test("SELECT * { FILTER (?z && ?x != 3)}", "SELECT * { FILTER (?z && ?x = 3)}", false);
    }

    @Test
    public void testOpToSyntax_01() {
        this.testOpToSyntax("(bgp (triple ?s ?p ?o))", "SELECT * {?s ?p ?o}");
    }

    @Test
    public void testOpToSyntax_02() {
        this.testOpToSyntax("(bgp (triple ?s ?p ?o) (<urn:ex:x> <urn:ex:p> <urn:ex:z>) )", "SELECT * {?s ?p ?o . <urn:ex:x> <urn:ex:p> <urn:ex:z> }");
    }

    @Test
    public void testOpToSyntax_03() {
        this.testOpToSyntax("(table unit)", "SELECT * {}");
    }

    @Test
    public void testOpToSyntax_04() {
        this.testOpToSyntax("(leftjoin (bgp (triple ?s ?p ?o)) (bgp (triple ?a ?b ?c)))", "SELECT * { ?s ?p ?o OPTIONAL { ?a ?b ?c }}");
    }

    @Test
    public void testOpToSyntax_05() {
        this.testOpToSyntax("(leftjoin (bgp (triple ?s ?p ?o)) (bgp (triple ?a ?b ?c)) (> ?z 5))", "SELECT * { ?s ?p ?o OPTIONAL { ?a ?b ?c FILTER(?z > 5) }}");
    }

    @Test
    public void testOpToSyntax_06() {
        this.testOpToSyntax("(path ?s (path* <urn:ex:p>) ?o)", "SELECT * { ?s <urn:ex:p>* ?o }");
    }

    @Test
    public void testOpToSyntax_07() {
        this.testOpToSyntax("(path ?s (path? (alt (path+ <urn:ex:p1>) <urn:ex:p2>)) ?o)", "SELECT * { ?s (<urn:ex:p1>+|<urn:ex:p2>)? ?o }");
    }

    private void testOpToSyntax(String opStr, String queryString) {
        Op op = SSE.parseOp((String)opStr);
        Query queryConverted = OpAsQuery.asQuery((Op)op);
        Query queryExpected = QueryFactory.create((String)queryString, (Syntax)queryConverted.getSyntax());
        Assert.assertEquals((Object)queryExpected, (Object)queryConverted);
    }

    private void test(String qs1, String qs2, boolean result) {
        Query q1 = null;
        Query q2 = null;
        try {
            q1 = QueryFactory.create((String)qs1, (Syntax)Syntax.syntaxSPARQL);
        }
        catch (Exception ex) {
            Assert.fail((String)"Building query 1");
        }
        try {
            q2 = QueryFactory.create((String)qs2, (Syntax)Syntax.syntaxSPARQL);
        }
        catch (Exception ex) {
            Assert.fail((String)"Building query 2");
        }
        boolean b = false;
        try {
            b = q1.equals((Object)q2);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            Assert.fail((String)"Evaluating .equals");
        }
        if (result) {
            Assert.assertTrue((boolean)b);
        } else {
            Assert.assertFalse((boolean)b);
        }
    }

    private void fmtURI_Prefix(String uriStr, String expected, PrefixMapping pmap) {
        String actual = FmtUtils.stringForURI((String)uriStr, (PrefixMapping)pmap);
        if (!expected.equals(actual)) {
            Assert.fail((String)(expected + " => " + actual));
        }
    }

    private void fmtURI_Base(String uriStr, String base, String expected) {
        String actual = FmtUtils.stringForURI((String)uriStr, (String)base, null);
        if (!expected.equals(actual)) {
            Assert.fail((String)(uriStr + "[" + base + "] => Got: " + actual + " Expected: " + expected));
        }
    }
}

