/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.modify.AbstractTestUpdateBase;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateException;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestUpdateGraphMgt
extends AbstractTestUpdateBase {
    static final Node graphIRI = NodeFactory.createURI((String)"http://example/graph");

    @Test
    public void testCreateDrop1() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        UpdateCreate u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        boolean silentMode = true;
        if (!silentMode) {
            try {
                UpdateAction.execute((Update)u, (DatasetGraph)gStore);
                Assert.fail();
            }
            catch (UpdateException updateException) {
                // empty catch block
            }
        }
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, (DatasetGraph)gStore);
        Assert.assertFalse((boolean)gStore.containsGraph(graphIRI));
        if (!silentMode) {
            try {
                UpdateAction.execute((Update)u, (DatasetGraph)gStore);
                Assert.fail();
            }
            catch (UpdateException updateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateDrop2() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        UpdateCreate u = new UpdateCreate(graphIRI);
        UpdateAction.execute((Update)u, (DatasetGraph)gStore);
        u = new UpdateCreate(graphIRI, true);
        UpdateAction.execute((Update)u, (DatasetGraph)gStore);
        Assert.assertTrue((boolean)AbstractTestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
        u = new UpdateDrop(graphIRI);
        UpdateAction.execute((Update)u, (DatasetGraph)gStore);
        Assert.assertFalse((boolean)gStore.containsGraph(graphIRI));
        u = new UpdateDrop(graphIRI, true);
        UpdateAction.execute((Update)u, (DatasetGraph)gStore);
    }

    @Test
    public void testCreateDrop3() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        AbstractTestUpdateGraphMgt.script(gStore, "create-1.ru");
        Assert.assertTrue((boolean)AbstractTestUpdateGraphMgt.graphEmpty(gStore.getGraph(graphIRI)));
    }

    @Test
    public void testCreateDrop4() {
        DatasetGraph gStore = this.getEmptyDatasetGraph();
        gStore.addGraph(graphIRI, GraphFactory.createDefaultGraph());
        AbstractTestUpdateGraphMgt.script(gStore, "drop-1.ru");
        Assert.assertFalse((boolean)gStore.containsGraph(graphIRI));
    }
}

