/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Arrays;
import java.util.Collection;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.Symbol;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRegex {
    private static Object value;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Java Regex", ARQ.javaRegex}, {"Xerces Regex", ARQ.xercesRegex});
    }

    public TestRegex(String name, Symbol setting) {
        ARQ.getContext().set(ARQ.regexImpl, (Object)setting);
    }

    @BeforeClass
    public static void beforeClass() {
        value = ARQ.getContext().get(ARQ.regexImpl);
    }

    @AfterClass
    public static void afterClass() {
        ARQ.getContext().set(ARQ.regexImpl, value);
    }

    @Test
    public void testRegex01() {
        this.regexTest("ABC", "ABC", null, true);
    }

    @Test
    public void testRegex02() {
        this.regexTest("ABC", "abc", null, false);
    }

    @Test
    public void testRegex03() {
        this.regexTest("ABC", "abc", "", false);
    }

    @Test
    public void testRegex04() {
        this.regexTest("ABC", "abc", "i", true);
    }

    @Test
    public void testRegex05() {
        this.regexTest("abc", "B", "i", true);
    }

    @Test
    public void testRegex06() {
        this.regexTest("ABC", "^ABC", null, true);
    }

    @Test
    public void testRegex07() {
        this.regexTest("ABC", "BC", null, true);
    }

    @Test
    public void testRegex08() {
        this.regexTest("ABC", "^BC", null, false);
    }

    @Test
    public void testRegex09() {
        this.regexTest("[[", "[", "q", true);
    }

    public void regexTest(String value, String pattern, String flags, boolean expected) {
        NodeValue s = NodeValue.makeString((String)value);
        E_Regex r = new E_Regex((Expr)s, pattern, flags);
        NodeValue nv = r.eval(BindingFactory.empty(), null);
        boolean b = nv.getBoolean();
        if (b != expected) {
            Assert.fail((String)(this.fmtTest(value, pattern, flags) + " ==> " + b + " expected " + expected));
        }
    }

    private String fmtTest(String value, String pattern, String flags) {
        String tmp = "regex(\"" + value + "\", \"" + pattern + "\"";
        if (flags != null) {
            tmp = tmp + ", \"" + flags + "\"";
        }
        tmp = tmp + ")";
        return tmp;
    }

    @Test(expected=ExprEvalException.class)
    public void testRegexErr1() {
        this.regexTest("ABC", "(", null, false);
    }

    @Test(expected=ExprEvalException.class)
    public void testRegexErr2() {
        this.regexTest("ABC", "abc", "g", false);
    }

    @Test(expected=ExprEvalException.class)
    public void testRegexErr3() {
        this.regexTest("ABC", "abc", "u", false);
    }
}

