/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.JenaRuntime;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeFunctions {
    private static final double accuracyExact = 0.0;
    private static final double accuracyClose = 1.0E-6;

    @Test
    public void testSameTerm1() {
        Node n1 = NodeFactory.createLiteral((String)"xyz");
        Node n2 = NodeFactory.createLiteral((String)"xyz");
        Assert.assertTrue((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    @Test
    public void testSameTerm2() {
        Node n1 = NodeFactory.createLiteral((String)"xyz");
        Node n2 = NodeFactory.createLiteral((String)"abc");
        Assert.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    @Test
    public void testSameTerm3() {
        Node n1 = NodeFactory.createLiteral((String)"xyz");
        Node n2 = NodeFactory.createURI((String)"xyz");
        Assert.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    @Test
    public void testSameTerm4() {
        Node n1 = NodeFactory.createLiteral((String)"xyz");
        Node n2 = NodeFactory.createLiteral((String)"xyz", (RDFDatatype)XSDDatatype.XSDstring);
        if (JenaRuntime.isRDF11) {
            Assert.assertTrue((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
        } else {
            Assert.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
        }
    }

    @Test
    public void testSameTerm5() {
        Node n1 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        Node n2 = NodeFactory.createLiteral((String)"xyz");
        Assert.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    @Test
    public void testSameTerm6() {
        Node n1 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        Node n2 = NodeFactory.createLiteral((String)"xyz", (String)"EN");
        Assert.assertTrue((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    @Test
    public void testRDFtermEquals1() {
        Node n1 = NodeFactory.createURI((String)"xyz");
        Node n2 = NodeFactory.createLiteral((String)"xyz");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
    }

    @Test
    public void testRDFtermEquals2() {
        Node n1 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        Node n2 = NodeFactory.createLiteral((String)"xyz", (String)"EN");
        Assert.assertTrue((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals3() {
        Node n1 = NodeFactory.createLiteral((String)"xyz");
        Node n2 = NodeFactory.createLiteral((String)"xyz", (String)"en");
        NodeFunctions.rdfTermEquals((Node)n1, (Node)n2);
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals4() {
        Node n1 = NodeFactory.createLiteral((String)"123", (RDFDatatype)XSDDatatype.XSDinteger);
        Node n2 = NodeFactory.createLiteral((String)"456", (RDFDatatype)XSDDatatype.XSDinteger);
        Assert.assertTrue((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
    }

    @Test
    public void testRDFtermEquals5() {
        Node n1 = SSE.parseNode((String)"<<:s :p 123>>");
        Node n2 = SSE.parseNode((String)"<<:s :p 123>>");
        Assert.assertTrue((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
    }

    @Test
    public void testRDFtermEquals6() {
        Node n1 = SSE.parseNode((String)"<<:s :p1 123>>");
        Node n2 = SSE.parseNode((String)"<<:s :p2 123>>");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals7() {
        Node n1 = SSE.parseNode((String)"<<:s :p <<:a :b 'abc'>>>>");
        Node n2 = SSE.parseNode((String)"<<:s :p <<:a :b 123>>>>");
        NodeFunctions.rdfTermEquals((Node)n1, (Node)n2);
    }

    @Test(expected=ExprEvalException.class)
    public void testRDFtermEquals8() {
        Node n1 = SSE.parseNode((String)"<<:s :p 123>>");
        Node n2 = SSE.parseNode((String)"<<:s :p 'xyz'>>");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals((Node)n2, (Node)n1));
    }

    @Test
    public void testRDFtermEquals9() {
        Node n1 = SSE.parseNode((String)"<<:s :p 123>>");
        Node n2 = SSE.parseNode((String)"'xyz'");
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
        Assert.assertFalse((boolean)NodeFunctions.rdfTermEquals((Node)n2, (Node)n1));
    }

    @Test
    public void testStr1() {
        NodeValue nv = NodeValue.makeNodeInteger((long)56L);
        NodeValue s = NodeFunctions.str((NodeValue)nv);
        Assert.assertEquals((Object)"56", (Object)s.getString());
    }

    @Test
    public void testStr2() {
        NodeValue nv = NodeValue.makeInteger((long)56L);
        NodeValue s = NodeFunctions.str((NodeValue)nv);
        Assert.assertEquals((Object)"56", (Object)s.getString());
    }

    @Test
    public void testStr3() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (String)"fr", (String)null);
        NodeValue s = NodeFunctions.str((NodeValue)nv);
        Assert.assertEquals((Object)"abc", (Object)s.getString());
    }

    @Test(expected=ExprTypeException.class)
    public void testStr4() {
        Node n = NodeFactory.createBlankNode();
        String s = NodeFunctions.str((Node)n);
    }

    @Test
    public void testDatatype1() {
        NodeValue nv = NodeValue.makeInteger((long)5L);
        Node n = nv.asNode();
        Node r = NodeFunctions.datatype((Node)n);
        Assert.assertEquals((Object)XSD.integer.asNode(), (Object)r);
    }

    @Test
    public void testDatatype2() {
        NodeValue nv = NodeValue.makeInteger((long)5L);
        NodeValue r = NodeFunctions.datatype((NodeValue)nv);
        NodeValue e = NodeValue.makeNode((Node)XSD.integer.asNode());
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testDatatype3() {
        NodeValue nv = NodeValue.makeString((String)"abc");
        NodeValue r = NodeFunctions.datatype((NodeValue)nv);
        NodeValue e = NodeValue.makeNode((Node)XSD.xstring.asNode());
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testDatatype4() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (String)"fr", (String)null);
        NodeValue r = NodeFunctions.datatype((NodeValue)nv);
        NodeValue e = NodeValue.makeNode((Node)NodeConst.rdfLangString);
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test(expected=ExprTypeException.class)
    public void testDatatype5() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example"));
        NodeValue r = NodeFunctions.datatype((NodeValue)nv);
    }

    @Test(expected=ExprTypeException.class)
    public void testDatatype6() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createBlankNode());
        NodeValue r = NodeFunctions.datatype((NodeValue)nv);
    }

    @Test
    public void testLang1() {
        Node n = NodeFactory.createLiteral((String)"abc", (String)"en-gb");
        Assert.assertEquals((Object)"en-gb", (Object)NodeFunctions.lang((Node)n));
    }

    @Test
    public void testLang2() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (String)"en", (String)null);
        NodeValue r = NodeFunctions.lang((NodeValue)nv);
        NodeValue e = NodeValue.makeString((String)"en");
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testLang3() {
        NodeValue nv = NodeValue.makeInteger((long)5L);
        NodeValue r = NodeFunctions.lang((NodeValue)nv);
        NodeValue e = NodeValue.makeString((String)"");
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test
    public void testLang4() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"simple"));
        NodeValue r = NodeFunctions.lang((NodeValue)nv);
        NodeValue e = NodeValue.makeString((String)"");
        Assert.assertEquals((Object)e, (Object)r);
    }

    @Test(expected=ExprTypeException.class)
    public void testLang5() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.lang((NodeValue)nv);
    }

    @Test
    public void testLangMatches1() {
        NodeValue nv = NodeValue.makeString((String)"en");
        NodeValue pat = NodeValue.makeString((String)"en");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
        Assert.assertFalse((boolean)NodeValue.FALSE.equals((Object)r));
    }

    @Test
    public void testLangMatches2() {
        NodeValue nv = NodeValue.makeString((String)"en");
        NodeValue pat = NodeValue.makeString((String)"fr");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
        Assert.assertFalse((boolean)NodeValue.TRUE.equals((Object)r));
    }

    @Test
    public void testLangMatches3() {
        NodeValue nv = NodeValue.makeString((String)"en-gb");
        NodeValue pat = NodeValue.makeString((String)"en-gb");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches4() {
        NodeValue nv = NodeValue.makeString((String)"en-gb");
        NodeValue pat = NodeValue.makeString((String)"en");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches5() {
        NodeValue nv = NodeValue.makeString((String)"abc");
        NodeValue pat = NodeValue.makeString((String)"*");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches6() {
        NodeValue nv = NodeValue.makeString((String)"x-y-z");
        NodeValue pat = NodeValue.makeString((String)"x");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches7() {
        NodeValue nv = NodeValue.makeString((String)"x");
        NodeValue pat = NodeValue.makeString((String)"x-y-z");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testLangMatches8() {
        NodeValue nv = NodeValue.makeString((String)"");
        NodeValue pat = NodeValue.makeString((String)"*");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testLangMatches9() {
        NodeValue nv = NodeValue.makeString((String)"");
        NodeValue pat = NodeValue.makeString((String)"");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testLangMatches10() {
        NodeValue nv = NodeValue.makeString((String)"en");
        NodeValue pat = NodeValue.makeString((String)"");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsIRI_1() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isIRI((NodeValue)nv);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testIsIRI_2() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"http://example/"));
        NodeValue r = NodeFunctions.isIRI((NodeValue)nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsBlank1() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createBlankNode());
        NodeValue r = NodeFunctions.isBlank((NodeValue)nv);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testIsBlank2() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz"));
        NodeValue r = NodeFunctions.isBlank((NodeValue)nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsBlank3() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isBlank((NodeValue)nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testIsLiteral1() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createLiteral((String)"xyz"));
        NodeValue r = NodeFunctions.isLiteral((NodeValue)nv);
        Assert.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    @Test
    public void testIsLiteral2() {
        NodeValue nv = NodeValue.makeNode((Node)NodeFactory.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isLiteral((NodeValue)nv);
        Assert.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    @Test
    public void testCheckAndGetStringLiteral1() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDstring);
        Node n = NodeFunctions.checkAndGetStringLiteral((String)"Test", (NodeValue)nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }

    @Test
    public void testCheckAndGetStringLiteral2() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (RDFDatatype)XSDDatatype.XSDnormalizedString);
        Node n = NodeFunctions.checkAndGetStringLiteral((String)"Test", (NodeValue)nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }

    @Test
    public void testCheckAndGetStringLiteral3() {
        NodeValue nv = NodeValue.makeString((String)"abc");
        Node n = NodeFunctions.checkAndGetStringLiteral((String)"Test", (NodeValue)nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }

    @Test(expected=ExprEvalException.class)
    public void testCheckAndGetStringLiteral4() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (RDFDatatype)RDF.dtLangString);
        Node n = NodeFunctions.checkAndGetStringLiteral((String)"Test", (NodeValue)nv);
        Assert.assertEquals((Object)"abc", (Object)n.getLiteralLexicalForm());
    }
}

