/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.join.AbstractTestJoin;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.expr.ExprList;
import org.junit.Test;

public abstract class AbstractTestInnerJoin
extends AbstractTestJoin {
    @Override
    protected void executeTest(JoinKey joinKey, Table left, Table right, ExprList conditions, Table expectedResults) {
        if (conditions != null) {
            AbstractTestInnerJoin.fail((String)"Conditions on inner join are meaningless (currently)");
        }
        this.executeTestJoin("1", joinKey, left, right, null, expectedResults);
        this.executeTestJoin("2", joinKey, right, left, null, expectedResults);
    }

    @Test
    public void join_basic_1() {
        this.testJoin("a", AbstractTestInnerJoin.table0(), AbstractTestInnerJoin.table0(), AbstractTestInnerJoin.table0());
    }

    @Test
    public void join_basic_2() {
        this.testJoin("a", AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.table0(), AbstractTestInnerJoin.table0());
    }

    @Test
    public void join_basic_3() {
        this.testJoin("a", AbstractTestInnerJoin.tableD1(), AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.tableD1());
    }

    @Test
    public void join_basic_4() {
        this.testJoin("z", AbstractTestInnerJoin.tableD1(), AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.tableD1());
    }

    @Test
    public void join_basic_5() {
        this.testJoin("a", AbstractTestInnerJoin.table0(), AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.table0());
    }

    @Test
    public void join_basic_6() {
        this.testJoin("a", AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.table0(), AbstractTestInnerJoin.table0());
    }

    @Test
    public void join_01() {
        this.testJoin("a", AbstractTestInnerJoin.table0(), AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.table0());
    }

    @Test
    public void join_02() {
        this.testJoin("a", AbstractTestInnerJoin.tableD1(), AbstractTestInnerJoin.table0(), AbstractTestInnerJoin.table0());
    }

    @Test
    public void join_03() {
        this.testJoin("a", AbstractTestInnerJoin.tableD1(), AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD3());
    }

    @Test
    public void join_04() {
        this.testJoin("a", AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.tableD2());
    }

    @Test
    public void join_05() {
        this.testJoin("a", AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD2());
    }

    @Test
    public void join_06() {
        this.testJoin("z", AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD2());
    }

    @Test
    public void join_07() {
        this.testJoin("z", AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.table1(), AbstractTestInnerJoin.tableD2());
    }

    @Test
    public void join_08() {
        this.testJoin("a", AbstractTestInnerJoin.tableD4(), AbstractTestInnerJoin.tableD5(), AbstractTestInnerJoin.tableD4x5());
    }

    @Test
    public void join_09() {
        this.testJoin("a", AbstractTestInnerJoin.tableD5(), AbstractTestInnerJoin.tableD4(), AbstractTestInnerJoin.tableD4x5());
    }

    @Test
    public void join_10() {
        this.testJoin("a", AbstractTestInnerJoin.tableD4(), AbstractTestInnerJoin.tableD6(), AbstractTestInnerJoin.tableD4x6());
    }

    @Test
    public void join_11() {
        this.testJoin("a", AbstractTestInnerJoin.tableD6(), AbstractTestInnerJoin.tableD4(), AbstractTestInnerJoin.tableD4x6());
    }

    @Test
    public void join_12() {
        this.testJoin("z", AbstractTestInnerJoin.tableD1(), AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD3());
    }

    @Test
    public void join_13() {
        this.testJoin("z", AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD1(), AbstractTestInnerJoin.tableD3());
    }

    @Test
    public void join_14() {
        this.testJoin(null, AbstractTestInnerJoin.tableD1(), AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD3());
    }

    @Test
    public void join_skew_01() {
        this.testJoin("x", AbstractTestInnerJoin.tableS1(), AbstractTestInnerJoin.tableS2(), AbstractTestInnerJoin.tableS1J2());
    }

    @Test
    public void join_skew_02() {
        this.testJoin("w", AbstractTestInnerJoin.tableS1(), AbstractTestInnerJoin.tableS2(), AbstractTestInnerJoin.tableS1J2());
    }

    @Test
    public void join_skew_03() {
        this.testJoin(null, AbstractTestInnerJoin.tableS1(), AbstractTestInnerJoin.tableS2(), AbstractTestInnerJoin.tableS1J2());
    }

    public void join_skew_04() {
        JoinKey joinKey = new JoinKey.Builder().add(Var.alloc((String)"x")).add(Var.alloc((String)"w")).build();
        this.testJoinWithKey(joinKey, AbstractTestInnerJoin.tableS1(), AbstractTestInnerJoin.tableS2(), AbstractTestInnerJoin.tableS1J2());
    }

    @Test
    public void join_disjoint_01() {
        this.testJoin("a", AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD8(), AbstractTestInnerJoin.tableD8x2());
    }

    @Test
    public void join_disjoint_02() {
        this.testJoin("z", AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD8(), AbstractTestInnerJoin.tableD8x2());
    }

    @Test
    public void join_disjoint_03() {
        this.testJoin(null, AbstractTestInnerJoin.tableD2(), AbstractTestInnerJoin.tableD8(), AbstractTestInnerJoin.tableD8x2());
    }
}

