/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphSink;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.system.Txn;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecials {
    private static Quad quad = SSE.parseQuad((String)"(:g :s :p :o)");
    private static Triple triple = SSE.parseTriple((String)"(:s :p :o)");
    private static Node gn = SSE.parseNode((String)":gn");

    @Test
    public void zero_basic_1() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Assert.assertFalse((boolean)dsg.find().hasNext());
        Assert.assertTrue((boolean)dsg.supportsTransactionAbort());
        Assert.assertEquals((long)0L, (long)dsg.getDefaultGraph().size());
        Assert.assertFalse((boolean)dsg.getDefaultGraph().getCapabilities().addAllowed());
    }

    @Test
    public void zero_basic_2() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Assert.assertNull((Object)dsg.getGraph(gn));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void zero_add_1() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.add(quad);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void zero_add_2() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.getDefaultGraph().add(triple);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void zero_add_3() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.addGraph(gn, GraphFactory.createGraphMem());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void zero_delete_1() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.delete(quad);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void zero_delete_2() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.getDefaultGraph().delete(triple);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void zero_delete_3() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Test
    public void zero_txn_1() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Txn.executeRead((Transactional)dsg, () -> {});
        Txn.executeWrite((Transactional)dsg, () -> {});
    }

    @Test(expected=JenaTransactionException.class)
    public void zero_txn_2() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.begin(ReadWrite.READ);
        dsg.begin(ReadWrite.READ);
    }

    @Test(expected=JenaTransactionException.class)
    public void zero_txn_3() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.commit();
    }

    @Test(expected=JenaTransactionException.class)
    public void zero_txn_4() {
        DatasetGraph dsg = DatasetGraphZero.create();
        dsg.begin(ReadWrite.WRITE);
        dsg.commit();
        dsg.commit();
    }

    @Test
    public void zero_graph_txn_1() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Graph g = dsg.getDefaultGraph();
        g.getTransactionHandler().execute(() -> {});
    }

    @Test
    public void zero_graph_txn_2() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.begin();
        h.abort();
    }

    @Test(expected=JenaException.class)
    public void zero_graph_txn_3() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.begin();
        h.begin();
    }

    @Test(expected=JenaException.class)
    public void zero_graph_txn_4() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.begin();
        h.commit();
        h.abort();
    }

    @Test(expected=JenaException.class)
    public void zero_graph_txn_5() {
        DatasetGraph dsg = DatasetGraphZero.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.commit();
    }

    @Test
    public void sink_basic_1() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Assert.assertFalse((boolean)dsg.find().hasNext());
        Assert.assertTrue((boolean)dsg.supportsTransactionAbort());
        Assert.assertEquals((long)0L, (long)dsg.getDefaultGraph().size());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().getCapabilities().addAllowed());
    }

    @Test
    public void sink_basic_2() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Assert.assertNull((Object)dsg.getGraph(gn));
    }

    @Test
    public void sink_add_1() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.add(quad);
    }

    @Test
    public void sink_add_2() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.getDefaultGraph().add(triple);
    }

    @Test
    public void sink_add_3() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.addGraph(gn, GraphFactory.createGraphMem());
    }

    @Test
    public void sink_delete_1() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.add(quad);
    }

    @Test
    public void sink_delete_2() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.getDefaultGraph().add(triple);
    }

    @Test
    public void sink_delete_3() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Test
    public void sink_txn_1() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Txn.executeRead((Transactional)dsg, () -> {});
        Txn.executeWrite((Transactional)dsg, () -> {});
    }

    @Test(expected=JenaTransactionException.class)
    public void sink_txn_2() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.begin(ReadWrite.READ);
        dsg.begin(ReadWrite.READ);
    }

    @Test(expected=JenaTransactionException.class)
    public void sink_txn_3() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.commit();
    }

    @Test(expected=JenaTransactionException.class)
    public void sink_txn_4() {
        DatasetGraph dsg = DatasetGraphSink.create();
        dsg.begin(ReadWrite.WRITE);
        dsg.commit();
        dsg.commit();
    }

    @Test
    public void sink_graph_txn_1() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Graph g = dsg.getDefaultGraph();
        g.getTransactionHandler().execute(() -> {});
    }

    @Test
    public void sink_graph_txn_2() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.begin();
        h.abort();
    }

    @Test(expected=JenaException.class)
    public void sink_graph_txn_3() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.begin();
        h.begin();
    }

    @Test(expected=JenaException.class)
    public void sink_graph_txn_4() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.begin();
        h.commit();
        h.abort();
    }

    @Test(expected=JenaException.class)
    public void sink_graph_txn_5() {
        DatasetGraph dsg = DatasetGraphSink.create();
        Graph g = dsg.getDefaultGraph();
        TransactionHandler h = g.getTransactionHandler();
        h.commit();
    }
}

