/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.optimize.TransformPromoteTableEmpty;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestTransformPromoteTableEmpty {
    private Transform t_promote = new TransformPromoteTableEmpty();

    @Test
    public void promote_table_empty_assignment_01() {
        TestTransformPromoteTableEmpty.test("(extend ((?x 1)) (table empty))", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_assignment_02() {
        TestTransformPromoteTableEmpty.test("(assign ((?y 2)) (extend ((?x 1)) (table empty)))", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_assignment_03() {
        OpTable input = OpTable.empty();
        input = OpExtend.create((Op)input, (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(1L)));
        input = OpExtend.create((Op)input, (VarExprList)new VarExprList(Var.alloc((String)"y"), (Expr)new NodeValueInteger(2L)));
        TestTransformPromoteTableEmpty.test((Op)input, this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_join_01() {
        TestTransformPromoteTableEmpty.test("(join (table unit) (table empty))", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_join_02() {
        TestTransformPromoteTableEmpty.test("(join (table empty) (table unit))", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_join_03() {
        TestTransformPromoteTableEmpty.test("(join (table unit) (join (table unit) (table empty)))", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_leftjoin_01() {
        TestTransformPromoteTableEmpty.test("(leftjoin (table unit) (table empty) ())", this.t_promote, "(table unit)");
    }

    @Test
    public void promote_table_empty_leftjoin_02() {
        TestTransformPromoteTableEmpty.test("(leftjoin (table empty) (table unit) ())", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_leftjoin_03() {
        TestTransformPromoteTableEmpty.test("(leftjoin (table unit) (leftjoin (table empty) (table unit) ()) ())", this.t_promote, "(table unit)");
    }

    @Test
    public void promote_table_empty_leftjoin_04() {
        TestTransformPromoteTableEmpty.test("(leftjoin (leftjoin (table empty) (table unit) ()) (table unit) ())", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_union_01() {
        TestTransformPromoteTableEmpty.test("(union (table empty) (table unit))", this.t_promote, "(table unit)");
    }

    @Test
    public void promote_table_empty_union_02() {
        TestTransformPromoteTableEmpty.test("(union (table unit) (table empty))", this.t_promote, "(table unit)");
    }

    @Test
    public void promote_table_empty_union_03() {
        TestTransformPromoteTableEmpty.test("(union (table empty) (table empty))", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_union_04() {
        TestTransformPromoteTableEmpty.test("(union (union (table unit) (table empty)) (union (table empty) (table unit)))", this.t_promote, "(union (table unit) (table unit))");
    }

    @Test
    public void promote_table_empty_union_05() {
        TestTransformPromoteTableEmpty.test("(union (union (table empty) (table empty)) (union (table empty) (table empty)))", this.t_promote, "(table empty)");
    }

    @Test
    public void promote_table_empty_minus_01() {
        TestTransformPromoteTableEmpty.test("(minus (table unit) (table empty))", this.t_promote, "(table unit)");
    }

    @Test
    public void promote_table_empty_minus_02() {
        TestTransformPromoteTableEmpty.test("(minus (table empty) (table unit))", this.t_promote, "(table empty)");
    }

    public static void test(String input, Transform transform, String ... output) {
        Op opInput = SSE.parseOp((String)input);
        TestTransformPromoteTableEmpty.test(opInput, transform, output);
    }

    public static void test(Op input, Transform transform, String ... output) {
        Op opOptimized = Transformer.transform((Transform)transform, (Op)input);
        if (output == null) {
            Assert.assertEquals((Object)input, (Object)opOptimized);
            return;
        }
        Op op3 = SSE.parseOp((String)StrUtils.strjoinNL((String[])output));
        Assert.assertEquals((Object)op3, (Object)opOptimized);
    }
}

