/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.AbstractTestTransform;
import org.apache.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import org.apache.jena.sparql.algebra.optimize.TransformFilterEquality;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Test;

public class TestTransformFilterEquality
extends AbstractTestTransform {
    private Transform t_equality = new TransformFilterEquality();

    @Test
    public void equality01() {
        this.testOp("(filter (= ?x <x>) (bgp ( ?s ?p ?x)) )", this.t_equality, "(assign ((?x <x>)) (bgp ( ?s ?p <x>)) )");
    }

    @Test
    public void equality02() {
        if (JenaRuntime.isRDF11) {
            this.testOp("(filter (= ?x 'x') (bgp ( ?s ?p ?x)) )", this.t_equality, "(assign ((?x 'x')) (bgp ( ?s ?p 'x')) )");
        } else {
            this.testOp("(filter (= ?x 'x') (bgp ( ?s ?p ?x)) )", this.t_equality, null);
        }
    }

    @Test
    public void equality02a() {
        if (JenaRuntime.isRDF11) {
            this.testOp("(filter (= ?x 'x'^^xsd:string) (bgp ( ?s ?p ?x)) )", this.t_equality, "(assign ((?x 'x')) (bgp ( ?s ?p 'x')) )");
        } else {
            this.testOp("(filter (= ?x 'x'^^xsd:string) (bgp ( ?s ?p ?x)) )", this.t_equality, null);
        }
    }

    @Test
    public void equality03() {
        this.testOp("(filter (= ?x 123) (bgp ( ?s ?p ?x)) )", this.t_equality, null);
    }

    @Test
    public void equality05() {
        this.testOp("(filter (= ?x2 <x>) (conditional (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))", this.t_equality, "(filter (= ?x2 <x>) (conditional (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))");
    }

    @Test
    public void equality06() {
        this.testOp("(filter (= ?x <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x))))", this.t_equality, "(assign((?x <x>)) (conditional (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality07() {
        this.testOp("(filter (= ?x <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x <x>)) (conditional (bgp ( ?s ?p <x>))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality08() {
        this.testOp("(filter (= ?x1 <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(filter (= ?x1 <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality09() {
        this.testOp("(filter (= ?x2 <x>) (leftjoin (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))", this.t_equality, "(filter (= ?x2 <x>) (leftjoin (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))");
    }

    @Test
    public void equality10() {
        this.testOp("(filter (= ?x <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x))))", this.t_equality, "(assign((?x <x>)) (leftjoin (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality11() {
        this.testOp("(filter (= ?x <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x <x>)) (leftjoin (bgp ( ?s ?p <x>))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality12() {
        this.testOp("(filter (= ?x1 <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(filter (= ?x1 <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality13() {
        this.testOp("(filter (= ?x1 <x>) (join (bgp ( ?s ?p ?x1))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x1 <x>))  (join (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality14() {
        this.testOp("(filter (= ?x1 <x>) (union (bgp ( ?s ?p ?x1))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x1 <x>))  (union (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality15() {
        this.testOp("(filter (= ?x1 <x>) (leftjoin (leftjoin (table unit) (bgp ( ?s ?p ?x1)) ) (bgp ( ?s ?p ?x1)) ))", this.t_equality, "(filter (= ?x1 <x>)", "   (leftjoin", "     (leftjoin", "       (table unit)", "       (assign ((?x1 <x>)) (bgp (triple ?s ?p <x>)))", "     )", "     (assign ((?x1 <x>)) (bgp (triple ?s ?p <x>)))", "   ))");
    }

    @Test
    public void equality16() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?test <http://localhost/t2>)", "  (leftjoin", "    (bgp (triple ?test ?p1 ?o1))", "      (project (?s1)", "       (bgp (triple ?s1 ?p2 ?o2)))))"});
        this.testOp(qs, this.t_equality, "(assign ((?test <http://localhost/t2>))", "  (leftjoin", "    (bgp (triple <http://localhost/t2> ?p1 ?o1))", "    (project (?s1)", "      (bgp (triple ?s1 ?p2 ?o2)))))");
    }

    @Test
    public void equality17() {
        this.testOp("(filter ((= ?x <http://constant1>) (= ?x <http://constant2>)) (join (bgp (?x <http://p1> ?o1)) (bgp (?x <http://p2> ?o2))))", this.t_equality, null);
    }

    @Test
    public void equality_expression_1() {
        Op op = SSE.parseOp((String)"(filter (= ?o (+ 'a' 'b')) (bgp (?x <http://p2> ?o)))");
        Op op1 = Transformer.transform((Transform)new TransformCopy(), (ExprTransform)new ExprTransformConstantFold(), (Op)op);
        TestTransformFilterEquality.check(op1, this.t_equality, "(assign ((?o 'ab')) (bgp (?x <http://p2> 'ab')) )");
    }

    @Test
    public void equality_path_1() {
        this.testOp("(filter (= ?x <http://constant1/>) (path ?x (path+ :p) ?y))", this.t_equality, "(assign ((?x <http://constant1/>)) (path <http://constant1/> (path+ :p) ?y) )");
    }

    @Test
    public void equality_path_2() {
        this.testOp("(filter (= ?y <http://constant1/>) (path ?x (path+ :p) ?y))", this.t_equality, "(assign ((?y <http://constant1/>)) (path ?x (path+ :p) <http://constant1/>) )");
    }

    @Test
    public void equality_path_3() {
        this.testOp("(filter ((= ?x <http://constant1/>) (= ?y <http://constant2/>)) (path ?x (path+ :p) ?y))", this.t_equality, "(assign ((?x <http://constant1/>) (?y <http://constant2/>)) (path <http://constant1/> (path+ :p) <http://constant2/>) )");
    }

    @Test
    public void equality_path_4() {
        this.testOp("(filter (= ?x <http://constant1/>) (join (bgp (?x :q ?z)) (path ?x (path+ :p) ?y) ))", this.t_equality, "(assign ((?x <http://constant1/>)) (join (bgp (<http://constant1/> :q ?z)) (path <http://constant1/> (path+ :p) ?y) ))");
    }
}

