/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterOp;
import org.junit.Assert;
import org.junit.Test;

public class TestTable {
    @Test
    public void table_01() {
        Table table = TableFactory.createEmpty();
        OpTable opTable = OpTable.create((Table)table);
        String x = TestTable.str((Op)opTable);
        Assert.assertEquals((Object)"(table empty)", (Object)x);
    }

    @Test
    public void table_02() {
        Table table = TableFactory.create();
        table.getVars().add(Var.alloc((String)"a"));
        OpTable opTable = OpTable.create((Table)table);
        String x = TestTable.str((Op)opTable);
        Assert.assertEquals((Object)"(table (vars ?a))", (Object)x);
    }

    @Test
    public void table_03() {
        Table table = TableFactory.create();
        Binding b = BindingFactory.empty();
        table.addBinding(b);
        OpTable opTable = OpTable.create((Table)table);
        String x = TestTable.str((Op)opTable);
        Assert.assertEquals((Object)"(table (vars) (row) )", (Object)x);
    }

    private static String str(Op op) {
        SerializationContext sCxt = new SerializationContext();
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        WriterOp.output((IndentedWriter)out, (Op)op, (SerializationContext)sCxt);
        String x = out.asString();
        return x.trim();
    }
}

