/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.Map;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestOpAsQuery {
    @Test
    public void testBasic01() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { }");
    }

    @Test
    public void testBasic02() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?p ?o }");
    }

    @Test
    public void testBasic03() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?p ?o FILTER(?o > 5) }");
    }

    @Test
    public void testBasic04() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s { ?s ?p ?o FILTER(?o > 5) }");
    }

    @Test
    public void testBind01() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s (?o + 5 AS ?B) { ?s ?p ?o }");
    }

    @Test
    public void testBind02() {
        this.test_roundTripAlegbra("SELECT ?o ?B  { ?s ?p ?o BIND (?o + 5 AS ?B) }");
    }

    @Test
    public void testBind03() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?p ?o BIND (?o + 5 AS ?B)  }");
    }

    @Test
    public void testBind04() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?p ?o BIND(?o+1 AS ?a1) ?x ?q ?v BIND(?v+2 AS ?a2) }", "SELECT * { { ?s ?p ?o BIND(( ?o + 1 ) AS ?a1) } ?x ?q ?v BIND(( ?v + 2 ) AS ?a2) } ");
    }

    @Test
    public void testBind05() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?p ?o BIND(?o+1 AS ?a1) ?x ?q ?v BIND(2 AS ?a2) } ORDER BY ?s", "SELECT * { { { ?s ?p ?o BIND(( ?o + 1 ) AS ?a1) } ?x ?q ?v } BIND(2 AS ?a2) } ORDER BY ?s");
    }

    @Test
    public void testBind06() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?p ?o BIND(?o + 1 AS ?a1) BIND(?v+2 as ?a2) }");
    }

    @Test
    public void testBind07() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { BIND(?o + 1 AS ?a1) BIND(?v+2 as ?a2) }");
    }

    @Test
    public void testOptional01() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { ?s ?p ?o OPTIONAL { ?s ?q ?z FILTER (?foo) } }");
    }

    @Test
    public void testOptional02() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { ?s ?p ?o OPTIONAL { { ?s ?q ?z FILTER (?foo) } } }");
    }

    @Test
    public void testOptional03() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { ?s ?p ?o OPTIONAL { ?s ?p1 ?o1 } OPTIONAL { ?s ?p2 ?o2 } } ");
    }

    @Test
    public void testOptional04() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { ?s ?p ?o OPTIONAL { ?s ?p1 ?o1 } OPTIONAL { ?s ?p2 ?o2 } OPTIONAL { ?s ?p3 ?o3 }} ");
    }

    @Test
    public void testCountStar() {
        TestOpAsQuery.test_roundTripQuery("select (count(*) as ?cs) { ?s ?p ?o }");
    }

    @Test
    public void testCountGroup() {
        TestOpAsQuery.test_roundTripQuery("select (count(?p) as ?cp) { ?s ?p ?o } group by ?s");
    }

    @Test
    public void testCountGroupAs() {
        TestOpAsQuery.test_roundTripQuery("select (count(?p) as ?cp) { ?s ?p ?o }");
    }

    @Test
    public void testDoubleCount() {
        Query[] result = TestOpAsQuery.test_roundTripQuery("select (count(?s) as ?sc) (count(?p) as ?pc) { ?s ?p ?o }");
        Assert.assertEquals((long)2L, (long)result[1].getResultVars().size());
        Assert.assertTrue((boolean)result[1].getResultVars().contains("sc"));
        Assert.assertTrue((boolean)result[1].getResultVars().contains("pc"));
    }

    @Test
    public void testGroupWithExpression() {
        TestOpAsQuery.test_roundTripQuery("SELECT (sample(?a) + 1 AS ?c) {} GROUP BY ?x");
    }

    @Test
    public void testGroupBy_01() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s { ?s ?p ?o } GROUP BY ?s");
    }

    @Test
    public void testGroupBy_02() {
        TestOpAsQuery.test_roundTripQuery("SELECT (count(?p) as ?cp) { ?s ?p ?o } GROUP BY ?s");
    }

    @Test
    public void testGroupBy_03() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s { ?s ?p ?o } GROUP BY ?s HAVING (count(*) > 1 )");
    }

    @Test
    public void testGroupBy_04() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s { ?s ?p ?o } GROUP BY ?s HAVING (?s > 1 )");
    }

    @Test
    public void testGroupBy_05() {
        TestOpAsQuery.test_roundTripQuery("SELECT (count(?p) as ?cp) { ?s ?p ?o } GROUP BY ?s HAVING (?cp > 1 )");
    }

    @Test
    public void testGroupBy_06() {
        TestOpAsQuery.test_roundTripQuery("SELECT (count(?p) as ?cp) { ?s ?p ?o } GROUP BY (abs(?o)) HAVING (?cp > 1 )");
    }

    @Test
    public void testGroupBy_07() {
        TestOpAsQuery.test_roundTripQuery("SELECT (?X+2 AS ?Y) (count(?p) as ?cp) ?Z (1/?X AS ?X1) { ?s ?p ?o } GROUP BY ?Z (abs(?o) AS ?X) HAVING (?cp > 1 )");
    }

    @Test
    public void testGroupBy_08() {
        TestOpAsQuery.test_roundTripQuery("SELECT (count(?p) as ?cp) { ?s ?p ?o } GROUP BY (abs(?o)) HAVING (?cp > 1 )");
    }

    @Test
    public void testGroupBy_09() {
        TestOpAsQuery.test_roundTripQuery("SELECT (count(?p) as ?cp) { ?s ?p ?o } GROUP BY (abs(?o)) ORDER BY (COUNT(*))");
    }

    @Test
    public void testGroupBy_10() {
        TestOpAsQuery.test_roundTripQuery("SELECT (7+count(?p) as ?cp) { ?s ?p ?o } GROUP BY (abs(?o)) HAVING (?cp > 1 && SUM(?o) > 99 ) ORDER BY (6+COUNT(*))");
    }

    @Test
    public void testGroupBy_11() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?X { ?s ?p ?o } GROUP BY (abs(?o) AS ?X) HAVING (?cp > 1 )");
    }

    @Test
    public void testGroupBy_12() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?q ?z {SELECT DISTINCT * { ?s ?p ?o }} }");
    }

    @Test
    public void testGroupBy_13() {
        TestOpAsQuery.test_roundTripQuery("SELECT * { ?s ?p ?o BIND(?o+1 AS ?a1) } ORDER BY ?s");
    }

    @Test
    public void testSubQuery_01() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s { SELECT (count(*) as ?cp) { ?s ?p ?o } }");
    }

    @Test
    public void testSubQuery_02() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s { ?s ?p ?o { SELECT (count(*) as ?cp) { ?s ?p ?o } }}");
    }

    @Test
    public void testSubQuery_03() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s { { SELECT (count(*) as ?cp) { ?s ?p ?o } } ?s ?p ?o }");
    }

    @Test
    public void testSubQuery_04() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { ?s ?p ?o . BIND(?o AS ?x) }");
    }

    @Test
    public void testSubQuery_05() {
        TestOpAsQuery.test_roundTripQuery("SELECT (?o AS ?x) WHERE { ?s ?p ?o .}");
    }

    @Test
    public void testProject1() {
        TestOpAsQuery.test_roundTripQuery("SELECT (?x + 1 AS ?c) {}");
    }

    @Test
    public void testProject2() {
        Query[] result = TestOpAsQuery.test_roundTripQuery("SELECT (?x + 1 AS ?c) ?d {}");
        Assert.assertEquals((long)2L, (long)result[1].getResultVars().size());
        Assert.assertTrue((boolean)result[1].getResultVars().contains("c"));
        Assert.assertTrue((boolean)result[1].getResultVars().contains("d"));
    }

    @Test
    public void testNestedBind() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?c { { } UNION { BIND(?x + 1 AS ?c) } }");
    }

    @Test
    public void testNestedProject() {
        TestOpAsQuery.test_roundTripQuery("SELECT (?x + 1 AS ?c) { { } UNION { } }");
    }

    @Test
    public void testGroupExpression() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?z { } GROUP BY (?x + ?y AS ?z)");
    }

    @Test
    public void testNestedProjectWithGroup() {
        TestOpAsQuery.test_roundTripQuery("SELECT (SAMPLE(?c) as ?s) { {} UNION {BIND(?x + 1 AS ?c)} } GROUP BY ?x");
    }

    @Test
    public void testQuadPatternInDefaultGraph() {
        TestOpAsQuery.test_roundTripQueryQuads("SELECT * WHERE { ?s a ?type }");
    }

    @Test
    public void testGraphClauseUri() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { GRAPH <http://example> { ?s a ?type } }");
    }

    @Test
    public void testGraphClauseComplex() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { GRAPH <http://example> { ?s a ?type . OPTIONAL { ?s <http://label> ?label } } }");
    }

    @Test
    public void testQuadPatternInGraph() {
        TestOpAsQuery.test_roundTripQueryQuads("SELECT * WHERE { GRAPH <http://example> { ?s a ?type } }");
    }

    @Test
    public void testQuadPatternInGraphComplex01() {
        Query[] result = TestOpAsQuery.roundTripQueryQuad("SELECT * WHERE { GRAPH <http://example> { ?s a ?type . OPTIONAL { ?s <http://label> ?label } } }");
        Assert.assertFalse((boolean)result[0].equals(result[1]));
    }

    @Test
    public void testQuadPatternInGraphComplex02() {
        TestOpAsQuery.test_roundTripQueryQuads("SELECT * WHERE { GRAPH <http://example> { ?s a ?type } OPTIONAL { GRAPH <http://example> { ?s <http://label> ?label } } }");
    }

    @Test
    public void testExtend1() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { ?s ?p ?o . BIND(?o AS ?x) }");
    }

    @Test
    public void testExtend2() {
        TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { GRAPH ?g { ?s ?p ?o . BIND(?o AS ?x) } }");
    }

    @Test
    public void testExtend3() {
        String query = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://www.cipe.accamargo.org.br/ontologias/h2tc.owl#>", "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>", "PREFIX mylib: <java:dateadd.lib.pkgfor.arq.>", "", "SELECT ?yearmonth ( count(?document) as ?total )", "{", "    ?document a :Document;", "   :documentDateOfCreation ?date ;", "   :documentType \"exam results\" .", "    BIND( mylib:DateFormat( xsd:string(?date), \"yyyy-MM\" ) as ?yearmonth )", "} group by ?yearmonth"});
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testExtend4() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?key (COUNT(?member) AS ?total) WHERE { ?s ?p ?o . BIND(LCASE(?o) AS ?key) } GROUP BY ?key");
    }

    @Test
    public void testExtendInService() {
        Query[] result = TestOpAsQuery.test_roundTripQuery("SELECT * WHERE { SERVICE <http://example/endpoint> { ?s ?p ?o . BIND(?o AS ?x) } }");
        Assert.assertTrue((boolean)result[1].toString().contains("BIND"));
    }

    @Test
    public void testSubQuery1() {
        TestOpAsQuery.test_roundTripQuery("SELECT ?s WHERE { SELECT ?s ?p WHERE { ?s ?p ?o } }");
    }

    @Test
    public void testSubQuery2() {
        String query = "SELECT ?s ?x WHERE { { SELECT ?s ?p WHERE { ?s ?p ?o } } { SELECT ?x WHERE { ?x ?p ?o } } }";
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testSubQuery3() {
        String query = "SELECT * WHERE { { SELECT ?s ?p WHERE { ?s ?p ?o } } { SELECT ?x WHERE { ?x ?p ?o } } }";
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testAggregatesInSubQuery1() {
        String query = "SELECT ?key ?agg WHERE { SELECT ?key (COUNT(*) AS ?agg) { ?key ?p ?o } GROUP BY ?key }";
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testAggregatesInSubQuery2() {
        this.test_roundTripAlegbra("SELECT * WHERE { { SELECT ?key (COUNT(*) AS ?agg) { ?key ?p ?o } GROUP BY ?key } }");
    }

    @Test
    public void testAggregatesInSubQuery3() {
        String queryString = "PREFIX dcterms: <http://purl.org/dc/terms/> \nPREFIX dbpedia: <http://dbpedia.org/resource/> \nSELECT ?num_of_holidays ?celebrate_Chinese_New_Year WHERE { \n{SELECT ?country_cat (COUNT(?holiday) as ?num_of_holidays) \nWHERE {?country_cat <http://www.w3.org/2004/02/skos/core#broader> <http://dbpedia.org/resource/Category:Public_holidays_by_country>. \n?holiday dcterms:subject ?country_cat \n}GROUP by ?country_cat \n} \n{ \nSELECT ?country_cat (COUNT(?holiday) as ?celebrate_Chinese_New_Year) \nWHERE { \n?country_cat <http://www.w3.org/2004/02/skos/core#broader> <http://dbpedia.org/resource/Category:Public_holidays_by_country>. \n?holiday dcterms:subject ?country_cat \nFILTER(?holiday=\"http://dbpedia.org/resource/Lunar_New_Year's_Day\") \n}GROUP by ?country_cat \n} \n}\n";
        TestOpAsQuery.test_roundTripQuery(queryString);
    }

    @Test
    public void testModifiersOnSubQuery1() {
        String query = StrUtils.strjoinNL((String[])new String[]{"SELECT (COUNT(*) as ?count) {", "  SELECT DISTINCT ?uri ?graph WHERE {", "    GRAPH ?graph {", "      ?uri ?p ?o .", "      }", "    } LIMIT 1", "}"});
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testModifiersOnSubQuery2() {
        String query = StrUtils.strjoinNL((String[])new String[]{"SELECT (COUNT(*) as ?count) {", "  SELECT REDUCED ?uri ?graph WHERE {", "    GRAPH ?graph {", "      ?uri ?p ?o .", "      }", "    } LIMIT 1", "}"});
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testModifiersOnSubQuery3() {
        String query = StrUtils.strjoinNL((String[])new String[]{"SELECT (COUNT(*) as ?count) {", "  SELECT ?uri ?graph WHERE {", "    GRAPH ?graph {", "      ?uri ?p ?o .", "      }", "    } LIMIT 1", "}"});
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testModifiersOnSubQuery4() {
        String query = StrUtils.strjoinNL((String[])new String[]{"SELECT (COUNT(*) as ?count) {", "  SELECT ?uri ?graph WHERE {", "    GRAPH ?graph {", "      ?uri ?p ?o .", "      }", "    } OFFSET 1", "}"});
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testPathExpressions1() {
        String query = "PREFIX : <http://example/> SELECT * { ?s :p* ?o . ?x :r 123 . }";
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testPathExpressions2() {
        String query = "PREFIX : <http://example/> SELECT * { ?s :p*/:q ?o . ?x :r 123 . }";
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testMinus1() {
        TestOpAsQuery.test_roundTripQuery("PREFIX : <http://example/> SELECT * { ?s :p ?o MINUS { ?s :q ?v .FILTER(?v<5) } }");
    }

    @Test
    public void testMinus2() {
        String query = "PREFIX : <http://example/> SELECT * { ?s :p ?o OPTIONAL { ?s :x ?2 } MINUS { ?s :q ?v .FILTER(?v<5) } }";
        this.test_roundTripAlegbra(query);
    }

    @Test
    public void testTable1() {
        String query = "SELECT * WHERE { ?x ?p ?z . VALUES ?y { } }";
        TestOpAsQuery.roundTripQuery(query);
    }

    @Test
    public void testTable2() {
        String qs = "SELECT * WHERE { ?x ?p ?z . VALUES ?y { } }";
        Query query = QueryFactory.create((String)qs);
        Op op = Algebra.compile((Query)query);
        String x = op.toString();
        Op op1 = SSE.parseOp((String)x);
        Query query2 = OpAsQuery.asQuery((Op)op1);
        Assert.assertEquals((Object)query, (Object)query2);
    }

    @Test
    public void testValues1() {
        String query = "SELECT  * { VALUES ?x {1 2} ?s ?p ?x }";
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testValues2() {
        String query = "SELECT  * { ?s ?p ?x  VALUES ?x {1 2} }";
        TestOpAsQuery.test_roundTripQuery(query);
    }

    @Test
    public void testAlgebra01() {
        String opStr = "(sequence (bgp (?s1 ?p1 ?o1)) (bgp (?s2 ?p2 ?o2)) )";
        String query = "SELECT * { ?s1 ?p1 ?o1. ?s2 ?p2 ?o2}";
        TestOpAsQuery.test_AlgebraToQuery(opStr, query);
    }

    @Test
    public void testAlgebra02() {
        String opStr = "(sequence (bgp (?s1 ?p1 ?o1)) (path ?x (path* :p) ?z) )";
        String query = "PREFIX : <http://example/> SELECT * { ?s1 ?p1 ?o1. ?x :p* ?z}";
        TestOpAsQuery.test_AlgebraToQuery(opStr, query);
    }

    @Test
    public void testAlgebra03() {
        String opStr = "(sequence  (path ?x (path* :p) ?z) (bgp (?s1 ?p1 ?o1)) )";
        String query = "PREFIX : <http://example/> SELECT * { ?x :p* ?z . ?s1 ?p1 ?o1. }";
        TestOpAsQuery.test_AlgebraToQuery(opStr, query);
    }

    public static void test_equivalentQuery(String input, String expected) {
        Query orig = QueryFactory.create((String)input, (Syntax)Syntax.syntaxSPARQL_11);
        Op toReconstruct = Algebra.compile((Query)orig);
        Query got = OpAsQuery.asQuery((Op)toReconstruct);
        Query result = QueryFactory.create((String)expected, (Syntax)Syntax.syntaxSPARQL_11);
        Assert.assertEquals((Object)result, (Object)got);
    }

    public static Query[] test_roundTripQuery(String query) {
        Query[] r = TestOpAsQuery.roundTripQuery(query);
        TestOpAsQuery.stripNamespacesAndBase(r[0]);
        TestOpAsQuery.stripNamespacesAndBase(r[1]);
        Assert.assertEquals((Object)r[0], (Object)r[1]);
        return r;
    }

    public static void test_roundTripQuery(String query, String outcome) {
        Query[] r = TestOpAsQuery.roundTripQuery(query);
        Query orig = r[0];
        Query output = r[1];
        Query q2 = QueryFactory.create((String)outcome);
        TestOpAsQuery.stripNamespacesAndBase(orig);
        TestOpAsQuery.stripNamespacesAndBase(output);
        TestOpAsQuery.stripNamespacesAndBase(q2);
        Assert.assertEquals((Object)q2, (Object)output);
    }

    public static Query[] test_roundTripQueryQuads(String query) {
        Query[] r = TestOpAsQuery.roundTripQueryQuad(query);
        Assert.assertEquals((Object)r[0], (Object)r[1]);
        return r;
    }

    public void test_roundTripAlegbra(String query) {
        Query[] r = TestOpAsQuery.roundTripQuery(query);
        Op a1 = Algebra.compile((Query)r[0]);
        Op a2 = Algebra.compile((Query)r[1]);
        Assert.assertEquals((Object)a1, (Object)a2);
    }

    public static void test_AlgebraToQuery(String input, String expected) {
        Op op = SSE.parseOp((String)input);
        Query orig = QueryFactory.create((String)expected, (Syntax)Syntax.syntaxSPARQL_11);
        TestOpAsQuery.stripNamespacesAndBase(orig);
        Query got = OpAsQuery.asQuery((Op)op);
        Assert.assertEquals((Object)orig, (Object)got);
    }

    private static Query[] roundTripQuery(String query) {
        Query orig = QueryFactory.create((String)query, (Syntax)Syntax.syntaxSPARQL_11);
        Op toReconstruct = Algebra.compile((Query)orig);
        Query got = OpAsQuery.asQuery((Op)toReconstruct);
        Query[] r = new Query[]{orig, got};
        return r;
    }

    private static Query[] roundTripQueryQuad(String query) {
        Query orig = QueryFactory.create((String)query, (Syntax)Syntax.syntaxSPARQL_11);
        Op toReconstruct = Algebra.compile((Query)orig);
        toReconstruct = Algebra.toQuadForm((Op)toReconstruct);
        Query got = OpAsQuery.asQuery((Op)toReconstruct);
        Query[] r = new Query[]{orig, got};
        return r;
    }

    protected static void stripNamespacesAndBase(Query q) {
        Map prefixes = q.getPrefixMapping().getNsPrefixMap();
        for (String prefix : prefixes.keySet()) {
            q.getPrefixMapping().removeNsPrefix(prefix);
        }
        q.setBaseURI((String)null);
    }
}

