/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.IsoMatcher;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamRDFThrift {
    private static final String DIR = "testing/RIOT/RDF-Thrift";
    static String gs = StrUtils.strjoinNL((String[])new String[]{"(graph", "  (_:a :p 123) ", "  (_:a :p 'foo'@en) ", "  (_:b :p '456') ", "  (_:b :p '456.5') ", "  (_:b :p '456.5e6') ", ")"});
    static Graph graph = SSE.parseGraph((String)gs);
    static String dgs = StrUtils.strjoinNL((String[])new String[]{"(dataset", "  (graph (:s1 :p _:a) (:s2 :p _:a))", "  (graph :g  (:s1 :p _:a))", "  (graph _:a (:s2 :p _:a))", ")"});
    static DatasetGraph datasetGraph = SSE.parseDatasetGraph((String)dgs);

    @Test
    public void graph_01() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamRDF stream = BinRDF.streamToOutputStream((OutputStream)out, (boolean)true);
        StreamRDFOps.graphToStream((Graph)graph, (StreamRDF)stream);
        byte[] bytes = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Graph g2 = GraphFactory.createGraphMem();
        StreamRDF stream2 = StreamRDFLib.graph((Graph)g2);
        BinRDF.inputStreamToStream((InputStream)in, (StreamRDF)stream2);
        boolean b = IsoMatcher.isomorphic((Graph)graph, (Graph)g2);
        if (!b) {
            RDFDataMgr.write((OutputStream)System.out, (Graph)graph, (Lang)Lang.TTL);
            System.out.println("---------");
            RDFDataMgr.write((OutputStream)System.out, (Graph)g2, (Lang)Lang.TTL);
            System.out.println("=========");
        }
        Assert.assertTrue((boolean)b);
        TestStreamRDFThrift.sameTerms(graph, g2);
    }

    @Test
    public void graph_02() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamRDFWriter.write((OutputStream)out, (Graph)graph, (Lang)Lang.RDFTHRIFT, null);
        byte[] bytes = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Graph g2 = GraphFactory.createGraphMem();
        RDFDataMgr.read((Graph)g2, (InputStream)in, (Lang)Lang.RDFTHRIFT);
        boolean b = IsoMatcher.isomorphic((Graph)graph, (Graph)g2);
        Assert.assertTrue((boolean)b);
        TestStreamRDFThrift.sameTerms(graph, g2);
    }

    @Test
    public void dataset_01() {
        DatasetGraph dsg1 = datasetGraph;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamRDF stream = BinRDF.streamToOutputStream((OutputStream)out);
        StreamRDFOps.datasetToStream((DatasetGraph)dsg1, (StreamRDF)stream);
        byte[] bytes = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DatasetGraph dsg2 = DatasetGraphFactory.create();
        StreamRDF stream2 = StreamRDFLib.dataset((DatasetGraph)dsg2);
        BinRDF.inputStreamToStream((InputStream)in, (StreamRDF)stream2);
        boolean b = IsoMatcher.isomorphic((DatasetGraph)dsg1, (DatasetGraph)dsg2);
        Assert.assertTrue((boolean)b);
        Node obj = (Node)Iter.first((Iterator)dsg1.listGraphNodes(), Node::isBlank);
        TestStreamRDFThrift.termAsObject(dsg1, obj);
    }

    @Test
    public void dataset_02() {
        DatasetGraph dsg1 = datasetGraph;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamRDFWriter.write((OutputStream)out, (DatasetGraph)dsg1, (Lang)Lang.RDFTHRIFT);
        byte[] bytes = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DatasetGraph dsg2 = DatasetGraphFactory.create();
        StreamRDF stream2 = StreamRDFLib.dataset((DatasetGraph)dsg2);
        BinRDF.inputStreamToStream((InputStream)in, (StreamRDF)stream2);
        boolean b = IsoMatcher.isomorphic((DatasetGraph)dsg1, (DatasetGraph)dsg2);
        Assert.assertTrue((boolean)b);
        Node obj = (Node)Iter.first((Iterator)dsg1.listGraphNodes(), Node::isBlank);
        TestStreamRDFThrift.termAsObject(dsg1, obj);
    }

    static void sameTerms(Graph g1, Graph g2) {
        Assert.assertEquals((long)g1.size(), (long)g2.size());
        ExtendedIterator iter = g1.find(null, null, null);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            g2.contains(t);
        }
    }

    static void termAsObject(DatasetGraph dsg, Node term) {
        Iterator iter = dsg.find();
        while (iter.hasNext()) {
            Quad quad = (Quad)iter.next();
            if (!quad.getObject().equals((Object)term)) continue;
            return;
        }
        Assert.fail((String)("Failed to find " + term));
    }
}

